/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.streaming;

import ai2.org.apache.poi.hssf.util.PaneInformation;
import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.usermodel.AutoFilter;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.CellRange;
import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.ss.usermodel.Comment;
import ai2.org.apache.poi.ss.usermodel.DataValidation;
import ai2.org.apache.poi.ss.usermodel.DataValidationHelper;
import ai2.org.apache.poi.ss.usermodel.Drawing;
import ai2.org.apache.poi.ss.usermodel.Footer;
import ai2.org.apache.poi.ss.usermodel.Header;
import ai2.org.apache.poi.ss.usermodel.PrintSetup;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.usermodel.Sheet;
import ai2.org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.SheetUtil;
import ai2.org.apache.poi.xssf.streaming.SXSSFRow;
import ai2.org.apache.poi.xssf.streaming.SXSSFWorkbook;
import ai2.org.apache.poi.xssf.streaming.SheetDataWriter;
import ai2.org.apache.poi.xssf.usermodel.XSSFDataValidation;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SXSSFSheet
implements Sheet,
Cloneable {
    XSSFSheet _sh;
    private SXSSFWorkbook _workbook;
    private TreeMap<Integer, SXSSFRow> _rows = new TreeMap();
    private SheetDataWriter _writer;
    private int _randomAccessWindowSize = 100;
    private int outlineLevelRow = 0;
    private int lastFlushedRowNumber = -1;
    private boolean allFlushed = false;

    public SXSSFSheet(SXSSFWorkbook sXSSFWorkbook, XSSFSheet xSSFSheet) throws IOException {
        this._workbook = sXSSFWorkbook;
        this._sh = xSSFSheet;
        this._writer = sXSSFWorkbook.createSheetDataWriter();
        this.setRandomAccessWindowSize(this._workbook.getRandomAccessWindowSize());
    }

    SheetDataWriter getSheetDataWriter() {
        return this._writer;
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        this.flushRows(0);
        this._writer.close();
        return this._writer.getWorksheetXMLInputStream();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    @Override
    public SXSSFRow createRow(int n) {
        int n2 = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid row number (" + n + ") outside allowable range (0.." + n2 + ")");
        }
        if (n <= this._writer.getLastFlushedRow()) {
            throw new IllegalArgumentException("Attempting to write a row[" + n + "] " + "in the range [0," + this._writer.getLastFlushedRow() + "] that is already written to disk.");
        }
        if (this._sh.getPhysicalNumberOfRows() > 0 && n <= this._sh.getLastRowNum()) {
            throw new IllegalArgumentException("Attempting to write a row[" + n + "] " + "in the range [0," + this._sh.getLastRowNum() + "] that is already written to disk.");
        }
        SXSSFRow sXSSFRow = n > 0 ? this.getRow(n - 1) : null;
        int n3 = 0;
        if (sXSSFRow != null) {
            n3 = sXSSFRow.getLastCellNum();
        }
        if (n3 <= 0 && this._writer.getNumberOfFlushedRows() > 0) {
            n3 = this._writer.getNumberOfCellsOfLastFlushedRow();
        }
        if (n3 <= 0) {
            n3 = 10;
        }
        SXSSFRow sXSSFRow2 = new SXSSFRow(this, n3);
        this._rows.put(n, sXSSFRow2);
        this.allFlushed = false;
        if (this._randomAccessWindowSize >= 0 && this._rows.size() > this._randomAccessWindowSize) {
            try {
                this.flushRows(this._randomAccessWindowSize);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return sXSSFRow2;
    }

    @Override
    public void removeRow(Row row) {
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        Iterator<Map.Entry<Integer, SXSSFRow>> iterator = this._rows.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, SXSSFRow> entry = iterator.next();
            if (entry.getValue() != row) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public SXSSFRow getRow(int n) {
        return this._rows.get(n);
    }

    @Override
    public int getPhysicalNumberOfRows() {
        return this._rows.size() + this._writer.getNumberOfFlushedRows();
    }

    @Override
    public int getFirstRowNum() {
        if (this._writer.getNumberOfFlushedRows() > 0) {
            return this._writer.getLowestIndexOfFlushedRows();
        }
        return this._rows.size() == 0 ? 0 : this._rows.firstKey();
    }

    @Override
    public int getLastRowNum() {
        return this._rows.size() == 0 ? 0 : this._rows.lastKey();
    }

    @Override
    public void setColumnHidden(int n, boolean bl) {
        this._sh.setColumnHidden(n, bl);
    }

    @Override
    public boolean isColumnHidden(int n) {
        return this._sh.isColumnHidden(n);
    }

    @Override
    public void setColumnWidth(int n, int n2) {
        this._sh.setColumnWidth(n, n2);
    }

    @Override
    public int getColumnWidth(int n) {
        return this._sh.getColumnWidth(n);
    }

    @Override
    public float getColumnWidthInPixels(int n) {
        return this._sh.getColumnWidthInPixels(n);
    }

    @Override
    public void setDefaultColumnWidth(int n) {
        this._sh.setDefaultColumnWidth(n);
    }

    @Override
    public int getDefaultColumnWidth() {
        return this._sh.getDefaultColumnWidth();
    }

    @Override
    public short getDefaultRowHeight() {
        return this._sh.getDefaultRowHeight();
    }

    @Override
    public float getDefaultRowHeightInPoints() {
        return this._sh.getDefaultRowHeightInPoints();
    }

    @Override
    public void setDefaultRowHeight(short s) {
        this._sh.setDefaultRowHeight(s);
    }

    @Override
    public void setDefaultRowHeightInPoints(float f) {
        this._sh.setDefaultRowHeightInPoints(f);
    }

    @Override
    public CellStyle getColumnStyle(int n) {
        return this._sh.getColumnStyle(n);
    }

    @Override
    public int addMergedRegion(CellRangeAddress cellRangeAddress) {
        return this._sh.addMergedRegion(cellRangeAddress);
    }

    @Override
    public void setVerticallyCenter(boolean bl) {
        this._sh.setVerticallyCenter(bl);
    }

    @Override
    public void setHorizontallyCenter(boolean bl) {
        this._sh.setHorizontallyCenter(bl);
    }

    @Override
    public boolean getHorizontallyCenter() {
        return this._sh.getHorizontallyCenter();
    }

    @Override
    public boolean getVerticallyCenter() {
        return this._sh.getVerticallyCenter();
    }

    @Override
    public void removeMergedRegion(int n) {
        this._sh.removeMergedRegion(n);
    }

    @Override
    public int getNumMergedRegions() {
        return this._sh.getNumMergedRegions();
    }

    @Override
    public CellRangeAddress getMergedRegion(int n) {
        return this._sh.getMergedRegion(n);
    }

    @Override
    public List<CellRangeAddress> getMergedRegions() {
        return this._sh.getMergedRegions();
    }

    @Override
    public Iterator<Row> rowIterator() {
        Iterator<Row> iterator = this._rows.values().iterator();
        return iterator;
    }

    @Override
    public void setAutobreaks(boolean bl) {
        this._sh.setAutobreaks(bl);
    }

    @Override
    public void setDisplayGuts(boolean bl) {
        this._sh.setDisplayGuts(bl);
    }

    @Override
    public void setDisplayZeros(boolean bl) {
        this._sh.setDisplayZeros(bl);
    }

    @Override
    public boolean isDisplayZeros() {
        return this._sh.isDisplayZeros();
    }

    @Override
    public void setRightToLeft(boolean bl) {
        this._sh.setRightToLeft(bl);
    }

    @Override
    public boolean isRightToLeft() {
        return this._sh.isRightToLeft();
    }

    @Override
    public void setFitToPage(boolean bl) {
        this._sh.setFitToPage(bl);
    }

    @Override
    public void setRowSumsBelow(boolean bl) {
        this._sh.setRowSumsBelow(bl);
    }

    @Override
    public void setRowSumsRight(boolean bl) {
        this._sh.setRowSumsRight(bl);
    }

    @Override
    public boolean getAutobreaks() {
        return this._sh.getAutobreaks();
    }

    @Override
    public boolean getDisplayGuts() {
        return this._sh.getDisplayGuts();
    }

    @Override
    public boolean getFitToPage() {
        return this._sh.getFitToPage();
    }

    @Override
    public boolean getRowSumsBelow() {
        return this._sh.getRowSumsBelow();
    }

    @Override
    public boolean getRowSumsRight() {
        return this._sh.getRowSumsRight();
    }

    @Override
    public boolean isPrintGridlines() {
        return this._sh.isPrintGridlines();
    }

    @Override
    public void setPrintGridlines(boolean bl) {
        this._sh.setPrintGridlines(bl);
    }

    @Override
    public PrintSetup getPrintSetup() {
        return this._sh.getPrintSetup();
    }

    @Override
    public Header getHeader() {
        return this._sh.getHeader();
    }

    @Override
    public Footer getFooter() {
        return this._sh.getFooter();
    }

    @Override
    public void setSelected(boolean bl) {
        this._sh.setSelected(bl);
    }

    @Override
    public double getMargin(short s) {
        return this._sh.getMargin(s);
    }

    @Override
    public void setMargin(short s, double d) {
        this._sh.setMargin(s, d);
    }

    @Override
    public boolean getProtect() {
        return this._sh.getProtect();
    }

    @Override
    public void protectSheet(String string) {
        this._sh.protectSheet(string);
    }

    @Override
    public boolean getScenarioProtect() {
        return this._sh.getScenarioProtect();
    }

    @Override
    public void setZoom(int n, int n2) {
        this._sh.setZoom(n, n2);
    }

    @Override
    public short getTopRow() {
        return this._sh.getTopRow();
    }

    @Override
    public short getLeftCol() {
        return this._sh.getLeftCol();
    }

    @Override
    public void showInPane(int n, int n2) {
        this._sh.showInPane(n, n2);
    }

    @Override
    public void showInPane(short s, short s2) {
        this._sh.showInPane(s, s2);
    }

    @Override
    public void setForceFormulaRecalculation(boolean bl) {
        this._sh.setForceFormulaRecalculation(bl);
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        return this._sh.getForceFormulaRecalculation();
    }

    @Override
    public void shiftRows(int n, int n2, int n3) {
        throw new RuntimeException("NotImplemented");
    }

    @Override
    public void shiftRows(int n, int n2, int n3, boolean bl, boolean bl2) {
        throw new RuntimeException("NotImplemented");
    }

    @Override
    public void createFreezePane(int n, int n2, int n3, int n4) {
        this._sh.createFreezePane(n, n2, n3, n4);
    }

    @Override
    public void createFreezePane(int n, int n2) {
        this._sh.createFreezePane(n, n2);
    }

    @Override
    public void createSplitPane(int n, int n2, int n3, int n4, int n5) {
        this._sh.createSplitPane(n, n2, n3, n4, n5);
    }

    @Override
    public PaneInformation getPaneInformation() {
        return this._sh.getPaneInformation();
    }

    @Override
    public void setDisplayGridlines(boolean bl) {
        this._sh.setDisplayGridlines(bl);
    }

    @Override
    public boolean isDisplayGridlines() {
        return this._sh.isDisplayGridlines();
    }

    @Override
    public void setDisplayFormulas(boolean bl) {
        this._sh.setDisplayFormulas(bl);
    }

    @Override
    public boolean isDisplayFormulas() {
        return this._sh.isDisplayFormulas();
    }

    @Override
    public void setDisplayRowColHeadings(boolean bl) {
        this._sh.setDisplayRowColHeadings(bl);
    }

    @Override
    public boolean isDisplayRowColHeadings() {
        return this._sh.isDisplayRowColHeadings();
    }

    @Override
    public void setRowBreak(int n) {
        this._sh.setRowBreak(n);
    }

    @Override
    public boolean isRowBroken(int n) {
        return this._sh.isRowBroken(n);
    }

    @Override
    public void removeRowBreak(int n) {
        this._sh.removeRowBreak(n);
    }

    @Override
    public int[] getRowBreaks() {
        return this._sh.getRowBreaks();
    }

    @Override
    public int[] getColumnBreaks() {
        return this._sh.getColumnBreaks();
    }

    @Override
    public void setColumnBreak(int n) {
        this._sh.setColumnBreak(n);
    }

    @Override
    public boolean isColumnBroken(int n) {
        return this._sh.isColumnBroken(n);
    }

    @Override
    public void removeColumnBreak(int n) {
        this._sh.removeColumnBreak(n);
    }

    @Override
    public void setColumnGroupCollapsed(int n, boolean bl) {
        this._sh.setColumnGroupCollapsed(n, bl);
    }

    @Override
    public void groupColumn(int n, int n2) {
        this._sh.groupColumn(n, n2);
    }

    @Override
    public void ungroupColumn(int n, int n2) {
        this._sh.ungroupColumn(n, n2);
    }

    @Override
    public void groupRow(int n, int n2) {
        for (SXSSFRow sXSSFRow : this._rows.subMap(n, n2 + 1).values()) {
            int n3 = sXSSFRow.getOutlineLevel() + 1;
            sXSSFRow.setOutlineLevel(n3);
            if (n3 <= this.outlineLevelRow) continue;
            this.outlineLevelRow = n3;
        }
        this.setWorksheetOutlineLevelRow();
    }

    public void setRowOutlineLevel(int n, int n2) {
        SXSSFRow sXSSFRow = this._rows.get(n);
        sXSSFRow.setOutlineLevel(n2);
        if (n2 > 0 && n2 > this.outlineLevelRow) {
            this.outlineLevelRow = n2;
            this.setWorksheetOutlineLevelRow();
        }
    }

    private void setWorksheetOutlineLevelRow() {
        CTSheetFormatPr cTSheetFormatPr;
        CTWorksheet cTWorksheet = this._sh.getCTWorksheet();
        CTSheetFormatPr cTSheetFormatPr2 = cTSheetFormatPr = cTWorksheet.isSetSheetFormatPr() ? cTWorksheet.getSheetFormatPr() : cTWorksheet.addNewSheetFormatPr();
        if (this.outlineLevelRow > 0) {
            cTSheetFormatPr.setOutlineLevelRow((short)this.outlineLevelRow);
        }
    }

    @Override
    public void ungroupRow(int n, int n2) {
        this._sh.ungroupRow(n, n2);
    }

    @Override
    public void setRowGroupCollapsed(int n, boolean bl) {
        if (!bl) {
            throw new RuntimeException("Not Implemented");
        }
        this.collapseRow(n);
    }

    private void collapseRow(int n) {
        SXSSFRow sXSSFRow = this.getRow(n);
        if (sXSSFRow == null) {
            throw new IllegalArgumentException("Invalid row number(" + n + "). Row does not exist.");
        }
        int n2 = this.findStartOfRowOutlineGroup(n);
        int n3 = this.writeHidden(sXSSFRow, n2, true);
        SXSSFRow sXSSFRow2 = this.getRow(n3);
        if (sXSSFRow2 != null) {
            sXSSFRow2.setCollapsed(true);
        } else {
            SXSSFRow sXSSFRow3 = this.createRow(n3);
            sXSSFRow3.setCollapsed(true);
        }
    }

    private int findStartOfRowOutlineGroup(int n) {
        SXSSFRow sXSSFRow = this.getRow(n);
        int n2 = sXSSFRow.getOutlineLevel();
        if (n2 == 0) {
            throw new IllegalArgumentException("Outline level is zero for the row (" + n + ").");
        }
        int n3 = n;
        while (this.getRow(n3) != null) {
            if (this.getRow(n3).getOutlineLevel() < n2) {
                return n3 + 1;
            }
            --n3;
        }
        return n3 + 1;
    }

    private int writeHidden(SXSSFRow sXSSFRow, int n, boolean bl) {
        int n2 = sXSSFRow.getOutlineLevel();
        SXSSFRow sXSSFRow2 = this.getRow(n);
        while (sXSSFRow2 != null && sXSSFRow2.getOutlineLevel() >= n2) {
            sXSSFRow2.setHidden(bl);
            sXSSFRow2 = this.getRow(++n);
        }
        return n;
    }

    @Override
    public void setDefaultColumnStyle(int n, CellStyle cellStyle) {
        this._sh.setDefaultColumnStyle(n, cellStyle);
    }

    @Override
    public void autoSizeColumn(int n) {
        this.autoSizeColumn(n, false);
    }

    @Override
    public void autoSizeColumn(int n, boolean bl) {
        double d = SheetUtil.getColumnWidth(this, n, bl);
        if (d != -1.0) {
            int n2 = 65280;
            if ((d *= 256.0) > (double)n2) {
                d = n2;
            }
            this.setColumnWidth(n, (int)d);
        }
    }

    @Override
    public Comment getCellComment(int n, int n2) {
        return this._sh.getCellComment(n, n2);
    }

    @Override
    public Drawing createDrawingPatriarch() {
        return this._sh.createDrawingPatriarch();
    }

    @Override
    public SXSSFWorkbook getWorkbook() {
        return this._workbook;
    }

    @Override
    public String getSheetName() {
        return this._sh.getSheetName();
    }

    @Override
    public boolean isSelected() {
        return this._sh.isSelected();
    }

    @Override
    public CellRange<? extends Cell> setArrayFormula(String string, CellRangeAddress cellRangeAddress) {
        return this._sh.setArrayFormula(string, cellRangeAddress);
    }

    @Override
    public CellRange<? extends Cell> removeArrayFormula(Cell cell) {
        return this._sh.removeArrayFormula(cell);
    }

    @Override
    public DataValidationHelper getDataValidationHelper() {
        return this._sh.getDataValidationHelper();
    }

    public List<XSSFDataValidation> getDataValidations() {
        return this._sh.getDataValidations();
    }

    @Override
    public void addValidationData(DataValidation dataValidation) {
        this._sh.addValidationData(dataValidation);
    }

    @Override
    public AutoFilter setAutoFilter(CellRangeAddress cellRangeAddress) {
        return this._sh.setAutoFilter(cellRangeAddress);
    }

    @Override
    public SheetConditionalFormatting getSheetConditionalFormatting() {
        return this._sh.getSheetConditionalFormatting();
    }

    @Override
    public CellRangeAddress getRepeatingRows() {
        return this._sh.getRepeatingRows();
    }

    @Override
    public CellRangeAddress getRepeatingColumns() {
        return this._sh.getRepeatingColumns();
    }

    @Override
    public void setRepeatingRows(CellRangeAddress cellRangeAddress) {
        this._sh.setRepeatingRows(cellRangeAddress);
    }

    @Override
    public void setRepeatingColumns(CellRangeAddress cellRangeAddress) {
        this._sh.setRepeatingColumns(cellRangeAddress);
    }

    public void setRandomAccessWindowSize(int n) {
        if (n == 0 || n < -1) {
            throw new IllegalArgumentException("RandomAccessWindowSize must be either -1 or a positive integer");
        }
        this._randomAccessWindowSize = n;
    }

    public boolean areAllRowsFlushed() {
        return this.allFlushed;
    }

    public int getLastFlushedRowNum() {
        return this.lastFlushedRowNumber;
    }

    public void flushRows(int n) throws IOException {
        while (this._rows.size() > n) {
            this.flushOneRow();
        }
        if (n == 0) {
            this.allFlushed = true;
        }
    }

    public void flushRows() throws IOException {
        this.flushRows(0);
    }

    private void flushOneRow() throws IOException {
        Integer n = this._rows.firstKey();
        if (n != null) {
            int n2 = n;
            SXSSFRow sXSSFRow = this._rows.get(n);
            this._writer.writeRow(n2, sXSSFRow);
            this._rows.remove(n);
            this.lastFlushedRowNumber = n2;
        }
    }

    public void changeRowNum(SXSSFRow sXSSFRow, int n) {
        this.removeRow(sXSSFRow);
        this._rows.put(n, sXSSFRow);
    }

    public int getRowNum(SXSSFRow sXSSFRow) {
        for (Map.Entry<Integer, SXSSFRow> entry : this._rows.entrySet()) {
            if (entry.getValue() != sXSSFRow) continue;
            return entry.getKey();
        }
        return -1;
    }

    boolean dispose() throws IOException {
        if (!this.allFlushed) {
            this.flushRows();
        }
        return this._writer.dispose();
    }

    @Override
    public int getColumnOutlineLevel(int n) {
        return this._sh.getColumnOutlineLevel(n);
    }
}

