/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.streaming;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.xssf.streaming.SXSSFCell;
import ai2.org.apache.poi.xssf.streaming.SXSSFSheet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SXSSFRow
implements Row {
    SXSSFSheet _sheet;
    SXSSFCell[] _cells;
    int _maxColumn = -1;
    short _style = (short)-1;
    short _height = (short)-1;
    boolean _zHeight = false;
    int _outlineLevel = 0;
    Boolean _hidden;
    Boolean _collapsed;

    public SXSSFRow(SXSSFSheet sXSSFSheet, int n) {
        this._sheet = sXSSFSheet;
        this._cells = new SXSSFCell[n];
    }

    public Iterator<Cell> allCellsIterator() {
        return new CellIterator();
    }

    public boolean hasCustomHeight() {
        return this._height != -1;
    }

    @Override
    public int getOutlineLevel() {
        return this._outlineLevel;
    }

    void setOutlineLevel(int n) {
        this._outlineLevel = n;
    }

    public Boolean getHidden() {
        return this._hidden;
    }

    public void setHidden(Boolean bl) {
        this._hidden = bl;
    }

    public Boolean getCollapsed() {
        return this._collapsed;
    }

    public void setCollapsed(Boolean bl) {
        this._collapsed = bl;
    }

    @Override
    public Iterator<Cell> iterator() {
        return new FilledCellIterator();
    }

    @Override
    public SXSSFCell createCell(int n) {
        return this.createCell(n, 3);
    }

    @Override
    public SXSSFCell createCell(int n, int n2) {
        SXSSFRow.checkBounds(n);
        if (n >= this._cells.length) {
            SXSSFCell[] sXSSFCellArray = new SXSSFCell[Math.max(n + 1, this._cells.length * 2)];
            System.arraycopy(this._cells, 0, sXSSFCellArray, 0, this._cells.length);
            this._cells = sXSSFCellArray;
        }
        this._cells[n] = new SXSSFCell(this, n2);
        if (n > this._maxColumn) {
            this._maxColumn = n;
        }
        return this._cells[n];
    }

    private static void checkBounds(int n) {
        SpreadsheetVersion spreadsheetVersion = SpreadsheetVersion.EXCEL2007;
        int n2 = SpreadsheetVersion.EXCEL2007.getLastColumnIndex();
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid column index (" + n + ").  Allowable column range for " + spreadsheetVersion.name() + " is (0.." + n2 + ") or ('A'..'" + spreadsheetVersion.getLastColumnName() + "')");
        }
    }

    @Override
    public void removeCell(Cell cell) {
        int n = this.getCellIndex(cell);
        if (n >= 0) {
            this._cells[n] = null;
            while (this._maxColumn >= 0 && this._cells[this._maxColumn] == null) {
                --this._maxColumn;
            }
        }
    }

    int getCellIndex(Cell cell) {
        for (int i = 0; i <= this._maxColumn; ++i) {
            if (this._cells[i] != cell) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setRowNum(int n) {
        this._sheet.changeRowNum(this, n);
    }

    @Override
    public int getRowNum() {
        return this._sheet.getRowNum(this);
    }

    @Override
    public SXSSFCell getCell(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Cell index must be >= 0");
        }
        SXSSFCell sXSSFCell = n > this._maxColumn ? null : this._cells[n];
        Row.MissingCellPolicy missingCellPolicy = this._sheet.getWorkbook().getMissingCellPolicy();
        if (missingCellPolicy == RETURN_NULL_AND_BLANK) {
            return sXSSFCell;
        }
        if (missingCellPolicy == RETURN_BLANK_AS_NULL) {
            if (sXSSFCell == null) {
                return sXSSFCell;
            }
            if (sXSSFCell.getCellType() == 3) {
                return null;
            }
            return sXSSFCell;
        }
        if (missingCellPolicy == CREATE_NULL_AS_BLANK) {
            if (sXSSFCell == null) {
                return this.createCell((short)n, 3);
            }
            return sXSSFCell;
        }
        throw new IllegalArgumentException("Illegal policy " + missingCellPolicy + " (" + missingCellPolicy.id + ")");
    }

    @Override
    public Cell getCell(int n, Row.MissingCellPolicy missingCellPolicy) {
        SXSSFCell sXSSFCell = this.getCell(n);
        if (missingCellPolicy == RETURN_NULL_AND_BLANK) {
            return sXSSFCell;
        }
        if (missingCellPolicy == RETURN_BLANK_AS_NULL) {
            if (sXSSFCell == null) {
                return sXSSFCell;
            }
            if (sXSSFCell.getCellType() == 3) {
                return null;
            }
            return sXSSFCell;
        }
        if (missingCellPolicy == CREATE_NULL_AS_BLANK) {
            if (sXSSFCell == null) {
                return this.createCell(n, 3);
            }
            return sXSSFCell;
        }
        throw new IllegalArgumentException("Illegal policy " + missingCellPolicy + " (" + missingCellPolicy.id + ")");
    }

    @Override
    public short getFirstCellNum() {
        for (int i = 0; i <= this._maxColumn; ++i) {
            if (this._cells[i] == null) continue;
            return (short)i;
        }
        return -1;
    }

    @Override
    public short getLastCellNum() {
        return this._maxColumn == -1 ? (short)-1 : (short)(this._maxColumn + 1);
    }

    @Override
    public int getPhysicalNumberOfCells() {
        int n = 0;
        for (int i = 0; i <= this._maxColumn; ++i) {
            if (this._cells[i] == null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void setHeight(short s) {
        this._height = s;
    }

    @Override
    public void setZeroHeight(boolean bl) {
        this._zHeight = bl;
    }

    @Override
    public boolean getZeroHeight() {
        return this._zHeight;
    }

    @Override
    public void setHeightInPoints(float f) {
        this._height = f == -1.0f ? (short)-1 : (short)(f * 20.0f);
    }

    @Override
    public short getHeight() {
        return (short)(this._height == -1 ? this.getSheet().getDefaultRowHeightInPoints() * 20.0f : (float)this._height);
    }

    @Override
    public float getHeightInPoints() {
        return (float)(this._height == -1 ? (double)this.getSheet().getDefaultRowHeightInPoints() : (double)this._height / 20.0);
    }

    @Override
    public boolean isFormatted() {
        return this._style > -1;
    }

    @Override
    public CellStyle getRowStyle() {
        if (!this.isFormatted()) {
            return null;
        }
        return this.getSheet().getWorkbook().getCellStyleAt(this._style);
    }

    @Override
    public void setRowStyle(CellStyle cellStyle) {
        if (cellStyle == null) {
            this._style = (short)-1;
            return;
        }
        this._style = cellStyle.getIndex();
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return this.iterator();
    }

    @Override
    public SXSSFSheet getSheet() {
        return this._sheet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CellIterator
    implements Iterator<Cell> {
        int pos = 0;

        @Override
        public boolean hasNext() {
            return this.pos <= SXSSFRow.this._maxColumn;
        }

        @Override
        public Cell next() throws NoSuchElementException {
            if (this.hasNext()) {
                return SXSSFRow.this._cells[this.pos++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FilledCellIterator
    implements Iterator<Cell> {
        int pos = 0;

        FilledCellIterator() {
            for (int i = 0; i <= SXSSFRow.this._maxColumn; ++i) {
                if (SXSSFRow.this._cells[i] == null) continue;
                this.pos = i;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos <= SXSSFRow.this._maxColumn;
        }

        void advanceToNext() {
            ++this.pos;
            while (this.pos <= SXSSFRow.this._maxColumn && SXSSFRow.this._cells[this.pos] == null) {
                ++this.pos;
            }
        }

        @Override
        public Cell next() throws NoSuchElementException {
            if (this.hasNext()) {
                SXSSFCell sXSSFCell = SXSSFRow.this._cells[this.pos];
                this.advanceToNext();
                return sXSSFCell;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

