/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.streaming;

import ai2.org.apache.poi.ss.formula.EvaluationCell;
import ai2.org.apache.poi.ss.formula.IStabilityClassifier;
import ai2.org.apache.poi.ss.formula.WorkbookEvaluator;
import ai2.org.apache.poi.ss.formula.udf.UDFFinder;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xssf.streaming.SXSSFCell;
import ai2.org.apache.poi.xssf.streaming.SXSSFEvaluationCell;
import ai2.org.apache.poi.xssf.streaming.SXSSFEvaluationWorkbook;
import ai2.org.apache.poi.xssf.streaming.SXSSFSheet;
import ai2.org.apache.poi.xssf.streaming.SXSSFWorkbook;
import ai2.org.apache.poi.xssf.usermodel.BaseXSSFFormulaEvaluator;

public final class SXSSFFormulaEvaluator
extends BaseXSSFFormulaEvaluator {
    private static POILogger logger = POILogFactory.getLogger(SXSSFFormulaEvaluator.class);
    private SXSSFWorkbook wb;

    public SXSSFFormulaEvaluator(SXSSFWorkbook sXSSFWorkbook) {
        this(sXSSFWorkbook, null, null);
    }

    private SXSSFFormulaEvaluator(SXSSFWorkbook sXSSFWorkbook, IStabilityClassifier iStabilityClassifier, UDFFinder uDFFinder) {
        this(sXSSFWorkbook, new WorkbookEvaluator(SXSSFEvaluationWorkbook.create(sXSSFWorkbook), iStabilityClassifier, uDFFinder));
    }

    private SXSSFFormulaEvaluator(SXSSFWorkbook sXSSFWorkbook, WorkbookEvaluator workbookEvaluator) {
        super(workbookEvaluator);
        this.wb = sXSSFWorkbook;
    }

    public static SXSSFFormulaEvaluator create(SXSSFWorkbook sXSSFWorkbook, IStabilityClassifier iStabilityClassifier, UDFFinder uDFFinder) {
        return new SXSSFFormulaEvaluator(sXSSFWorkbook, iStabilityClassifier, uDFFinder);
    }

    protected EvaluationCell toEvaluationCell(Cell cell) {
        if (!(cell instanceof SXSSFCell)) {
            throw new IllegalArgumentException("Unexpected type of cell: " + cell.getClass() + "." + " Only SXSSFCells can be evaluated.");
        }
        return new SXSSFEvaluationCell((SXSSFCell)cell);
    }

    public SXSSFCell evaluateInCell(Cell cell) {
        this.doEvaluateInCell(cell);
        return (SXSSFCell)cell;
    }

    public static void evaluateAllFormulaCells(SXSSFWorkbook sXSSFWorkbook, boolean bl) {
        SXSSFSheet sXSSFSheet;
        int n;
        SXSSFFormulaEvaluator sXSSFFormulaEvaluator = new SXSSFFormulaEvaluator(sXSSFWorkbook);
        for (n = 0; n < sXSSFWorkbook.getNumberOfSheets(); ++n) {
            sXSSFSheet = sXSSFWorkbook.getSheetAt(n);
            if (!sXSSFSheet.areAllRowsFlushed()) continue;
            throw new SheetsFlushedException();
        }
        for (n = 0; n < sXSSFWorkbook.getNumberOfSheets(); ++n) {
            sXSSFSheet = sXSSFWorkbook.getSheetAt(n);
            int n2 = sXSSFSheet.getLastFlushedRowNum();
            if (n2 > -1) {
                if (!bl) {
                    throw new RowFlushedException(0);
                }
                logger.log(3, new Object[]{"Rows up to " + n2 + " have already been flushed, skipping"});
            }
            for (Row row : sXSSFSheet) {
                for (Cell cell : row) {
                    if (cell.getCellType() != 2) continue;
                    sXSSFFormulaEvaluator.evaluateFormulaCell(cell);
                }
            }
        }
    }

    public void evaluateAll() {
        SXSSFFormulaEvaluator.evaluateAllFormulaCells(this.wb, false);
    }

    public static class RowFlushedException
    extends IllegalStateException {
        protected RowFlushedException(int n) {
            super("Row " + n + " has been flushed, cannot evaluate all cells");
        }
    }

    public static class SheetsFlushedException
    extends IllegalStateException {
        protected SheetsFlushedException() {
            super("One or more sheets have been flushed, cannot evaluate all cells");
        }
    }
}

