/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.streaming;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.formula.FormulaParseException;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.ss.usermodel.Comment;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import ai2.org.apache.poi.ss.usermodel.FormulaError;
import ai2.org.apache.poi.ss.usermodel.Hyperlink;
import ai2.org.apache.poi.ss.usermodel.RichTextString;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xssf.streaming.SXSSFRow;
import ai2.org.apache.poi.xssf.streaming.SXSSFSheet;
import ai2.org.apache.poi.xssf.streaming.SXSSFWorkbook;
import ai2.org.apache.poi.xssf.usermodel.XSSFHyperlink;
import ai2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SXSSFCell
implements Cell {
    private static POILogger logger = POILogFactory.getLogger(SXSSFCell.class);
    SXSSFRow _row;
    Value _value;
    CellStyle _style;
    Property _firstProperty;

    public SXSSFCell(SXSSFRow sXSSFRow, int n) {
        this._row = sXSSFRow;
        this.setType(n);
    }

    public int getColumnIndex() {
        return this._row.getCellIndex(this);
    }

    public int getRowIndex() {
        return this._row.getRowNum();
    }

    public SXSSFSheet getSheet() {
        return this._row.getSheet();
    }

    public Row getRow() {
        return this._row;
    }

    public void setCellType(int n) {
        this.ensureType(n);
    }

    public int getCellType() {
        return this._value.getType();
    }

    public int getCachedFormulaResultType() {
        if (this._value.getType() != 2) {
            throw new IllegalStateException("Only formula cells have cached results");
        }
        return ((FormulaValue)this._value).getFormulaType();
    }

    public void setCellValue(double d) {
        if (Double.isInfinite(d)) {
            this.setCellErrorValue(FormulaError.DIV0.getCode());
        } else if (Double.isNaN(d)) {
            this.setCellErrorValue(FormulaError.NUM.getCode());
        } else {
            this.ensureTypeOrFormulaType(0);
            if (this._value.getType() == 2) {
                ((NumericFormulaValue)this._value).setPreEvaluatedValue(d);
            } else {
                ((NumericValue)this._value).setValue(d);
            }
        }
    }

    public void setCellValue(Date date) {
        boolean bl = this.getSheet().getWorkbook().isDate1904();
        this.setCellValue(DateUtil.getExcelDate(date, bl));
    }

    public void setCellValue(Calendar calendar) {
        boolean bl = this.getSheet().getWorkbook().isDate1904();
        this.setCellValue(DateUtil.getExcelDate(calendar, bl));
    }

    public void setCellValue(RichTextString richTextString) {
        this.ensureRichTextStringType();
        if (richTextString.length() > SpreadsheetVersion.EXCEL2007.getMaxTextLength()) {
            throw new IllegalArgumentException("The maximum length of cell contents (text) is 32,767 characters");
        }
        ((RichTextValue)this._value).setValue(richTextString);
        if (((XSSFRichTextString)richTextString).hasFormatting()) {
            logger.log(5, new Object[]{"SXSSF doesn't support Shared Strings, rich text formatting information has be lost"});
        }
    }

    public void setCellValue(String string) {
        this.ensureTypeOrFormulaType(1);
        if (string != null && string.length() > SpreadsheetVersion.EXCEL2007.getMaxTextLength()) {
            throw new IllegalArgumentException("The maximum length of cell contents (text) is 32,767 characters");
        }
        if (this._value.getType() == 2) {
            ((StringFormulaValue)this._value).setPreEvaluatedValue(string);
        } else {
            ((PlainStringValue)this._value).setValue(string);
        }
    }

    public void setCellFormula(String string) throws FormulaParseException {
        if (string == null) {
            this.setType(3);
            return;
        }
        this.ensureFormulaType(this.computeTypeFromFormula(string));
        ((FormulaValue)this._value).setValue(string);
    }

    public String getCellFormula() {
        if (this._value.getType() != 2) {
            throw SXSSFCell.typeMismatch(2, this._value.getType(), false);
        }
        return ((FormulaValue)this._value).getValue();
    }

    public double getNumericCellValue() {
        int n = this.getCellType();
        switch (n) {
            case 3: {
                return 0.0;
            }
            case 2: {
                FormulaValue formulaValue = (FormulaValue)this._value;
                if (formulaValue.getFormulaType() != 0) {
                    throw SXSSFCell.typeMismatch(0, 2, false);
                }
                return ((NumericFormulaValue)this._value).getPreEvaluatedValue();
            }
            case 0: {
                return ((NumericValue)this._value).getValue();
            }
        }
        throw SXSSFCell.typeMismatch(0, n, false);
    }

    public Date getDateCellValue() {
        int n = this.getCellType();
        if (n == 3) {
            return null;
        }
        double d = this.getNumericCellValue();
        boolean bl = this.getSheet().getWorkbook().isDate1904();
        return DateUtil.getJavaDate(d, bl);
    }

    public RichTextString getRichStringCellValue() {
        int n = this.getCellType();
        if (this.getCellType() != 1) {
            throw SXSSFCell.typeMismatch(1, n, false);
        }
        StringValue stringValue = (StringValue)this._value;
        if (stringValue.isRichText()) {
            return ((RichTextValue)this._value).getValue();
        }
        String string = this.getStringCellValue();
        return this.getSheet().getWorkbook().getCreationHelper().createRichTextString(string);
    }

    public String getStringCellValue() {
        int n = this.getCellType();
        switch (n) {
            case 3: {
                return "";
            }
            case 2: {
                FormulaValue formulaValue = (FormulaValue)this._value;
                if (formulaValue.getFormulaType() != 1) {
                    throw SXSSFCell.typeMismatch(1, 2, false);
                }
                return ((StringFormulaValue)this._value).getPreEvaluatedValue();
            }
            case 1: {
                if (((StringValue)this._value).isRichText()) {
                    return ((RichTextValue)this._value).getValue().getString();
                }
                return ((PlainStringValue)this._value).getValue();
            }
        }
        throw SXSSFCell.typeMismatch(1, n, false);
    }

    public void setCellValue(boolean bl) {
        this.ensureTypeOrFormulaType(4);
        if (this._value.getType() == 2) {
            ((BooleanFormulaValue)this._value).setPreEvaluatedValue(bl);
        } else {
            ((BooleanValue)this._value).setValue(bl);
        }
    }

    public void setCellErrorValue(byte by) {
        this.ensureType(5);
        if (this._value.getType() == 2) {
            ((ErrorFormulaValue)this._value).setPreEvaluatedValue(by);
        } else {
            ((ErrorValue)this._value).setValue(by);
        }
    }

    public boolean getBooleanCellValue() {
        int n = this.getCellType();
        switch (n) {
            case 3: {
                return false;
            }
            case 2: {
                FormulaValue formulaValue = (FormulaValue)this._value;
                if (formulaValue.getFormulaType() != 4) {
                    throw SXSSFCell.typeMismatch(4, 2, false);
                }
                return ((BooleanFormulaValue)this._value).getPreEvaluatedValue();
            }
            case 4: {
                return ((BooleanValue)this._value).getValue();
            }
        }
        throw SXSSFCell.typeMismatch(4, n, false);
    }

    public byte getErrorCellValue() {
        int n = this.getCellType();
        switch (n) {
            case 3: {
                return 0;
            }
            case 2: {
                FormulaValue formulaValue = (FormulaValue)this._value;
                if (formulaValue.getFormulaType() != 5) {
                    throw SXSSFCell.typeMismatch(5, 2, false);
                }
                return ((ErrorFormulaValue)this._value).getPreEvaluatedValue();
            }
            case 5: {
                return ((ErrorValue)this._value).getValue();
            }
        }
        throw SXSSFCell.typeMismatch(5, n, false);
    }

    public void setCellStyle(CellStyle cellStyle) {
        this._style = cellStyle;
    }

    public CellStyle getCellStyle() {
        if (this._style == null) {
            SXSSFWorkbook sXSSFWorkbook = (SXSSFWorkbook)this.getRow().getSheet().getWorkbook();
            return sXSSFWorkbook.getCellStyleAt((short)0);
        }
        return this._style;
    }

    public void setAsActiveCell() {
    }

    public void setCellComment(Comment comment) {
        this.setProperty(1, comment);
    }

    public Comment getCellComment() {
        return (Comment)this.getPropertyValue(1);
    }

    public void removeCellComment() {
        this.removeProperty(1);
    }

    public Hyperlink getHyperlink() {
        return (Hyperlink)this.getPropertyValue(2);
    }

    public void setHyperlink(Hyperlink hyperlink) {
        if (hyperlink == null) {
            this.removeHyperlink();
            return;
        }
        this.setProperty(2, hyperlink);
        XSSFHyperlink xSSFHyperlink = (XSSFHyperlink)hyperlink;
        CellReference cellReference = new CellReference(this.getRowIndex(), this.getColumnIndex());
        xSSFHyperlink.getCTHyperlink().setRef(cellReference.formatAsString());
        this.getSheet()._sh.addHyperlink(xSSFHyperlink);
    }

    public void removeHyperlink() {
        this.removeProperty(2);
        this.getSheet()._sh.removeHyperlink(this.getRowIndex(), this.getColumnIndex());
    }

    public CellRangeAddress getArrayFormulaRange() {
        return null;
    }

    public boolean isPartOfArrayFormulaGroup() {
        return false;
    }

    public String toString() {
        switch (this.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 5: {
                return ErrorEval.getText(this.getErrorCellValue());
            }
            case 2: {
                return this.getCellFormula();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted(this)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", LocaleUtil.getUserLocale());
                    simpleDateFormat.setTimeZone(LocaleUtil.getUserTimeZone());
                    return simpleDateFormat.format(this.getDateCellValue());
                }
                return this.getNumericCellValue() + "";
            }
            case 1: {
                return this.getRichStringCellValue().toString();
            }
        }
        return "Unknown Cell Type: " + this.getCellType();
    }

    void removeProperty(int n) {
        Property property = this._firstProperty;
        Property property2 = null;
        while (property != null && property.getType() != n) {
            property2 = property;
            property = property._next;
        }
        if (property != null) {
            if (property2 != null) {
                property2._next = property._next;
            } else {
                this._firstProperty = property._next;
            }
        }
    }

    void setProperty(int n, Object object) {
        Property property = this._firstProperty;
        Property property2 = null;
        while (property != null && property.getType() != n) {
            property2 = property;
            property = property._next;
        }
        if (property != null) {
            property.setValue(object);
        } else {
            switch (n) {
                case 1: {
                    property = new CommentProperty(object);
                    break;
                }
                case 2: {
                    property = new HyperlinkProperty(object);
                }
            }
            if (property2 != null) {
                property2._next = property;
            } else {
                this._firstProperty = property;
            }
        }
    }

    Object getPropertyValue(int n) {
        return this.getPropertyValue(n, null);
    }

    Object getPropertyValue(int n, String string) {
        Property property = this._firstProperty;
        while (property != null && property.getType() != n) {
            property = property._next;
        }
        return property == null ? string : property.getValue();
    }

    void ensurePlainStringType() {
        if (this._value.getType() != 1 || ((StringValue)this._value).isRichText()) {
            this._value = new PlainStringValue();
        }
    }

    void ensureRichTextStringType() {
        if (this._value.getType() != 1 || !((StringValue)this._value).isRichText()) {
            this._value = new RichTextValue();
        }
    }

    void ensureType(int n) {
        if (this._value.getType() != n) {
            this.setType(n);
        }
    }

    void ensureFormulaType(int n) {
        if (this._value.getType() != 2 || ((FormulaValue)this._value).getFormulaType() != n) {
            this.setFormulaType(n);
        }
    }

    void ensureTypeOrFormulaType(int n) {
        if (this._value.getType() == n) {
            if (n == 1 && ((StringValue)this._value).isRichText()) {
                this.setType(1);
            }
            return;
        }
        if (this._value.getType() == 2) {
            if (((FormulaValue)this._value).getFormulaType() == n) {
                return;
            }
            this.setFormulaType(n);
            return;
        }
        this.setType(n);
    }

    void setType(int n) {
        switch (n) {
            case 0: {
                this._value = new NumericValue();
                break;
            }
            case 1: {
                PlainStringValue plainStringValue = new PlainStringValue();
                if (this._value != null) {
                    String string = this.convertCellValueToString();
                    plainStringValue.setValue(string);
                }
                this._value = plainStringValue;
                break;
            }
            case 2: {
                this._value = new NumericFormulaValue();
                break;
            }
            case 3: {
                this._value = new BlankValue();
                break;
            }
            case 4: {
                BooleanValue booleanValue = new BooleanValue();
                if (this._value != null) {
                    boolean bl = this.convertCellValueToBoolean();
                    booleanValue.setValue(bl);
                }
                this._value = booleanValue;
                break;
            }
            case 5: {
                this._value = new ErrorValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type " + n);
            }
        }
    }

    void setFormulaType(int n) {
        switch (n) {
            case 0: {
                this._value = new NumericFormulaValue();
                break;
            }
            case 1: {
                this._value = new StringFormulaValue();
                break;
            }
            case 4: {
                this._value = new BooleanFormulaValue();
                break;
            }
            case 5: {
                this._value = new ErrorFormulaValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type " + n);
            }
        }
    }

    int computeTypeFromFormula(String string) {
        return 0;
    }

    private static RuntimeException typeMismatch(int n, int n2, boolean bl) {
        String string = "Cannot get a " + SXSSFCell.getCellTypeName(n) + " value from a " + SXSSFCell.getCellTypeName(n2) + " " + (bl ? "formula " : "") + "cell";
        return new IllegalStateException(string);
    }

    private static String getCellTypeName(int n) {
        switch (n) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + n + ")#";
    }

    private boolean convertCellValueToBoolean() {
        int n = this.getCellType();
        if (n == 2) {
            n = this.getCachedFormulaResultType();
        }
        switch (n) {
            case 4: {
                return this.getBooleanCellValue();
            }
            case 1: {
                String string = this.getStringCellValue();
                return Boolean.parseBoolean(string);
            }
            case 0: {
                return this.getNumericCellValue() != 0.0;
            }
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected cell type (" + n + ")");
    }

    private String convertCellValueToString() {
        int n = this.getCellType();
        return this.convertCellValueToString(n);
    }

    private String convertCellValueToString(int n) {
        switch (n) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 1: {
                return this.getStringCellValue();
            }
            case 0: {
                return Double.toString(this.getNumericCellValue());
            }
            case 5: {
                byte by = this.getErrorCellValue();
                return FormulaError.forInt(by).getString();
            }
            case 2: {
                FormulaValue formulaValue;
                if (this._value != null && (formulaValue = (FormulaValue)this._value).getFormulaType() != 2) {
                    return this.convertCellValueToString(formulaValue.getFormulaType());
                }
                return "";
            }
        }
        throw new IllegalStateException("Unexpected cell type (" + n + ")");
    }

    static class ErrorValue
    implements Value {
        byte _value;

        ErrorValue() {
        }

        public int getType() {
            return 5;
        }

        void setValue(byte by) {
            this._value = by;
        }

        byte getValue() {
            return this._value;
        }
    }

    static class BooleanValue
    implements Value {
        boolean _value;

        BooleanValue() {
        }

        public int getType() {
            return 4;
        }

        void setValue(boolean bl) {
            this._value = bl;
        }

        boolean getValue() {
            return this._value;
        }
    }

    static class BlankValue
    implements Value {
        BlankValue() {
        }

        public int getType() {
            return 3;
        }
    }

    static class ErrorFormulaValue
    extends FormulaValue {
        byte _preEvaluatedValue;

        ErrorFormulaValue() {
        }

        int getFormulaType() {
            return 5;
        }

        void setPreEvaluatedValue(byte by) {
            this._preEvaluatedValue = by;
        }

        byte getPreEvaluatedValue() {
            return this._preEvaluatedValue;
        }
    }

    static class BooleanFormulaValue
    extends FormulaValue {
        boolean _preEvaluatedValue;

        BooleanFormulaValue() {
        }

        int getFormulaType() {
            return 4;
        }

        void setPreEvaluatedValue(boolean bl) {
            this._preEvaluatedValue = bl;
        }

        boolean getPreEvaluatedValue() {
            return this._preEvaluatedValue;
        }
    }

    static class StringFormulaValue
    extends FormulaValue {
        String _preEvaluatedValue;

        StringFormulaValue() {
        }

        int getFormulaType() {
            return 1;
        }

        void setPreEvaluatedValue(String string) {
            this._preEvaluatedValue = string;
        }

        String getPreEvaluatedValue() {
            return this._preEvaluatedValue;
        }
    }

    static class NumericFormulaValue
    extends FormulaValue {
        double _preEvaluatedValue;

        NumericFormulaValue() {
        }

        int getFormulaType() {
            return 0;
        }

        void setPreEvaluatedValue(double d) {
            this._preEvaluatedValue = d;
        }

        double getPreEvaluatedValue() {
            return this._preEvaluatedValue;
        }
    }

    static abstract class FormulaValue
    implements Value {
        String _value;

        FormulaValue() {
        }

        public int getType() {
            return 2;
        }

        void setValue(String string) {
            this._value = string;
        }

        String getValue() {
            return this._value;
        }

        abstract int getFormulaType();
    }

    static class RichTextValue
    extends StringValue {
        RichTextString _value;

        RichTextValue() {
        }

        public int getType() {
            return 1;
        }

        void setValue(RichTextString richTextString) {
            this._value = richTextString;
        }

        RichTextString getValue() {
            return this._value;
        }

        boolean isRichText() {
            return true;
        }
    }

    static class PlainStringValue
    extends StringValue {
        String _value;

        PlainStringValue() {
        }

        void setValue(String string) {
            this._value = string;
        }

        String getValue() {
            return this._value;
        }

        boolean isRichText() {
            return false;
        }
    }

    static abstract class StringValue
    implements Value {
        StringValue() {
        }

        public int getType() {
            return 1;
        }

        abstract boolean isRichText();
    }

    static class NumericValue
    implements Value {
        double _value;

        NumericValue() {
        }

        public int getType() {
            return 0;
        }

        void setValue(double d) {
            this._value = d;
        }

        double getValue() {
            return this._value;
        }
    }

    static interface Value {
        public int getType();
    }

    static class HyperlinkProperty
    extends Property {
        public HyperlinkProperty(Object object) {
            super(object);
        }

        public int getType() {
            return 2;
        }
    }

    static class CommentProperty
    extends Property {
        public CommentProperty(Object object) {
            super(object);
        }

        public int getType() {
            return 1;
        }
    }

    static abstract class Property {
        static final int COMMENT = 1;
        static final int HYPERLINK = 2;
        Object _value;
        Property _next;

        public Property(Object object) {
            this._value = object;
        }

        abstract int getType();

        void setValue(Object object) {
            this._value = object;
        }

        Object getValue() {
            return this._value;
        }
    }
}

