/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.model;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.SstDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedStringsTable
extends POIXMLDocumentPart {
    private final List<CTRst> strings = new ArrayList<CTRst>();
    private final Map<String, Integer> stmap = new HashMap<String, Integer>();
    private int count;
    private int uniqueCount;
    private SstDocument _sstDoc;
    private static final XmlOptions options = new XmlOptions();

    public SharedStringsTable() {
        this._sstDoc = SstDocument.Factory.newInstance();
        this._sstDoc.addNewSst();
    }

    public SharedStringsTable(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException {
        try {
            int n = 0;
            this._sstDoc = SstDocument.Factory.parse((InputStream)inputStream);
            CTSst cTSst = this._sstDoc.getSst();
            this.count = (int)cTSst.getCount();
            this.uniqueCount = (int)cTSst.getUniqueCount();
            for (CTRst cTRst : cTSst.getSiArray()) {
                this.stmap.put(this.getKey(cTRst), n);
                this.strings.add(cTRst);
                ++n;
            }
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getLocalizedMessage());
        }
    }

    private String getKey(CTRst cTRst) {
        return cTRst.xmlText(options);
    }

    public CTRst getEntryAt(int n) {
        return this.strings.get(n);
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public int addEntry(CTRst cTRst) {
        String string = this.getKey(cTRst);
        ++this.count;
        if (this.stmap.containsKey(string)) {
            return this.stmap.get(string);
        }
        ++this.uniqueCount;
        CTRst cTRst2 = this._sstDoc.getSst().addNewSi();
        cTRst2.set((XmlObject)cTRst);
        int n = this.strings.size();
        this.stmap.put(string, n);
        this.strings.add(cTRst2);
        return n;
    }

    public List<CTRst> getItems() {
        return this.strings;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveCDataLengthThreshold(1000000);
        xmlOptions.setSaveCDataEntityCountThreshold(-1);
        CTSst cTSst = this._sstDoc.getSst();
        cTSst.setCount((long)this.count);
        cTSst.setUniqueCount((long)this.uniqueCount);
        this._sstDoc.save(outputStream, xmlOptions);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.writeTo(outputStream);
        outputStream.close();
    }

    static {
        options.put((Object)"SAVE_INNER");
        options.put((Object)"SAVE_AGGRESSIVE_NAMESPACES");
        options.put((Object)"SAVE_USE_DEFAULT_NAMESPACE");
        options.setSaveImplicitNamespaces(Collections.singletonMap("", "http://schemas.openxmlformats.org/spreadsheetml/2006/main"));
    }
}

