/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.model;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.xssf.usermodel.XSSFMap;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMap;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMapInfo;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSchema;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.MapInfoDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapInfo
extends POIXMLDocumentPart {
    private CTMapInfo mapInfo;
    private Map<Integer, XSSFMap> maps;

    public MapInfo() {
        this.mapInfo = CTMapInfo.Factory.newInstance();
    }

    public MapInfo(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException {
        try {
            MapInfoDocument mapInfoDocument = MapInfoDocument.Factory.parse((InputStream)inputStream);
            this.mapInfo = mapInfoDocument.getMapInfo();
            this.maps = new HashMap<Integer, XSSFMap>();
            for (CTMap cTMap : this.mapInfo.getMapArray()) {
                this.maps.put((int)cTMap.getID(), new XSSFMap(cTMap, this));
            }
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getLocalizedMessage());
        }
    }

    public XSSFWorkbook getWorkbook() {
        return (XSSFWorkbook)this.getParent();
    }

    public CTMapInfo getCTMapInfo() {
        return this.mapInfo;
    }

    public CTSchema getCTSchemaById(String string) {
        CTSchema cTSchema = null;
        for (CTSchema cTSchema2 : this.mapInfo.getSchemaArray()) {
            if (!cTSchema2.getID().equals(string)) continue;
            cTSchema = cTSchema2;
            break;
        }
        return cTSchema;
    }

    public XSSFMap getXSSFMapById(int n) {
        return this.maps.get(n);
    }

    public XSSFMap getXSSFMapByName(String string) {
        XSSFMap xSSFMap = null;
        for (XSSFMap xSSFMap2 : this.maps.values()) {
            if (xSSFMap2.getCtMap().getName() == null || !xSSFMap2.getCtMap().getName().equals(string)) continue;
            xSSFMap = xSSFMap2;
        }
        return xSSFMap;
    }

    public Collection<XSSFMap> getAllXSSFMaps() {
        return this.maps.values();
    }

    protected void writeTo(OutputStream outputStream) throws IOException {
        MapInfoDocument mapInfoDocument = MapInfoDocument.Factory.newInstance();
        mapInfoDocument.setMapInfo(this.mapInfo);
        mapInfoDocument.save(outputStream, DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.writeTo(outputStream);
        outputStream.close();
    }
}

