/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.extractor;

import ai2.org.apache.poi.ss.usermodel.DateUtil;
import ai2.org.apache.poi.util.DocumentHelper;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFMap;
import ai2.org.apache.poi.xssf.usermodel.XSSFRow;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import ai2.org.apache.poi.xssf.usermodel.XSSFTable;
import ai2.org.apache.poi.xssf.usermodel.helpers.XSSFSingleXmlCell;
import ai2.org.apache.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STXmlDataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFExportToXml
implements Comparator<String> {
    private XSSFMap map;

    public XSSFExportToXml(XSSFMap xSSFMap) {
        this.map = xSSFMap;
    }

    public void exportToXML(OutputStream outputStream, boolean bl) throws SAXException, ParserConfigurationException, TransformerException {
        this.exportToXML(outputStream, "UTF-8", bl);
    }

    public void exportToXML(OutputStream outputStream, String string, boolean bl) throws SAXException, ParserConfigurationException, TransformerException {
        Object object;
        Object object2;
        Object object3;
        List<XSSFSingleXmlCell> list = this.map.getRelatedSingleXMLCell();
        List<XSSFTable> list2 = this.map.getRelatedTables();
        String string2 = this.map.getCtMap().getRootElement();
        Document document = DocumentHelper.createDocument();
        Element element = null;
        element = this.isNamespaceDeclared() ? document.createElementNS(this.getNamespace(), string2) : document.createElementNS("", string2);
        document.appendChild(element);
        Vector<String> vector = new Vector<String>();
        HashMap<String, XSSFSingleXmlCell> hashMap = new HashMap<String, XSSFSingleXmlCell>();
        HashMap<String, XSSFTable> hashMap2 = new HashMap<String, XSSFTable>();
        for (XSSFSingleXmlCell object4 : list) {
            vector.add(object4.getXpath());
            hashMap.put(object4.getXpath(), object4);
        }
        for (XSSFTable xSSFTable : list2) {
            object3 = xSSFTable.getCommonXpath();
            vector.add((String)object3);
            hashMap2.put((String)object3, xSSFTable);
        }
        Collections.sort(vector, this);
        for (String string3 : vector) {
            Object object4;
            object3 = (XSSFSingleXmlCell)hashMap.get(string3);
            object2 = (XSSFTable)hashMap2.get(string3);
            if (string3.matches(".*\\[.*")) continue;
            if (object3 != null && (object = ((XSSFSingleXmlCell)object3).getReferencedCell()) != null) {
                object4 = this.getNodeByXPath(string3, document.getFirstChild(), document, false);
                STXmlDataType.Enum enum_ = ((XSSFSingleXmlCell)object3).getXmlDataType();
                this.mapCellOnNode((XSSFCell)object, (Node)object4, enum_);
                if ("".equals(object4.getTextContent()) && object4.getParentNode() != null) {
                    object4.getParentNode().removeChild((Node)object4);
                }
            }
            if (object2 == null) continue;
            object = ((XSSFTable)object2).getXmlColumnPrs();
            object4 = ((XSSFTable)object2).getXSSFSheet();
            int n = ((XSSFTable)object2).getStartCellReference().getRow();
            int n2 = ((XSSFTable)object2).getEndCellReference().getRow();
            for (int i = ++n; i <= n2; ++i) {
                int n3;
                XSSFRow xSSFRow = ((XSSFSheet)object4).getRow(i);
                Node node = this.getNodeByXPath(((XSSFTable)object2).getCommonXpath(), document.getFirstChild(), document, true);
                for (int j = n3 = ((XSSFTable)object2).getStartCellReference().getCol(); j <= ((XSSFTable)object2).getEndCellReference().getCol(); ++j) {
                    XSSFCell xSSFCell = xSSFRow.getCell(j);
                    if (xSSFCell == null) continue;
                    XSSFXmlColumnPr xSSFXmlColumnPr = (XSSFXmlColumnPr)object.get(j - n3);
                    String string4 = xSSFXmlColumnPr.getLocalXPath();
                    Node node2 = this.getNodeByXPath(string4, node, document, false);
                    STXmlDataType.Enum enum_ = xSSFXmlColumnPr.getXmlDataType();
                    this.mapCellOnNode(xSSFCell, node2, enum_);
                }
            }
        }
        boolean bl2 = true;
        if (bl) {
            bl2 = this.isValid(document);
        }
        if (bl2) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            object3 = transformerFactory.newTransformer();
            ((Transformer)object3).setOutputProperty("omit-xml-declaration", "yes");
            ((Transformer)object3).setOutputProperty("indent", "yes");
            ((Transformer)object3).setOutputProperty("encoding", string);
            object2 = new StreamResult(outputStream);
            object = new DOMSource(document);
            ((Transformer)object3).transform((Source)object, (Result)object2);
        }
    }

    private boolean isValid(Document document) throws SAXException {
        try {
            String string = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory schemaFactory = SchemaFactory.newInstance(string);
            DOMSource dOMSource = new DOMSource(this.map.getSchema());
            Schema schema = schemaFactory.newSchema(dOMSource);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(document));
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private void mapCellOnNode(XSSFCell xSSFCell, Node node, STXmlDataType.Enum enum_) {
        String string = "";
        switch (xSSFCell.getCellType()) {
            case 1: {
                string = xSSFCell.getStringCellValue();
                break;
            }
            case 4: {
                string = string + xSSFCell.getBooleanCellValue();
                break;
            }
            case 5: {
                string = xSSFCell.getErrorCellString();
                break;
            }
            case 2: {
                if (xSSFCell.getCachedFormulaResultType() == 1) {
                    string = xSSFCell.getStringCellValue();
                    break;
                }
                if (DateUtil.isCellDateFormatted(xSSFCell)) {
                    string = this.getFormattedDate(xSSFCell);
                    break;
                }
                string = string + xSSFCell.getNumericCellValue();
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted(xSSFCell)) {
                    string = this.getFormattedDate(xSSFCell);
                    break;
                }
                string = string + xSSFCell.getRawValue();
                break;
            }
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            element.setTextContent(string);
        } else {
            node.setNodeValue(string);
        }
    }

    private String removeNamespace(String string) {
        return string.matches(".*:.*") ? string.split(":")[1] : string;
    }

    private String getFormattedDate(XSSFCell xSSFCell) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
        simpleDateFormat.setTimeZone(LocaleUtil.getUserTimeZone());
        return simpleDateFormat.format(xSSFCell.getDateCellValue());
    }

    private Node getNodeByXPath(String string, Node node, Document document, boolean bl) {
        String[] stringArray = string.split("/");
        Object object = node;
        for (int i = 2; i < stringArray.length; ++i) {
            Object object2;
            String string2 = this.removeNamespace(stringArray[i]);
            if (!string2.startsWith("@")) {
                object2 = object.getChildNodes();
                Node node2 = null;
                if (!bl || i != stringArray.length - 1) {
                    node2 = this.selectNode(string2, (NodeList)object2);
                }
                if (node2 == null) {
                    node2 = this.createElement(document, (Node)object, string2);
                }
                object = node2;
                continue;
            }
            object = object2 = this.createAttribute(document, (Node)object, string2);
        }
        return object;
    }

    private Node createAttribute(Document document, Node node, String string) {
        String string2 = string.substring(1);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string2);
        if (node2 == null) {
            node2 = document.createAttributeNS("", string2);
            namedNodeMap.setNamedItem(node2);
        }
        return node2;
    }

    private Node createElement(Document document, Node node, String string) {
        Element element = this.isNamespaceDeclared() ? document.createElementNS(this.getNamespace(), string) : document.createElementNS("", string);
        node.appendChild(element);
        return element;
    }

    private Node selectNode(String string, NodeList nodeList) {
        Node node = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            node = node2;
            break;
        }
        return node;
    }

    private boolean isNamespaceDeclared() {
        String string = this.getNamespace();
        return string != null && !string.equals("");
    }

    private String getNamespace() {
        return this.map.getCTSchema().getNamespace();
    }

    @Override
    public int compare(String string, String string2) {
        String[] stringArray;
        Node node = this.map.getSchema();
        String[] stringArray2 = string.split("/");
        int n = stringArray2.length < (stringArray = string2.split("/")).length ? stringArray2.length : stringArray.length;
        Node node2 = node;
        for (int i = 1; i < n; ++i) {
            String string3 = stringArray2[i];
            String string4 = stringArray[i];
            if (string3.equals(string4)) {
                Node node3;
                node2 = node3 = this.getComplexTypeForElement(string3, node, node2);
                continue;
            }
            int n2 = this.indexOfElementInComplexType(string3, node2);
            int n3 = this.indexOfElementInComplexType(string4, node2);
            if (n2 == -1 || n3 == -1) continue;
            if (n2 < n3) {
                return -1;
            }
            if (n2 <= n3) continue;
            return 1;
        }
        return 0;
    }

    private int indexOfElementInComplexType(String string, Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = -1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2;
            Node node3 = nodeList.item(i);
            if (!(node3 instanceof Element) || !node3.getLocalName().equals("element") || !(node2 = this.getNameOrRefElement(node3)).getNodeValue().equals(this.removeNamespace(string))) continue;
            n = i;
            break;
        }
        return n;
    }

    private Node getNameOrRefElement(Node node) {
        Node node2 = node.getAttributes().getNamedItem("name");
        if (node2 != null) {
            return node2;
        }
        return node.getAttributes().getNamedItem("ref");
    }

    private Node getComplexTypeForElement(String string, Node node, Node node2) {
        String string2 = this.removeNamespace(string);
        String string3 = this.getComplexTypeNameFromChildren(node2, string2);
        Node node3 = null;
        if (!"".equals(string3)) {
            node3 = this.getComplexTypeNodeFromSchemaChildren(node, node3, string3);
        }
        return node3;
    }

    private String getComplexTypeNameFromChildren(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        String string2 = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2;
            Node node3;
            Node node4 = nodeList.item(i);
            if (!(node4 instanceof Element) || !node4.getLocalName().equals("element") || !(node3 = this.getNameOrRefElement(node4)).getNodeValue().equals(string) || (node2 = node4.getAttributes().getNamedItem("type")) == null) continue;
            string2 = node2.getNodeValue();
            break;
        }
        return string2;
    }

    private Node getComplexTypeNodeFromSchemaChildren(Node node, Node node2, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3;
            Node node4 = nodeList.item(i);
            if (!(node4 instanceof Element) || !node4.getLocalName().equals("complexType") || !(node3 = this.getNameOrRefElement(node4)).getNodeValue().equals(string)) continue;
            NodeList nodeList2 = node4.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node5 = nodeList2.item(j);
                if (!(node5 instanceof Element) || !node5.getLocalName().equals("sequence") && !node5.getLocalName().equals("all")) continue;
                node2 = node5;
                break;
            }
            if (node2 != null) break;
        }
        return node2;
    }
}

