/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.eventusermodel;

import ai2.org.apache.poi.ss.usermodel.BuiltinFormats;
import ai2.org.apache.poi.ss.usermodel.DataFormatter;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import ai2.org.apache.poi.xssf.model.CommentsTable;
import ai2.org.apache.poi.xssf.model.StylesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import ai2.org.apache.poi.xssf.usermodel.XSSFComment;
import ai2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Queue;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSSFSheetXMLHandler
extends DefaultHandler {
    private static final POILogger logger = POILogFactory.getLogger(XSSFSheetXMLHandler.class);
    private StylesTable stylesTable;
    private CommentsTable commentsTable;
    private ReadOnlySharedStringsTable sharedStringsTable;
    private final SheetContentsHandler output;
    private boolean vIsOpen;
    private boolean fIsOpen;
    private boolean isIsOpen;
    private boolean hfIsOpen;
    private xssfDataType nextDataType;
    private short formatIndex;
    private String formatString;
    private final DataFormatter formatter;
    private int rowNum;
    private int nextRowNum;
    private String cellRef;
    private boolean formulasNotResults;
    private StringBuffer value = new StringBuffer();
    private StringBuffer formula = new StringBuffer();
    private StringBuffer headerFooter = new StringBuffer();
    private Queue<CellReference> commentCellRefs;
    private static final Comparator<CellReference> cellRefComparator = new Comparator<CellReference>(){

        @Override
        public int compare(CellReference cellReference, CellReference cellReference2) {
            int n = this.compare(cellReference.getRow(), cellReference2.getRow());
            if (n == 0) {
                n = this.compare(cellReference.getCol(), cellReference2.getCol());
            }
            return n;
        }

        @Override
        public int compare(int n, int n2) {
            return n < n2 ? -1 : (n == n2 ? 0 : 1);
        }
    };

    public XSSFSheetXMLHandler(StylesTable stylesTable, CommentsTable commentsTable, ReadOnlySharedStringsTable readOnlySharedStringsTable, SheetContentsHandler sheetContentsHandler, DataFormatter dataFormatter, boolean bl) {
        this.stylesTable = stylesTable;
        this.commentsTable = commentsTable;
        this.sharedStringsTable = readOnlySharedStringsTable;
        this.output = sheetContentsHandler;
        this.formulasNotResults = bl;
        this.nextDataType = xssfDataType.NUMBER;
        this.formatter = dataFormatter;
        this.init();
    }

    public XSSFSheetXMLHandler(StylesTable stylesTable, ReadOnlySharedStringsTable readOnlySharedStringsTable, SheetContentsHandler sheetContentsHandler, DataFormatter dataFormatter, boolean bl) {
        this(stylesTable, null, readOnlySharedStringsTable, sheetContentsHandler, dataFormatter, bl);
    }

    public XSSFSheetXMLHandler(StylesTable stylesTable, ReadOnlySharedStringsTable readOnlySharedStringsTable, SheetContentsHandler sheetContentsHandler, boolean bl) {
        this(stylesTable, readOnlySharedStringsTable, sheetContentsHandler, new DataFormatter(), bl);
    }

    private void init() {
        if (this.commentsTable != null) {
            this.commentCellRefs = new LinkedList<CellReference>();
            for (CTComment cTComment : this.commentsTable.getCTComments().getCommentList().getCommentArray()) {
                this.commentCellRefs.add(new CellReference(cTComment.getRef()));
            }
        }
    }

    private boolean isTextTag(String string) {
        if ("v".equals(string)) {
            return true;
        }
        if ("inlineStr".equals(string)) {
            return true;
        }
        return "t".equals(string) && this.isIsOpen;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.isTextTag(string3)) {
            this.vIsOpen = true;
            this.value.setLength(0);
        } else if ("is".equals(string3)) {
            this.isIsOpen = true;
        } else if ("f".equals(string3)) {
            String string4;
            this.formula.setLength(0);
            if (this.nextDataType == xssfDataType.NUMBER) {
                this.nextDataType = xssfDataType.FORMULA;
            }
            if ((string4 = attributes.getValue("t")) != null && string4.equals("shared")) {
                String string5 = attributes.getValue("ref");
                String string6 = attributes.getValue("si");
                if (string5 != null) {
                    this.fIsOpen = true;
                } else if (this.formulasNotResults) {
                    logger.log(5, new Object[]{"shared formulas not yet supported!"});
                }
            } else {
                this.fIsOpen = true;
            }
        } else if ("oddHeader".equals(string3) || "evenHeader".equals(string3) || "firstHeader".equals(string3) || "firstFooter".equals(string3) || "oddFooter".equals(string3) || "evenFooter".equals(string3)) {
            this.hfIsOpen = true;
            this.headerFooter.setLength(0);
        } else if ("row".equals(string3)) {
            String string7 = attributes.getValue("r");
            this.rowNum = string7 != null ? Integer.parseInt(string7) - 1 : this.nextRowNum;
            this.output.startRow(this.rowNum);
        } else if ("c".equals(string3)) {
            this.nextDataType = xssfDataType.NUMBER;
            this.formatIndex = (short)-1;
            this.formatString = null;
            this.cellRef = attributes.getValue("r");
            String string8 = attributes.getValue("t");
            String string9 = attributes.getValue("s");
            if ("b".equals(string8)) {
                this.nextDataType = xssfDataType.BOOLEAN;
            } else if ("e".equals(string8)) {
                this.nextDataType = xssfDataType.ERROR;
            } else if ("inlineStr".equals(string8)) {
                this.nextDataType = xssfDataType.INLINE_STRING;
            } else if ("s".equals(string8)) {
                this.nextDataType = xssfDataType.SST_STRING;
            } else if ("str".equals(string8)) {
                this.nextDataType = xssfDataType.FORMULA;
            } else {
                XSSFCellStyle xSSFCellStyle = null;
                if (string9 != null) {
                    int n = Integer.parseInt(string9);
                    xSSFCellStyle = this.stylesTable.getStyleAt(n);
                } else if (this.stylesTable.getNumCellStyles() > 0) {
                    xSSFCellStyle = this.stylesTable.getStyleAt(0);
                }
                if (xSSFCellStyle != null) {
                    this.formatIndex = xSSFCellStyle.getDataFormat();
                    this.formatString = xSSFCellStyle.getDataFormatString();
                    if (this.formatString == null) {
                        this.formatString = BuiltinFormats.getBuiltinFormat(this.formatIndex);
                    }
                }
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = null;
        if (this.isTextTag(string3)) {
            this.vIsOpen = false;
            switch (this.nextDataType) {
                case BOOLEAN: {
                    char c = this.value.charAt(0);
                    string4 = c == '0' ? "FALSE" : "TRUE";
                    break;
                }
                case ERROR: {
                    string4 = "ERROR:" + this.value.toString();
                    break;
                }
                case FORMULA: {
                    if (this.formulasNotResults) {
                        string4 = this.formula.toString();
                        break;
                    }
                    String string5 = this.value.toString();
                    if (this.formatString != null) {
                        try {
                            double d = Double.parseDouble(string5);
                            string4 = this.formatter.formatRawCellContents(d, this.formatIndex, this.formatString);
                        }
                        catch (NumberFormatException numberFormatException) {
                            string4 = string5;
                        }
                        break;
                    }
                    string4 = string5;
                    break;
                }
                case INLINE_STRING: {
                    XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this.value.toString());
                    string4 = xSSFRichTextString.toString();
                    break;
                }
                case SST_STRING: {
                    String string6 = this.value.toString();
                    try {
                        int n = Integer.parseInt(string6);
                        XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(n));
                        string4 = xSSFRichTextString.toString();
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.log(7, new Object[]{"Failed to parse SST index '" + string6, numberFormatException});
                    }
                    break;
                }
                case NUMBER: {
                    String string7 = this.value.toString();
                    if (this.formatString != null && string7.length() > 0) {
                        string4 = this.formatter.formatRawCellContents(Double.parseDouble(string7), this.formatIndex, this.formatString);
                        break;
                    }
                    string4 = string7;
                    break;
                }
                default: {
                    string4 = "(TODO: Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
                }
            }
            this.checkForEmptyCellComments(EmptyCellCommentsCheckType.CELL);
            XSSFComment xSSFComment = this.commentsTable != null ? this.commentsTable.findCellComment(this.cellRef) : null;
            this.output.cell(this.cellRef, string4, xSSFComment);
        } else if ("f".equals(string3)) {
            this.fIsOpen = false;
        } else if ("is".equals(string3)) {
            this.isIsOpen = false;
        } else if ("row".equals(string3)) {
            this.checkForEmptyCellComments(EmptyCellCommentsCheckType.END_OF_ROW);
            this.output.endRow(this.rowNum);
            this.nextRowNum = this.rowNum + 1;
        } else if ("sheetData".equals(string3)) {
            this.checkForEmptyCellComments(EmptyCellCommentsCheckType.END_OF_SHEET_DATA);
        } else if ("oddHeader".equals(string3) || "evenHeader".equals(string3) || "firstHeader".equals(string3)) {
            this.hfIsOpen = false;
            this.output.headerFooter(this.headerFooter.toString(), true, string3);
        } else if ("oddFooter".equals(string3) || "evenFooter".equals(string3) || "firstFooter".equals(string3)) {
            this.hfIsOpen = false;
            this.output.headerFooter(this.headerFooter.toString(), false, string3);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(cArray, n, n2);
        }
        if (this.fIsOpen) {
            this.formula.append(cArray, n, n2);
        }
        if (this.hfIsOpen) {
            this.headerFooter.append(cArray, n, n2);
        }
    }

    private void checkForEmptyCellComments(EmptyCellCommentsCheckType emptyCellCommentsCheckType) {
        if (this.commentCellRefs != null && !this.commentCellRefs.isEmpty()) {
            CellReference cellReference;
            if (emptyCellCommentsCheckType == EmptyCellCommentsCheckType.END_OF_SHEET_DATA) {
                while (!this.commentCellRefs.isEmpty()) {
                    this.outputEmptyCellComment(this.commentCellRefs.remove());
                }
                return;
            }
            if (this.cellRef == null) {
                if (emptyCellCommentsCheckType == EmptyCellCommentsCheckType.END_OF_ROW) {
                    while (!this.commentCellRefs.isEmpty()) {
                        if (this.commentCellRefs.peek().getRow() == this.rowNum) {
                            this.outputEmptyCellComment(this.commentCellRefs.remove());
                            continue;
                        }
                        return;
                    }
                    return;
                }
                throw new IllegalStateException("Cell ref should be null only if there are only empty cells in the row; rowNum: " + this.rowNum);
            }
            do {
                CellReference cellReference2 = new CellReference(this.cellRef);
                CellReference cellReference3 = this.commentCellRefs.peek();
                if (emptyCellCommentsCheckType == EmptyCellCommentsCheckType.CELL && cellReference2.equals(cellReference3)) {
                    this.commentCellRefs.remove();
                    return;
                }
                int n = cellRefComparator.compare(cellReference3, cellReference2);
                if (n > 0 && emptyCellCommentsCheckType == EmptyCellCommentsCheckType.END_OF_ROW && cellReference3.getRow() <= this.rowNum) {
                    cellReference = this.commentCellRefs.remove();
                    this.outputEmptyCellComment(cellReference);
                    continue;
                }
                if (n < 0 && emptyCellCommentsCheckType == EmptyCellCommentsCheckType.CELL && cellReference3.getRow() <= this.rowNum) {
                    cellReference = this.commentCellRefs.remove();
                    this.outputEmptyCellComment(cellReference);
                    continue;
                }
                cellReference = null;
            } while (cellReference != null && !this.commentCellRefs.isEmpty());
        }
    }

    private void outputEmptyCellComment(CellReference cellReference) {
        String string = cellReference.formatAsString();
        XSSFComment xSSFComment = this.commentsTable.findCellComment(string);
        this.output.cell(string, null, xSSFComment);
    }

    public static interface SheetContentsHandler {
        public void startRow(int var1);

        public void endRow(int var1);

        public void cell(String var1, String var2, XSSFComment var3);

        public void headerFooter(String var1, boolean var2, String var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EmptyCellCommentsCheckType {
        CELL,
        END_OF_ROW,
        END_OF_SHEET_DATA;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum xssfDataType {
        BOOLEAN,
        ERROR,
        FORMULA,
        INLINE_STRING,
        SST_STRING,
        NUMBER;

    }
}

