/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.eventusermodel;

import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.util.SAXHelper;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlySharedStringsTable
extends DefaultHandler {
    private int count;
    private int uniqueCount;
    private List<String> strings;
    private StringBuffer characters;
    private boolean tIsOpen;

    public ReadOnlySharedStringsTable(OPCPackage oPCPackage) throws IOException, SAXException {
        ArrayList<PackagePart> arrayList = oPCPackage.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (arrayList.size() > 0) {
            PackagePart packagePart = arrayList.get(0);
            this.readFrom(packagePart.getInputStream());
        }
    }

    public ReadOnlySharedStringsTable(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, SAXException {
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException, SAXException {
        if (inputStream.available() > 0) {
            InputSource inputSource = new InputSource(inputStream);
            try {
                XMLReader xMLReader = SAXHelper.newXMLReader();
                xMLReader.setContentHandler(this);
                xMLReader.parse(inputSource);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException("SAX parser appears to be broken - " + parserConfigurationException.getMessage());
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public String getEntryAt(int n) {
        return this.strings.get(n);
    }

    public List<String> getItems() {
        return this.strings;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("sst".equals(string3)) {
            String string4;
            String string5 = attributes.getValue("count");
            if (string5 != null) {
                this.count = Integer.parseInt(string5);
            }
            if ((string4 = attributes.getValue("uniqueCount")) != null) {
                this.uniqueCount = Integer.parseInt(string4);
            }
            this.strings = new ArrayList<String>(this.uniqueCount);
            this.characters = new StringBuffer();
        } else if ("si".equals(string3)) {
            this.characters.setLength(0);
        } else if ("t".equals(string3)) {
            this.tIsOpen = true;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("si".equals(string3)) {
            this.strings.add(this.characters.toString());
        } else if ("t".equals(string3)) {
            this.tIsOpen = false;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.tIsOpen) {
            this.characters.append(cArray, n, n2);
        }
    }
}

