/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.util;

import ai2.org.apache.poi.sl.draw.Drawable;
import ai2.org.apache.poi.sl.usermodel.Slide;
import ai2.org.apache.poi.sl.usermodel.SlideShow;
import ai2.org.apache.poi.sl.usermodel.SlideShowFactory;
import ai2.org.apache.poi.util.JvmBugs;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;

public class PPTX2PNG {
    static void usage(String string) {
        String string2 = "Usage: PPTX2PNG [options] <ppt or pptx file>\n" + (string == null ? "" : "Error: " + string + "\n") + "Options:\n" + "    -scale <float>   scale factor\n" + "    -slide <integer> 1-based index of a slide to render\n" + "    -format <type>   png,gif,jpg (,null for testing)" + "    -outdir <dir>    output directory, defaults to origin of the ppt/pptx file" + "    -quite           do not write to console (for normal processing)";
        System.out.println(string2);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            PPTX2PNG.usage(null);
            return;
        }
        int n = -1;
        float f = 1.0f;
        File file = null;
        String string = "png";
        File file2 = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) {
                if ("-scale".equals(stringArray[i])) {
                    f = Float.parseFloat(stringArray[++i]);
                    continue;
                }
                if ("-slide".equals(stringArray[i])) {
                    n = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if ("-format".equals(stringArray[i])) {
                    string = stringArray[++i];
                    continue;
                }
                if ("-outdir".equals(stringArray[i])) {
                    file2 = new File(stringArray[++i]);
                    continue;
                }
                if (!"-quite".equals(stringArray[i])) continue;
                bl = true;
                continue;
            }
            file = new File(stringArray[i]);
        }
        if (file == null || !file.exists()) {
            PPTX2PNG.usage("File not specified or it doesn't exist");
            return;
        }
        if (file2 == null) {
            file2 = file.getParentFile();
        }
        if (file2 == null || !file2.exists() || !file2.isDirectory()) {
            PPTX2PNG.usage("Output directory doesn't exist");
            return;
        }
        if (f < 0.0f) {
            PPTX2PNG.usage("Invalid scale given");
            return;
        }
        if (string == null || !string.matches("^(png|gif|jpg|null)$")) {
            PPTX2PNG.usage("Invalid format given");
            return;
        }
        if (!bl) {
            System.out.println("Processing " + file);
        }
        SlideShow<?, ?> slideShow = SlideShowFactory.create(file, null, true);
        List<Slide<?, ?>> list = slideShow.getSlides();
        if (n < -1 || n == 0 || n > list.size()) {
            PPTX2PNG.usage("slidenum must be either -1 (for all) or within range: [1.." + list.size() + "] for " + file);
            return;
        }
        Dimension dimension = slideShow.getPageSize();
        int n2 = (int)((float)dimension.width * f);
        int n3 = (int)((float)dimension.height * f);
        int n4 = 1;
        for (Slide<?, ?> slide : list) {
            if (n == -1 || n4 == n) {
                String string2 = slide.getTitle();
                if (!bl) {
                    System.out.println("Rendering slide " + n4 + (string2 == null ? "" : ": " + string2));
                }
                BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                PPTX2PNG.fixFonts(graphics2D);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics2D.scale(f, f);
                slide.draw(graphics2D);
                if (!"null".equals(string)) {
                    String string3 = file.getName().replaceFirst(".pptx?", "");
                    string3 = String.format(Locale.ROOT, "%1$s-%2$04d.%3$s", string3, n4, string);
                    File file3 = new File(file2, string3);
                    ImageIO.write((RenderedImage)bufferedImage, string, file3);
                }
            }
            ++n4;
        }
        if (!bl) {
            System.out.println("Done");
        }
    }

    private static void fixFonts(Graphics2D graphics2D) {
        if (!JvmBugs.hasLineBreakMeasurerBug()) {
            return;
        }
        HashMap<String, String> hashMap = (HashMap<String, String>)graphics2D.getRenderingHint(Drawable.FONT_MAP);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        hashMap.put("Calibri", "Lucida Sans");
        hashMap.put("Cambria", "Lucida Bright");
        graphics2D.setRenderingHint(Drawable.FONT_MAP, hashMap);
    }
}

