/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.sl.usermodel.TableShape;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.usermodel.XSLFGraphicFrame;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTableCell;
import ai2.org.apache.poi.xslf.usermodel.XSLFTableRow;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTable;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableRow;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrameNonVisual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFTable
extends XSLFGraphicFrame
implements Iterable<XSLFTableRow>,
TableShape<XSLFShape, XSLFTextParagraph> {
    static String TABLE_URI = "http://schemas.openxmlformats.org/drawingml/2006/table";
    private CTTable _table;
    private List<XSLFTableRow> _rows;

    XSLFTable(CTGraphicalObjectFrame cTGraphicalObjectFrame, XSLFSheet xSLFSheet) {
        super(cTGraphicalObjectFrame, xSLFSheet);
        XmlObject[] xmlObjectArray = cTGraphicalObjectFrame.getGraphic().getGraphicData().selectPath("declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' ./a:tbl");
        if (xmlObjectArray.length == 0) {
            throw new IllegalStateException("a:tbl element was not found in\n " + cTGraphicalObjectFrame.getGraphic().getGraphicData());
        }
        if (xmlObjectArray[0] instanceof XmlAnyTypeImpl) {
            try {
                xmlObjectArray[0] = CTTable.Factory.parse((String)xmlObjectArray[0].toString());
            }
            catch (XmlException xmlException) {
                throw new POIXMLException(xmlException);
            }
        }
        this._table = (CTTable)xmlObjectArray[0];
        CTTableRow[] cTTableRowArray = this._table.getTrArray();
        this._rows = new ArrayList<XSLFTableRow>(cTTableRowArray.length);
        for (CTTableRow cTTableRow : cTTableRowArray) {
            this._rows.add(new XSLFTableRow(cTTableRow, this));
        }
    }

    @Internal
    public CTTable getCTTable() {
        return this._table;
    }

    public int getNumberOfColumns() {
        return this._table.getTblGrid().sizeOfGridColArray();
    }

    public int getNumberOfRows() {
        return this._table.sizeOfTrArray();
    }

    public double getColumnWidth(int n) {
        return Units.toPoints(this._table.getTblGrid().getGridColArray(n).getW());
    }

    public void setColumnWidth(int n, double d) {
        this._table.getTblGrid().getGridColArray(n).setW((long)Units.toEMU(d));
    }

    @Override
    public Iterator<XSLFTableRow> iterator() {
        return this._rows.iterator();
    }

    public List<XSLFTableRow> getRows() {
        return Collections.unmodifiableList(this._rows);
    }

    public XSLFTableRow addRow() {
        CTTableRow cTTableRow = this._table.addNewTr();
        XSLFTableRow xSLFTableRow = new XSLFTableRow(cTTableRow, this);
        xSLFTableRow.setHeight(20.0);
        this._rows.add(xSLFTableRow);
        return xSLFTableRow;
    }

    static CTGraphicalObjectFrame prototype(int n) {
        CTGraphicalObjectFrame cTGraphicalObjectFrame = CTGraphicalObjectFrame.Factory.newInstance();
        CTGraphicalObjectFrameNonVisual cTGraphicalObjectFrameNonVisual = cTGraphicalObjectFrame.addNewNvGraphicFramePr();
        CTNonVisualDrawingProps cTNonVisualDrawingProps = cTGraphicalObjectFrameNonVisual.addNewCNvPr();
        cTNonVisualDrawingProps.setName("Table " + n);
        cTNonVisualDrawingProps.setId((long)(n + 1));
        cTGraphicalObjectFrameNonVisual.addNewCNvGraphicFramePr().addNewGraphicFrameLocks().setNoGrp(true);
        cTGraphicalObjectFrameNonVisual.addNewNvPr();
        cTGraphicalObjectFrame.addNewXfrm();
        CTGraphicalObjectData cTGraphicalObjectData = cTGraphicalObjectFrame.addNewGraphic().addNewGraphicData();
        XmlCursor xmlCursor = cTGraphicalObjectData.newCursor();
        xmlCursor.toNextToken();
        xmlCursor.beginElement(new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "tbl"));
        xmlCursor.beginElement(new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "tblPr"));
        xmlCursor.toNextToken();
        xmlCursor.beginElement(new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "tblGrid"));
        xmlCursor.dispose();
        cTGraphicalObjectData.setUri(TABLE_URI);
        return cTGraphicalObjectFrame;
    }

    public void mergeCells(int n, int n2, int n3, int n4) {
        if (n > n2) {
            throw new IllegalArgumentException("Cannot merge, first row > last row : " + n + " > " + n2);
        }
        if (n3 > n4) {
            throw new IllegalArgumentException("Cannot merge, first column > last column : " + n3 + " > " + n4);
        }
        int n5 = n2 - n + 1;
        boolean bl = n5 > 1;
        int n6 = n4 - n3 + 1;
        boolean bl2 = n6 > 1;
        for (int i = n; i <= n2; ++i) {
            XSLFTableRow xSLFTableRow = this._rows.get(i);
            for (int j = n3; j <= n4; ++j) {
                XSLFTableCell xSLFTableCell = xSLFTableRow.getCells().get(j);
                if (bl) {
                    if (i == n) {
                        xSLFTableCell.setRowSpan(n5);
                    } else {
                        xSLFTableCell.setVMerge(true);
                    }
                }
                if (!bl2) continue;
                if (j == n3) {
                    xSLFTableCell.setGridSpan(n6);
                    continue;
                }
                xSLFTableCell.setHMerge(true);
            }
        }
    }
}

