/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.sl.draw.geom.CustomGeometry;
import ai2.org.apache.poi.sl.draw.geom.Guide;
import ai2.org.apache.poi.sl.draw.geom.PresetGeometries;
import ai2.org.apache.poi.sl.usermodel.FillStyle;
import ai2.org.apache.poi.sl.usermodel.LineDecoration;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.sl.usermodel.SimpleShape;
import ai2.org.apache.poi.sl.usermodel.StrokeStyle;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.model.PropertyFetcher;
import ai2.org.apache.poi.xslf.usermodel.XSLFShadow;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.awt.Color;
import java.awt.Rectangle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBaseStyles;
import org.openxmlformats.schemas.drawingml.x2006.main.CTEffectStyleItem;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuide;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineEndProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineStyleList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOuterShadowEffect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetLineDashProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrix;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STCompoundLine;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineCap;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndLength;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndType;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndWidth;
import org.openxmlformats.schemas.drawingml.x2006.main.STPresetLineDashVal;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSLFSimpleShape
extends XSLFShape
implements SimpleShape<XSLFShape, XSLFTextParagraph> {
    private static CTOuterShadowEffect NO_SHADOW = CTOuterShadowEffect.Factory.newInstance();

    XSLFSimpleShape(XmlObject xmlObject, XSLFSheet xSLFSheet) {
        super(xmlObject, xSLFSheet);
    }

    public void setShapeType(ShapeType shapeType) {
        STShapeType.Enum enum_ = STShapeType.Enum.forInt((int)shapeType.ooxmlId);
        this.getSpPr().getPrstGeom().setPrst(enum_);
    }

    @Override
    public ShapeType getShapeType() {
        STShapeType.Enum enum_ = this.getSpPr().getPrstGeom().getPrst();
        return ShapeType.forId(enum_.intValue(), true);
    }

    protected CTTransform2D getSafeXfrm() {
        CTTransform2D cTTransform2D = this.getXfrm();
        return cTTransform2D == null ? this.getSpPr().addNewXfrm() : cTTransform2D;
    }

    protected CTTransform2D getXfrm() {
        PropertyFetcher<CTTransform2D> propertyFetcher = new PropertyFetcher<CTTransform2D>(){

            @Override
            public boolean fetch(XSLFShape xSLFShape) {
                CTShapeProperties cTShapeProperties = xSLFShape.getSpPr();
                if (cTShapeProperties.isSetXfrm()) {
                    this.setValue(cTShapeProperties.getXfrm());
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(propertyFetcher);
        return (CTTransform2D)propertyFetcher.getValue();
    }

    @Override
    public Rectangle getAnchor() {
        CTTransform2D cTTransform2D = this.getXfrm();
        CTPoint2D cTPoint2D = cTTransform2D.getOff();
        int n = (int)Units.toPoints(cTPoint2D.getX());
        int n2 = (int)Units.toPoints(cTPoint2D.getY());
        CTPositiveSize2D cTPositiveSize2D = cTTransform2D.getExt();
        int n3 = (int)Units.toPoints(cTPositiveSize2D.getCx());
        int n4 = (int)Units.toPoints(cTPositiveSize2D.getCy());
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void setAnchor(Rectangle rectangle) {
        CTTransform2D cTTransform2D = this.getSafeXfrm();
        CTPoint2D cTPoint2D = cTTransform2D.isSetOff() ? cTTransform2D.getOff() : cTTransform2D.addNewOff();
        long l = Units.toEMU(rectangle.getX());
        long l2 = Units.toEMU(rectangle.getY());
        cTPoint2D.setX(l);
        cTPoint2D.setY(l2);
        CTPositiveSize2D cTPositiveSize2D = cTTransform2D.isSetExt() ? cTTransform2D.getExt() : cTTransform2D.addNewExt();
        long l3 = Units.toEMU(rectangle.getWidth());
        long l4 = Units.toEMU(rectangle.getHeight());
        cTPositiveSize2D.setCx(l3);
        cTPositiveSize2D.setCy(l4);
    }

    @Override
    public void setRotation(double d) {
        this.getSafeXfrm().setRot((int)(d * 60000.0));
    }

    @Override
    public double getRotation() {
        CTTransform2D cTTransform2D = this.getXfrm();
        return cTTransform2D == null || !cTTransform2D.isSetRot() ? 0.0 : (double)cTTransform2D.getRot() / 60000.0;
    }

    @Override
    public void setFlipHorizontal(boolean bl) {
        this.getSafeXfrm().setFlipH(bl);
    }

    @Override
    public void setFlipVertical(boolean bl) {
        this.getSafeXfrm().setFlipV(bl);
    }

    @Override
    public boolean getFlipHorizontal() {
        CTTransform2D cTTransform2D = this.getXfrm();
        return cTTransform2D == null || !cTTransform2D.isSetFlipH() ? false : this.getXfrm().getFlipH();
    }

    @Override
    public boolean getFlipVertical() {
        CTTransform2D cTTransform2D = this.getXfrm();
        return cTTransform2D == null || !cTTransform2D.isSetFlipV() ? false : this.getXfrm().getFlipV();
    }

    CTLineProperties getDefaultLineProperties() {
        CTShapeStyle cTShapeStyle = this.getSpStyle();
        if (cTShapeStyle == null) {
            return null;
        }
        CTStyleMatrixReference cTStyleMatrixReference = cTShapeStyle.getLnRef();
        if (cTStyleMatrixReference == null) {
            return null;
        }
        int n = (int)cTStyleMatrixReference.getIdx();
        XSLFTheme xSLFTheme = this.getSheet().getTheme();
        if (xSLFTheme == null) {
            return null;
        }
        CTBaseStyles cTBaseStyles = xSLFTheme.getXmlObject().getThemeElements();
        if (cTBaseStyles == null) {
            return null;
        }
        CTStyleMatrix cTStyleMatrix = cTBaseStyles.getFmtScheme();
        if (cTStyleMatrix == null) {
            return null;
        }
        CTLineStyleList cTLineStyleList = cTStyleMatrix.getLnStyleLst();
        if (cTLineStyleList == null || cTLineStyleList.sizeOfLnArray() < n) {
            return null;
        }
        return cTLineStyleList.getLnArray(n - 1);
    }

    public void setLineColor(Color color) {
        CTShapeProperties cTShapeProperties = this.getSpPr();
        if (color == null) {
            if (cTShapeProperties.isSetLn() && cTShapeProperties.getLn().isSetSolidFill()) {
                cTShapeProperties.getLn().unsetSolidFill();
            }
        } else {
            CTLineProperties cTLineProperties = cTShapeProperties.isSetLn() ? cTShapeProperties.getLn() : cTShapeProperties.addNewLn();
            CTSRgbColor cTSRgbColor = CTSRgbColor.Factory.newInstance();
            cTSRgbColor.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            CTSolidColorFillProperties cTSolidColorFillProperties = cTLineProperties.isSetSolidFill() ? cTLineProperties.getSolidFill() : cTLineProperties.addNewSolidFill();
            cTSolidColorFillProperties.setSrgbClr(cTSRgbColor);
            if (cTSolidColorFillProperties.isSetHslClr()) {
                cTSolidColorFillProperties.unsetHslClr();
            }
            if (cTSolidColorFillProperties.isSetPrstClr()) {
                cTSolidColorFillProperties.unsetPrstClr();
            }
            if (cTSolidColorFillProperties.isSetSchemeClr()) {
                cTSolidColorFillProperties.unsetSchemeClr();
            }
            if (cTSolidColorFillProperties.isSetScrgbClr()) {
                cTSolidColorFillProperties.unsetScrgbClr();
            }
            if (cTSolidColorFillProperties.isSetSysClr()) {
                cTSolidColorFillProperties.unsetSysClr();
            }
        }
    }

    public Color getLineColor() {
        PaintStyle paintStyle = this.getLinePaint();
        if (paintStyle instanceof PaintStyle.SolidPaint) {
            return ((PaintStyle.SolidPaint)paintStyle).getSolidColor().getColor();
        }
        return null;
    }

    protected PaintStyle getLinePaint() {
        PropertyFetcher<PaintStyle> propertyFetcher = new PropertyFetcher<PaintStyle>(){

            @Override
            public boolean fetch(XSLFShape xSLFShape) {
                CTLineProperties cTLineProperties = xSLFShape.getSpPr().getLn();
                if (cTLineProperties != null) {
                    if (cTLineProperties.isSetNoFill()) {
                        this.setValue(null);
                        return true;
                    }
                    PaintStyle paintStyle = null;
                    PackagePart packagePart = XSLFSimpleShape.this.getSheet().getPackagePart();
                    for (XmlObject xmlObject : cTLineProperties.selectPath("*")) {
                        paintStyle = XSLFSimpleShape.this.selectPaint(xmlObject, null, packagePart);
                        if (paintStyle == null) continue;
                        this.setValue(paintStyle);
                        return true;
                    }
                    CTShapeStyle cTShapeStyle = xSLFShape.getSpStyle();
                    if (cTShapeStyle != null && (paintStyle = XSLFSimpleShape.this.selectPaint(cTShapeStyle.getLnRef())) != null) {
                        this.setValue(paintStyle);
                        return true;
                    }
                }
                return false;
            }
        };
        this.fetchShapeProperty(propertyFetcher);
        PaintStyle paintStyle = (PaintStyle)propertyFetcher.getValue();
        if (paintStyle != null) {
            return paintStyle;
        }
        CTShapeStyle cTShapeStyle = this.getSpStyle();
        if (cTShapeStyle == null) {
            return null;
        }
        CTStyleMatrixReference cTStyleMatrixReference = cTShapeStyle.getLnRef();
        int n = (int)cTStyleMatrixReference.getIdx();
        CTSchemeColor cTSchemeColor = cTStyleMatrixReference.getSchemeClr();
        if (n > 0) {
            XSLFTheme xSLFTheme = this.getSheet().getTheme();
            XmlObject xmlObject = xSLFTheme.getXmlObject().getThemeElements().getFmtScheme().getLnStyleLst().selectPath("*")[n - 1];
            paintStyle = this.getPaint(xmlObject, cTSchemeColor);
        }
        return paintStyle;
    }

    public void setLineWidth(double d) {
        CTShapeProperties cTShapeProperties = this.getSpPr();
        if (d == 0.0) {
            if (cTShapeProperties.isSetLn() && cTShapeProperties.getLn().isSetW()) {
                cTShapeProperties.getLn().unsetW();
            }
        } else {
            CTLineProperties cTLineProperties = cTShapeProperties.isSetLn() ? cTShapeProperties.getLn() : cTShapeProperties.addNewLn();
            cTLineProperties.setW(Units.toEMU(d));
        }
    }

    public double getLineWidth() {
        PropertyFetcher<Double> propertyFetcher = new PropertyFetcher<Double>(){

            @Override
            public boolean fetch(XSLFShape xSLFShape) {
                CTShapeProperties cTShapeProperties = xSLFShape.getSpPr();
                CTLineProperties cTLineProperties = cTShapeProperties.getLn();
                if (cTLineProperties != null) {
                    if (cTLineProperties.isSetNoFill()) {
                        this.setValue(0.0);
                        return true;
                    }
                    if (cTLineProperties.isSetW()) {
                        this.setValue(Units.toPoints(cTLineProperties.getW()));
                        return true;
                    }
                }
                return false;
            }
        };
        this.fetchShapeProperty(propertyFetcher);
        double d = 0.0;
        if (propertyFetcher.getValue() == null) {
            CTLineProperties cTLineProperties = this.getDefaultLineProperties();
            if (cTLineProperties != null && cTLineProperties.isSetW()) {
                d = Units.toPoints(cTLineProperties.getW());
            }
        } else {
            d = (Double)propertyFetcher.getValue();
        }
        return d;
    }

    public StrokeStyle.LineCompound getLineCompound() {
        STCompoundLine.Enum enum_;
        CTLineProperties cTLineProperties;
        PropertyFetcher<Integer> propertyFetcher = new PropertyFetcher<Integer>(){

            @Override
            public boolean fetch(XSLFShape xSLFShape) {
                STCompoundLine.Enum enum_;
                CTShapeProperties cTShapeProperties = xSLFShape.getSpPr();
                CTLineProperties cTLineProperties = cTShapeProperties.getLn();
                if (cTLineProperties != null && (enum_ = cTLineProperties.getCmpd()) != null) {
                    this.setValue(enum_.intValue());
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(propertyFetcher);
        Integer n = (Integer)propertyFetcher.getValue();
        if (n == null && (cTLineProperties = this.getDefaultLineProperties()) != null && (enum_ = cTLineProperties.getCmpd()) != null) {
            n = enum_.intValue();
        }
        if (n == null) {
            return null;
        }
        switch (n) {
            default: {
                return StrokeStyle.LineCompound.SINGLE;
            }
            case 2: {
                return StrokeStyle.LineCompound.DOUBLE;
            }
            case 3: {
                return StrokeStyle.LineCompound.THICK_THIN;
            }
            case 4: {
                return StrokeStyle.LineCompound.THIN_THICK;
            }
            case 5: 
        }
        return StrokeStyle.LineCompound.TRIPLE;
    }

    public void setLineDash(StrokeStyle.LineDash lineDash) {
        CTShapeProperties cTShapeProperties = this.getSpPr();
        if (lineDash == null) {
            if (cTShapeProperties.isSetLn() && cTShapeProperties.getLn().isSetPrstDash()) {
                cTShapeProperties.getLn().unsetPrstDash();
            }
        } else {
            CTPresetLineDashProperties cTPresetLineDashProperties = CTPresetLineDashProperties.Factory.newInstance();
            cTPresetLineDashProperties.setVal(STPresetLineDashVal.Enum.forInt((int)lineDash.ooxmlId));
            CTLineProperties cTLineProperties = cTShapeProperties.isSetLn() ? cTShapeProperties.getLn() : cTShapeProperties.addNewLn();
            cTLineProperties.setPrstDash(cTPresetLineDashProperties);
        }
    }

    public StrokeStyle.LineDash getLineDash() {
        CTPresetLineDashProperties cTPresetLineDashProperties;
        CTLineProperties cTLineProperties;
        PropertyFetcher<StrokeStyle.LineDash> propertyFetcher = new PropertyFetcher<StrokeStyle.LineDash>(){

            @Override
            public boolean fetch(XSLFShape xSLFShape) {
                CTPresetLineDashProperties cTPresetLineDashProperties;
                CTShapeProperties cTShapeProperties = xSLFShape.getSpPr();
                CTLineProperties cTLineProperties = cTShapeProperties.getLn();
                if (cTLineProperties != null && (cTPresetLineDashProperties = cTLineProperties.getPrstDash()) != null) {
                    this.setValue(StrokeStyle.LineDash.fromOoxmlId(cTPresetLineDashProperties.getVal().intValue()));
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(propertyFetcher);
        StrokeStyle.LineDash lineDash = (StrokeStyle.LineDash)((Object)propertyFetcher.getValue());
        if (lineDash == null && (cTLineProperties = this.getDefaultLineProperties()) != null && (cTPresetLineDashProperties = cTLineProperties.getPrstDash()) != null) {
            lineDash = StrokeStyle.LineDash.fromOoxmlId(cTPresetLineDashProperties.getVal().intValue());
        }
        return lineDash;
    }

    public void setLineCap(StrokeStyle.LineCap lineCap) {
        CTShapeProperties cTShapeProperties = this.getSpPr();
        if (lineCap == null) {
            if (cTShapeProperties.isSetLn() && cTShapeProperties.getLn().isSetCap()) {
                cTShapeProperties.getLn().unsetCap();
            }
        } else {
            CTLineProperties cTLineProperties = cTShapeProperties.isSetLn() ? cTShapeProperties.getLn() : cTShapeProperties.addNewLn();
            cTLineProperties.setCap(STLineCap.Enum.forInt((int)lineCap.ooxmlId));
        }
    }

    public StrokeStyle.LineCap getLineCap() {
        STLineCap.Enum enum_;
        CTLineProperties cTLineProperties;
        PropertyFetcher<StrokeStyle.LineCap> propertyFetcher = new PropertyFetcher<StrokeStyle.LineCap>(){

            @Override
            public boolean fetch(XSLFShape xSLFShape) {
                STLineCap.Enum enum_;
                CTShapeProperties cTShapeProperties = xSLFShape.getSpPr();
                CTLineProperties cTLineProperties = cTShapeProperties.getLn();
                if (cTLineProperties != null && (enum_ = cTLineProperties.getCap()) != null) {
                    this.setValue(StrokeStyle.LineCap.fromOoxmlId(enum_.intValue()));
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(propertyFetcher);
        StrokeStyle.LineCap lineCap = (StrokeStyle.LineCap)((Object)propertyFetcher.getValue());
        if (lineCap == null && (cTLineProperties = this.getDefaultLineProperties()) != null && (enum_ = cTLineProperties.getCap()) != null) {
            lineCap = StrokeStyle.LineCap.fromOoxmlId(enum_.intValue());
        }
        return lineCap;
    }

    public void setFillColor(Color color) {
        CTShapeProperties cTShapeProperties = this.getSpPr();
        if (color == null) {
            if (cTShapeProperties.isSetSolidFill()) {
                cTShapeProperties.unsetSolidFill();
            }
            if (!cTShapeProperties.isSetNoFill()) {
                cTShapeProperties.addNewNoFill();
            }
        } else {
            if (cTShapeProperties.isSetNoFill()) {
                cTShapeProperties.unsetNoFill();
            }
            CTSolidColorFillProperties cTSolidColorFillProperties = cTShapeProperties.isSetSolidFill() ? cTShapeProperties.getSolidFill() : cTShapeProperties.addNewSolidFill();
            CTSRgbColor cTSRgbColor = CTSRgbColor.Factory.newInstance();
            cTSRgbColor.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            cTSolidColorFillProperties.setSrgbClr(cTSRgbColor);
            if (cTSolidColorFillProperties.isSetHslClr()) {
                cTSolidColorFillProperties.unsetHslClr();
            }
            if (cTSolidColorFillProperties.isSetPrstClr()) {
                cTSolidColorFillProperties.unsetPrstClr();
            }
            if (cTSolidColorFillProperties.isSetSchemeClr()) {
                cTSolidColorFillProperties.unsetSchemeClr();
            }
            if (cTSolidColorFillProperties.isSetScrgbClr()) {
                cTSolidColorFillProperties.unsetScrgbClr();
            }
            if (cTSolidColorFillProperties.isSetSysClr()) {
                cTSolidColorFillProperties.unsetSysClr();
            }
        }
    }

    public Color getFillColor() {
        PaintStyle paintStyle = this.getFillPaint();
        if (paintStyle instanceof PaintStyle.SolidPaint) {
            return ((PaintStyle.SolidPaint)paintStyle).getSolidColor().getColor();
        }
        return null;
    }

    public XSLFShadow getShadow() {
        int n;
        CTShapeStyle cTShapeStyle;
        PropertyFetcher<CTOuterShadowEffect> propertyFetcher = new PropertyFetcher<CTOuterShadowEffect>(){

            @Override
            public boolean fetch(XSLFShape xSLFShape) {
                CTShapeProperties cTShapeProperties = xSLFShape.getSpPr();
                if (cTShapeProperties.isSetEffectLst()) {
                    CTOuterShadowEffect cTOuterShadowEffect = cTShapeProperties.getEffectLst().getOuterShdw();
                    this.setValue(cTOuterShadowEffect == null ? NO_SHADOW : cTOuterShadowEffect);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(propertyFetcher);
        CTOuterShadowEffect cTOuterShadowEffect = (CTOuterShadowEffect)propertyFetcher.getValue();
        if (cTOuterShadowEffect == null && (cTShapeStyle = this.getSpStyle()) != null && (n = (int)cTShapeStyle.getEffectRef().getIdx()) != 0) {
            CTStyleMatrix cTStyleMatrix = this.getSheet().getTheme().getXmlObject().getThemeElements().getFmtScheme();
            CTEffectStyleItem cTEffectStyleItem = cTStyleMatrix.getEffectStyleLst().getEffectStyleArray(n - 1);
            cTOuterShadowEffect = cTEffectStyleItem.getEffectLst().getOuterShdw();
        }
        return cTOuterShadowEffect == null || cTOuterShadowEffect == NO_SHADOW ? null : new XSLFShadow(cTOuterShadowEffect, this);
    }

    @Override
    public CustomGeometry getGeometry() {
        CustomGeometry customGeometry;
        CTShapeProperties cTShapeProperties = this.getSpPr();
        PresetGeometries presetGeometries = PresetGeometries.getInstance();
        if (cTShapeProperties.isSetPrstGeom()) {
            String string = cTShapeProperties.getPrstGeom().getPrst().toString();
            customGeometry = (CustomGeometry)presetGeometries.get(string);
            if (customGeometry == null) {
                throw new IllegalStateException("Unknown shape geometry: " + string + ", available geometries are: " + presetGeometries.keySet());
            }
        } else if (cTShapeProperties.isSetCustGeom()) {
            XMLStreamReader xMLStreamReader = cTShapeProperties.getCustGeom().newXMLStreamReader();
            customGeometry = PresetGeometries.convertCustomGeometry(xMLStreamReader);
            try {
                xMLStreamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {}
        } else {
            customGeometry = (CustomGeometry)presetGeometries.get("rect");
        }
        return customGeometry;
    }

    @Override
    void copy(XSLFShape xSLFShape) {
        double d;
        double d2;
        Object object;
        Color color;
        super.copy(xSLFShape);
        XSLFSimpleShape xSLFSimpleShape = (XSLFSimpleShape)xSLFShape;
        Color color2 = xSLFSimpleShape.getFillColor();
        Color color3 = this.getFillColor();
        if (color2 != null && !color2.equals(color3)) {
            this.setFillColor(color2);
        }
        if (this.getSpPr().isSetBlipFill()) {
            color = this.getSpPr().getBlipFill().getBlip();
            object = color.getEmbed();
            String string = this.getSheet().importBlip((String)object, xSLFSimpleShape.getSheet().getPackagePart());
            color.setEmbed(string);
        }
        color = xSLFSimpleShape.getLineColor();
        object = this.getLineColor();
        if (color != null && !color.equals(object)) {
            this.setLineColor(color);
        }
        if ((d2 = xSLFSimpleShape.getLineWidth()) != (d = this.getLineWidth())) {
            this.setLineWidth(d2);
        }
        StrokeStyle.LineDash lineDash = xSLFSimpleShape.getLineDash();
        StrokeStyle.LineDash lineDash2 = this.getLineDash();
        if (lineDash != null && lineDash != lineDash2) {
            this.setLineDash(lineDash);
        }
        StrokeStyle.LineCap lineCap = xSLFSimpleShape.getLineCap();
        StrokeStyle.LineCap lineCap2 = this.getLineCap();
        if (lineCap != null && lineCap != lineCap2) {
            this.setLineCap(lineCap);
        }
    }

    public void setLineHeadDecoration(LineDecoration.DecorationShape decorationShape) {
        CTLineEndProperties cTLineEndProperties;
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties2 = cTLineEndProperties = cTLineProperties.isSetHeadEnd() ? cTLineProperties.getHeadEnd() : cTLineProperties.addNewHeadEnd();
        if (decorationShape == null) {
            if (cTLineEndProperties.isSetType()) {
                cTLineEndProperties.unsetType();
            }
        } else {
            cTLineEndProperties.setType(STLineEndType.Enum.forInt((int)decorationShape.ooxmlId));
        }
    }

    public LineDecoration.DecorationShape getLineHeadDecoration() {
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        if (cTLineProperties == null || !cTLineProperties.isSetHeadEnd()) {
            return LineDecoration.DecorationShape.NONE;
        }
        STLineEndType.Enum enum_ = cTLineProperties.getHeadEnd().getType();
        return enum_ == null ? LineDecoration.DecorationShape.NONE : LineDecoration.DecorationShape.fromOoxmlId(enum_.intValue());
    }

    public void setLineHeadWidth(LineDecoration.DecorationSize decorationSize) {
        CTLineEndProperties cTLineEndProperties;
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties2 = cTLineEndProperties = cTLineProperties.isSetHeadEnd() ? cTLineProperties.getHeadEnd() : cTLineProperties.addNewHeadEnd();
        if (decorationSize == null) {
            if (cTLineEndProperties.isSetW()) {
                cTLineEndProperties.unsetW();
            }
        } else {
            cTLineEndProperties.setW(STLineEndWidth.Enum.forInt((int)decorationSize.ooxmlId));
        }
    }

    public LineDecoration.DecorationSize getLineHeadWidth() {
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        if (cTLineProperties == null || !cTLineProperties.isSetHeadEnd()) {
            return LineDecoration.DecorationSize.MEDIUM;
        }
        STLineEndWidth.Enum enum_ = cTLineProperties.getHeadEnd().getW();
        return enum_ == null ? LineDecoration.DecorationSize.MEDIUM : LineDecoration.DecorationSize.fromOoxmlId(enum_.intValue());
    }

    public void setLineHeadLength(LineDecoration.DecorationSize decorationSize) {
        CTLineEndProperties cTLineEndProperties;
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties2 = cTLineEndProperties = cTLineProperties.isSetHeadEnd() ? cTLineProperties.getHeadEnd() : cTLineProperties.addNewHeadEnd();
        if (decorationSize == null) {
            if (cTLineEndProperties.isSetLen()) {
                cTLineEndProperties.unsetLen();
            }
        } else {
            cTLineEndProperties.setLen(STLineEndLength.Enum.forInt((int)decorationSize.ooxmlId));
        }
    }

    public LineDecoration.DecorationSize getLineHeadLength() {
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        if (cTLineProperties == null || !cTLineProperties.isSetHeadEnd()) {
            return LineDecoration.DecorationSize.MEDIUM;
        }
        STLineEndLength.Enum enum_ = cTLineProperties.getHeadEnd().getLen();
        return enum_ == null ? LineDecoration.DecorationSize.MEDIUM : LineDecoration.DecorationSize.fromOoxmlId(enum_.intValue());
    }

    public void setLineTailDecoration(LineDecoration.DecorationShape decorationShape) {
        CTLineEndProperties cTLineEndProperties;
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties2 = cTLineEndProperties = cTLineProperties.isSetTailEnd() ? cTLineProperties.getTailEnd() : cTLineProperties.addNewTailEnd();
        if (decorationShape == null) {
            if (cTLineEndProperties.isSetType()) {
                cTLineEndProperties.unsetType();
            }
        } else {
            cTLineEndProperties.setType(STLineEndType.Enum.forInt((int)decorationShape.ooxmlId));
        }
    }

    public LineDecoration.DecorationShape getLineTailDecoration() {
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        if (cTLineProperties == null || !cTLineProperties.isSetTailEnd()) {
            return LineDecoration.DecorationShape.NONE;
        }
        STLineEndType.Enum enum_ = cTLineProperties.getTailEnd().getType();
        return enum_ == null ? LineDecoration.DecorationShape.NONE : LineDecoration.DecorationShape.fromOoxmlId(enum_.intValue());
    }

    public void setLineTailWidth(LineDecoration.DecorationSize decorationSize) {
        CTLineEndProperties cTLineEndProperties;
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties2 = cTLineEndProperties = cTLineProperties.isSetTailEnd() ? cTLineProperties.getTailEnd() : cTLineProperties.addNewTailEnd();
        if (decorationSize == null) {
            if (cTLineEndProperties.isSetW()) {
                cTLineEndProperties.unsetW();
            }
        } else {
            cTLineEndProperties.setW(STLineEndWidth.Enum.forInt((int)decorationSize.ooxmlId));
        }
    }

    public LineDecoration.DecorationSize getLineTailWidth() {
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        if (cTLineProperties == null || !cTLineProperties.isSetTailEnd()) {
            return LineDecoration.DecorationSize.MEDIUM;
        }
        STLineEndWidth.Enum enum_ = cTLineProperties.getTailEnd().getW();
        return enum_ == null ? LineDecoration.DecorationSize.MEDIUM : LineDecoration.DecorationSize.fromOoxmlId(enum_.intValue());
    }

    public void setLineTailLength(LineDecoration.DecorationSize decorationSize) {
        CTLineEndProperties cTLineEndProperties;
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties2 = cTLineEndProperties = cTLineProperties.isSetTailEnd() ? cTLineProperties.getTailEnd() : cTLineProperties.addNewTailEnd();
        if (decorationSize == null) {
            if (cTLineEndProperties.isSetLen()) {
                cTLineEndProperties.unsetLen();
            }
        } else {
            cTLineEndProperties.setLen(STLineEndLength.Enum.forInt((int)decorationSize.ooxmlId));
        }
    }

    public LineDecoration.DecorationSize getLineTailLength() {
        CTLineProperties cTLineProperties = this.getSpPr().getLn();
        if (cTLineProperties == null || !cTLineProperties.isSetTailEnd()) {
            return LineDecoration.DecorationSize.MEDIUM;
        }
        STLineEndLength.Enum enum_ = cTLineProperties.getTailEnd().getLen();
        return enum_ == null ? LineDecoration.DecorationSize.MEDIUM : LineDecoration.DecorationSize.fromOoxmlId(enum_.intValue());
    }

    @Override
    public boolean isPlaceholder() {
        CTPlaceholder cTPlaceholder = this.getCTPlaceholder();
        return cTPlaceholder != null;
    }

    @Override
    public Guide getAdjustValue(String string) {
        CTPresetGeometry2D cTPresetGeometry2D = this.getSpPr().getPrstGeom();
        if (cTPresetGeometry2D.isSetAvLst()) {
            for (CTGeomGuide cTGeomGuide : cTPresetGeometry2D.getAvLst().getGdArray()) {
                if (!cTGeomGuide.getName().equals(string)) continue;
                return new Guide(cTGeomGuide.getName(), cTGeomGuide.getFmla());
            }
        }
        return null;
    }

    @Override
    public LineDecoration getLineDecoration() {
        return new LineDecoration(){

            public LineDecoration.DecorationShape getHeadShape() {
                return XSLFSimpleShape.this.getLineHeadDecoration();
            }

            public LineDecoration.DecorationSize getHeadWidth() {
                return XSLFSimpleShape.this.getLineHeadWidth();
            }

            public LineDecoration.DecorationSize getHeadLength() {
                return XSLFSimpleShape.this.getLineHeadLength();
            }

            public LineDecoration.DecorationShape getTailShape() {
                return XSLFSimpleShape.this.getLineTailDecoration();
            }

            public LineDecoration.DecorationSize getTailWidth() {
                return XSLFSimpleShape.this.getLineTailWidth();
            }

            public LineDecoration.DecorationSize getTailLength() {
                return XSLFSimpleShape.this.getLineTailLength();
            }
        };
    }

    @Override
    public FillStyle getFillStyle() {
        return new FillStyle(){

            public PaintStyle getPaint() {
                return XSLFSimpleShape.this.getFillPaint();
            }
        };
    }

    @Override
    public StrokeStyle getStrokeStyle() {
        return new StrokeStyle(){

            public PaintStyle getPaint() {
                return XSLFSimpleShape.this.getLinePaint();
            }

            public StrokeStyle.LineCap getLineCap() {
                return XSLFSimpleShape.this.getLineCap();
            }

            public StrokeStyle.LineDash getLineDash() {
                return XSLFSimpleShape.this.getLineDash();
            }

            public double getLineWidth() {
                return XSLFSimpleShape.this.getLineWidth();
            }

            public StrokeStyle.LineCompound getLineCompound() {
                return XSLFSimpleShape.this.getLineCompound();
            }
        };
    }
}

