/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.usermodel.ColorStyle;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.PlaceableShape;
import ai2.org.apache.poi.sl.usermodel.Shape;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xslf.model.PropertyFetcher;
import ai2.org.apache.poi.xslf.usermodel.Placeholder;
import ai2.org.apache.poi.xslf.usermodel.XSLFColor;
import ai2.org.apache.poi.xslf.usermodel.XSLFShapeContainer;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNoFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrix;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.drawingml.x2006.main.STPathShadeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackgroundProperties;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.STPlaceholderType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSLFShape
implements Shape<XSLFShape, XSLFTextParagraph> {
    private final XmlObject _shape;
    private final XSLFSheet _sheet;
    private XSLFShapeContainer _parent;
    private CTShapeProperties _spPr;
    private CTShapeStyle _spStyle;
    private CTNonVisualDrawingProps _nvPr;
    private CTPlaceholder _ph;

    protected XSLFShape(XmlObject xmlObject, XSLFSheet xSLFSheet) {
        this._shape = xmlObject;
        this._sheet = xSLFSheet;
    }

    public final XmlObject getXmlObject() {
        return this._shape;
    }

    public XSLFSheet getSheet() {
        return this._sheet;
    }

    public String getShapeName() {
        return this.getCNvPr().getName();
    }

    public int getShapeId() {
        return (int)this.getCNvPr().getId();
    }

    @Internal
    void copy(XSLFShape xSLFShape) {
        if (!this.getClass().isInstance(xSLFShape)) {
            throw new IllegalArgumentException("Can't copy " + xSLFShape.getClass().getSimpleName() + " into " + this.getClass().getSimpleName());
        }
        if (this instanceof PlaceableShape) {
            PlaceableShape placeableShape = (PlaceableShape)((Object)this);
            placeableShape.setAnchor(((PlaceableShape)((Object)xSLFShape)).getAnchor());
        }
    }

    public void setParent(XSLFShapeContainer xSLFShapeContainer) {
        this._parent = xSLFShapeContainer;
    }

    public XSLFShapeContainer getParent() {
        return this._parent;
    }

    protected PaintStyle getFillPaint() {
        CTShapeStyle cTShapeStyle;
        PropertyFetcher<PaintStyle> propertyFetcher = new PropertyFetcher<PaintStyle>(){

            @Override
            public boolean fetch(XSLFShape xSLFShape) {
                CTShapeProperties cTShapeProperties = null;
                try {
                    cTShapeProperties = xSLFShape.getSpPr();
                    if (cTShapeProperties.isSetNoFill()) {
                        this.setValue(null);
                        return true;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (cTShapeProperties == null) {
                    cTShapeProperties = xSLFShape.getBgPr();
                }
                if (cTShapeProperties == null) {
                    cTShapeProperties = xSLFShape.getGrpSpPr();
                }
                if (cTShapeProperties == null && xSLFShape.getXmlObject() instanceof CTBackground) {
                    cTShapeProperties = xSLFShape.getXmlObject();
                }
                if (cTShapeProperties == null) {
                    return false;
                }
                PaintStyle paintStyle = null;
                PackagePart packagePart = XSLFShape.this.getSheet().getPackagePart();
                for (XmlObject xmlObject : cTShapeProperties.selectPath("*")) {
                    paintStyle = XSLFShape.this.selectPaint(xmlObject, null, packagePart);
                    if (paintStyle == null) continue;
                    this.setValue(paintStyle);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(propertyFetcher);
        PaintStyle paintStyle = (PaintStyle)propertyFetcher.getValue();
        if (paintStyle != null) {
            return paintStyle;
        }
        CTStyleMatrixReference cTStyleMatrixReference = null;
        if (cTStyleMatrixReference == null && (cTShapeStyle = this.getSpStyle()) != null) {
            cTStyleMatrixReference = cTShapeStyle.getFillRef();
        }
        if (cTStyleMatrixReference == null) {
            cTStyleMatrixReference = this.getBgRef();
        }
        paintStyle = this.selectPaint(cTStyleMatrixReference);
        return paintStyle;
    }

    protected CTBackgroundProperties getBgPr() {
        String string = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' p:bgPr";
        return this.selectProperty(CTBackgroundProperties.class, string);
    }

    protected CTStyleMatrixReference getBgRef() {
        String string = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' p:bgRef";
        return this.selectProperty(CTStyleMatrixReference.class, string);
    }

    protected CTGroupShapeProperties getGrpSpPr() {
        String string = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' p:grpSpPr";
        return this.selectProperty(CTGroupShapeProperties.class, string);
    }

    protected CTNonVisualDrawingProps getCNvPr() {
        if (this._nvPr == null) {
            String string = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:cNvPr";
            this._nvPr = this.selectProperty(CTNonVisualDrawingProps.class, string);
        }
        return this._nvPr;
    }

    protected CTShapeProperties getSpPr() {
        if (this._spPr == null) {
            String string = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' p:spPr";
            this._spPr = this.selectProperty(CTShapeProperties.class, string);
        }
        if (this._spPr == null) {
            throw new IllegalStateException("CTShapeProperties was not found.");
        }
        return this._spPr;
    }

    protected CTShapeStyle getSpStyle() {
        if (this._spStyle == null) {
            String string = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' p:style";
            this._spStyle = this.selectProperty(CTShapeStyle.class, string);
        }
        return this._spStyle;
    }

    protected CTPlaceholder getCTPlaceholder() {
        if (this._ph == null) {
            String string = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:nvPr/p:ph";
            this._ph = this.selectProperty(CTPlaceholder.class, string);
        }
        return this._ph;
    }

    protected void setPlaceholder(Placeholder placeholder) {
        String string = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:nvPr";
        CTApplicationNonVisualDrawingProps cTApplicationNonVisualDrawingProps = this.selectProperty(CTApplicationNonVisualDrawingProps.class, string);
        if (cTApplicationNonVisualDrawingProps == null) {
            return;
        }
        if (placeholder == null) {
            if (cTApplicationNonVisualDrawingProps.isSetPh()) {
                cTApplicationNonVisualDrawingProps.unsetPh();
            }
            this._ph = null;
        } else {
            cTApplicationNonVisualDrawingProps.addNewPh().setType(STPlaceholderType.Enum.forInt((int)(placeholder.ordinal() + 1)));
        }
    }

    protected <T extends XmlObject> T selectProperty(Class<T> clazz, String string) {
        XmlObject[] xmlObjectArray = this.getXmlObject().selectPath(string);
        if (xmlObjectArray.length == 0) {
            return null;
        }
        return (T)(clazz.isInstance(xmlObjectArray[0]) ? xmlObjectArray[0] : null);
    }

    protected boolean fetchShapeProperty(PropertyFetcher<?> propertyFetcher) {
        boolean bl = propertyFetcher.fetch(this);
        XSLFSheet xSLFSheet = (XSLFSheet)((Object)this.getSheet().getMasterSheet());
        CTPlaceholder cTPlaceholder = this.getCTPlaceholder();
        if (xSLFSheet != null && cTPlaceholder != null) {
            XSLFSimpleShape xSLFSimpleShape;
            if (!bl && (xSLFSimpleShape = xSLFSheet.getPlaceholder(cTPlaceholder)) != null) {
                bl = propertyFetcher.fetch(xSLFSimpleShape);
            }
            if (!bl) {
                int n;
                if (!cTPlaceholder.isSetType()) {
                    n = 2;
                } else {
                    switch (cTPlaceholder.getType().intValue()) {
                        case 1: 
                        case 3: {
                            n = 1;
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            n = cTPlaceholder.getType().intValue();
                            break;
                        }
                        default: {
                            n = 2;
                        }
                    }
                }
                XSLFSheet xSLFSheet2 = (XSLFSheet)((Object)xSLFSheet.getMasterSheet());
                if (xSLFSheet2 != null && (xSLFSimpleShape = xSLFSheet2.getPlaceholderByType(n)) != null) {
                    bl = propertyFetcher.fetch(xSLFSimpleShape);
                }
            }
        }
        return bl;
    }

    protected PaintStyle getPaint(XmlObject xmlObject, CTSchemeColor cTSchemeColor) {
        XmlObject xmlObject2;
        PaintStyle paintStyle = null;
        PackagePart packagePart = this.getSheet().getPackagePart();
        XmlObject[] xmlObjectArray = xmlObject.selectPath("*");
        int n = xmlObjectArray.length;
        for (int i = 0; i < n && (paintStyle = this.selectPaint(xmlObject2 = xmlObjectArray[i], cTSchemeColor, packagePart)) == null; ++i) {
        }
        return paintStyle;
    }

    protected PaintStyle selectPaint(XmlObject xmlObject, CTSchemeColor cTSchemeColor, PackagePart packagePart) {
        if (xmlObject instanceof CTNoFillProperties) {
            return null;
        }
        if (xmlObject instanceof CTSolidColorFillProperties) {
            return this.selectPaint((CTSolidColorFillProperties)xmlObject, cTSchemeColor);
        }
        if (xmlObject instanceof CTBlipFillProperties) {
            return this.selectPaint((CTBlipFillProperties)xmlObject, packagePart);
        }
        if (xmlObject instanceof CTGradientFillProperties) {
            return this.selectPaint((CTGradientFillProperties)xmlObject, cTSchemeColor);
        }
        if (xmlObject instanceof CTStyleMatrixReference) {
            return this.selectPaint((CTStyleMatrixReference)xmlObject);
        }
        return null;
    }

    protected PaintStyle selectPaint(CTSolidColorFillProperties cTSolidColorFillProperties, CTSchemeColor cTSchemeColor) {
        XSLFTheme xSLFTheme = this.getSheet().getTheme();
        if (cTSchemeColor == null && cTSolidColorFillProperties.isSetSchemeClr()) {
            cTSchemeColor = cTSolidColorFillProperties.getSchemeClr();
        }
        XSLFColor xSLFColor = new XSLFColor((XmlObject)cTSolidColorFillProperties, xSLFTheme, cTSchemeColor);
        return DrawPaint.createSolidPaint(xSLFColor.getColorStyle());
    }

    protected PaintStyle selectPaint(CTBlipFillProperties cTBlipFillProperties, final PackagePart packagePart) {
        final CTBlip cTBlip = cTBlipFillProperties.getBlip();
        return new PaintStyle.TexturePaint(){

            private PackagePart getPart() {
                try {
                    String string = cTBlip.getEmbed();
                    PackageRelationship packageRelationship = packagePart.getRelationship(string);
                    return packagePart.getRelatedPart(packageRelationship);
                }
                catch (InvalidFormatException invalidFormatException) {
                    throw new RuntimeException(invalidFormatException);
                }
            }

            public InputStream getImageData() {
                try {
                    return this.getPart().getInputStream();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }

            public String getContentType() {
                return this.getPart().getContentType();
            }

            public int getAlpha() {
                return cTBlip.sizeOfAlphaModFixArray() > 0 ? cTBlip.getAlphaModFixArray(0).getAmt() : 100000;
            }
        };
    }

    protected PaintStyle selectPaint(final CTGradientFillProperties cTGradientFillProperties, CTSchemeColor cTSchemeColor) {
        CTGradientStop[] cTGradientStopArray = cTGradientFillProperties.getGsLst().getGsArray();
        Arrays.sort(cTGradientStopArray, new Comparator<CTGradientStop>(){

            @Override
            public int compare(CTGradientStop cTGradientStop, CTGradientStop cTGradientStop2) {
                Integer n = cTGradientStop.getPos();
                Integer n2 = cTGradientStop2.getPos();
                return n.compareTo(n2);
            }
        });
        final ColorStyle[] colorStyleArray = new ColorStyle[cTGradientStopArray.length];
        final float[] fArray = new float[cTGradientStopArray.length];
        XSLFTheme xSLFTheme = this.getSheet().getTheme();
        int n = 0;
        for (CTGradientStop cTGradientStop : cTGradientStopArray) {
            CTSchemeColor cTSchemeColor2 = cTSchemeColor;
            if (cTSchemeColor2 == null && cTGradientStop.isSetSchemeClr()) {
                cTSchemeColor2 = cTGradientStop.getSchemeClr();
            }
            colorStyleArray[n] = new XSLFColor((XmlObject)cTGradientStop, xSLFTheme, cTSchemeColor2).getColorStyle();
            fArray[n] = (float)cTGradientStop.getPos() / 100000.0f;
            ++n;
        }
        return new PaintStyle.GradientPaint(){

            public double getGradientAngle() {
                return cTGradientFillProperties.isSetLin() ? (double)cTGradientFillProperties.getLin().getAng() / 60000.0 : 0.0;
            }

            public ColorStyle[] getGradientColors() {
                return colorStyleArray;
            }

            public float[] getGradientFractions() {
                return fArray;
            }

            public boolean isRotatedWithShape() {
                return cTGradientFillProperties.isSetRotWithShape() || !cTGradientFillProperties.getRotWithShape();
            }

            public PaintStyle.GradientPaint.GradientType getGradientType() {
                if (cTGradientFillProperties.isSetLin()) {
                    return PaintStyle.GradientPaint.GradientType.linear;
                }
                if (cTGradientFillProperties.isSetPath()) {
                    STPathShadeType.Enum enum_ = cTGradientFillProperties.getPath().getPath();
                    if (enum_ == STPathShadeType.CIRCLE) {
                        return PaintStyle.GradientPaint.GradientType.circular;
                    }
                    if (enum_ == STPathShadeType.SHAPE) {
                        return PaintStyle.GradientPaint.GradientType.shape;
                    }
                }
                return PaintStyle.GradientPaint.GradientType.linear;
            }
        };
    }

    protected PaintStyle selectPaint(CTStyleMatrixReference cTStyleMatrixReference) {
        if (cTStyleMatrixReference == null) {
            return null;
        }
        int n = (int)cTStyleMatrixReference.getIdx();
        CTSchemeColor cTSchemeColor = cTStyleMatrixReference.getSchemeClr();
        XSLFSheet xSLFSheet = this.getSheet();
        XSLFTheme xSLFTheme = xSLFSheet.getTheme();
        XmlObject xmlObject = null;
        CTStyleMatrix cTStyleMatrix = xSLFTheme.getXmlObject().getThemeElements().getFmtScheme();
        if (n >= 1 && n <= 999) {
            xmlObject = cTStyleMatrix.getFillStyleLst().selectPath("*")[n - 1];
        } else if (n >= 1001) {
            xmlObject = cTStyleMatrix.getBgFillStyleLst().selectPath("*")[n - 1001];
        }
        return xmlObject == null ? null : this.selectPaint(xmlObject, cTSchemeColor, xSLFTheme.getPackagePart());
    }
}

