/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.sl.usermodel.PictureShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFPictureData;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import java.awt.Insets;
import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOfficeArtExtension;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOfficeArtExtensionList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRelativeRect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPictureNonVisual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFPictureShape
extends XSLFSimpleShape
implements PictureShape<XSLFShape, XSLFTextParagraph> {
    private XSLFPictureData _data;

    XSLFPictureShape(CTPicture cTPicture, XSLFSheet xSLFSheet) {
        super((XmlObject)cTPicture, xSLFSheet);
    }

    static CTPicture prototype(int n, String string) {
        CTPicture cTPicture = CTPicture.Factory.newInstance();
        CTPictureNonVisual cTPictureNonVisual = cTPicture.addNewNvPicPr();
        CTNonVisualDrawingProps cTNonVisualDrawingProps = cTPictureNonVisual.addNewCNvPr();
        cTNonVisualDrawingProps.setName("Picture " + n);
        cTNonVisualDrawingProps.setId((long)(n + 1));
        cTPictureNonVisual.addNewCNvPicPr().addNewPicLocks().setNoChangeAspect(true);
        cTPictureNonVisual.addNewNvPr();
        CTBlipFillProperties cTBlipFillProperties = cTPicture.addNewBlipFill();
        CTBlip cTBlip = cTBlipFillProperties.addNewBlip();
        cTBlip.setEmbed(string);
        cTBlipFillProperties.addNewStretch().addNewFillRect();
        CTShapeProperties cTShapeProperties = cTPicture.addNewSpPr();
        CTPresetGeometry2D cTPresetGeometry2D = cTShapeProperties.addNewPrstGeom();
        cTPresetGeometry2D.setPrst(STShapeType.RECT);
        cTPresetGeometry2D.addNewAvLst();
        return cTPicture;
    }

    public boolean isExternalLinkedPicture() {
        return this.getBlipId() == null && this.getBlipLink() != null;
    }

    @Override
    public XSLFPictureData getPictureData() {
        if (this._data == null) {
            String string = this.getBlipId();
            if (string == null) {
                return null;
            }
            PackagePart packagePart = this.getSheet().getPackagePart();
            PackageRelationship packageRelationship = packagePart.getRelationship(string);
            if (packageRelationship != null) {
                try {
                    PackagePart packagePart2 = packagePart.getRelatedPart(packageRelationship);
                    this._data = new XSLFPictureData(packagePart2, packageRelationship);
                }
                catch (Exception exception) {
                    throw new POIXMLException(exception);
                }
            }
        }
        return this._data;
    }

    public URI getPictureLink() {
        if (this.getBlipId() != null) {
            return null;
        }
        String string = this.getBlipLink();
        if (string == null) {
            return null;
        }
        PackagePart packagePart = this.getSheet().getPackagePart();
        PackageRelationship packageRelationship = packagePart.getRelationship(string);
        if (packageRelationship != null) {
            return packageRelationship.getTargetURI();
        }
        return null;
    }

    private CTBlip getBlip() {
        CTPicture cTPicture = (CTPicture)this.getXmlObject();
        return cTPicture.getBlipFill().getBlip();
    }

    private String getBlipLink() {
        String string = this.getBlip().getLink();
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    private String getBlipId() {
        String string = this.getBlip().getEmbed();
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    @Override
    public Insets getClipping() {
        CTPicture cTPicture = (CTPicture)this.getXmlObject();
        CTRelativeRect cTRelativeRect = cTPicture.getBlipFill().getSrcRect();
        return cTRelativeRect == null ? null : new Insets(cTRelativeRect.getT(), cTRelativeRect.getL(), cTRelativeRect.getB(), cTRelativeRect.getR());
    }

    @Override
    void copy(XSLFShape xSLFShape) {
        super.copy(xSLFShape);
        XSLFPictureShape xSLFPictureShape = (XSLFPictureShape)xSLFShape;
        String string = xSLFPictureShape.getBlipId();
        String string2 = this.getSheet().importBlip(string, xSLFPictureShape.getSheet().getPackagePart());
        CTPicture cTPicture = (CTPicture)this.getXmlObject();
        CTBlip cTBlip = cTPicture.getBlipFill().getBlip();
        cTBlip.setEmbed(string2);
        CTApplicationNonVisualDrawingProps cTApplicationNonVisualDrawingProps = cTPicture.getNvPicPr().getNvPr();
        if (cTApplicationNonVisualDrawingProps.isSetCustDataLst()) {
            cTApplicationNonVisualDrawingProps.unsetCustDataLst();
        }
        if (cTBlip.isSetExtLst()) {
            CTOfficeArtExtensionList cTOfficeArtExtensionList = cTBlip.getExtLst();
            for (CTOfficeArtExtension cTOfficeArtExtension : cTOfficeArtExtensionList.getExtArray()) {
                String string3 = "declare namespace a14='http://schemas.microsoft.com/office/drawing/2010/main' $this//a14:imgProps/a14:imgLayer";
                XmlObject[] xmlObjectArray = cTOfficeArtExtension.selectPath(string3);
                if (xmlObjectArray == null || xmlObjectArray.length != 1) continue;
                XmlCursor xmlCursor = xmlObjectArray[0].newCursor();
                String string4 = xmlCursor.getAttributeText(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "embed"));
                String string5 = this.getSheet().importBlip(string4, xSLFPictureShape.getSheet().getPackagePart());
                xmlCursor.setAttributeText(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "embed"), string5);
                xmlCursor.dispose();
            }
        }
    }
}

