/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.xslf.usermodel.XSLFPictureData;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class XSLFImageRenderer {
    public boolean drawImage(Graphics2D graphics2D, XSLFPictureData xSLFPictureData, Rectangle2D rectangle2D) {
        return this.drawImage(graphics2D, xSLFPictureData, rectangle2D, null);
    }

    public boolean drawImage(Graphics2D graphics2D, XSLFPictureData xSLFPictureData, Rectangle2D rectangle2D, Insets insets) {
        BufferedImage bufferedImage;
        boolean bl = true;
        if (insets == null) {
            bl = false;
            insets = new Insets(0, 0, 0, 0);
        }
        try {
            bufferedImage = ImageIO.read(xSLFPictureData.getPackagePart().getInputStream());
        }
        catch (Exception exception) {
            return false;
        }
        if (bufferedImage == null) {
            return false;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        double d = (double)(100000 - insets.left - insets.right) / 100000.0;
        double d2 = (double)(100000 - insets.top - insets.bottom) / 100000.0;
        double d3 = rectangle2D.getWidth() / ((double)n * d);
        double d4 = rectangle2D.getHeight() / ((double)n2 * d2);
        double d5 = rectangle2D.getX() - (double)n * d3 * (double)insets.left / 100000.0;
        double d6 = rectangle2D.getY() - (double)n2 * d4 * (double)insets.top / 100000.0;
        AffineTransform affineTransform = new AffineTransform(d3, 0.0, 0.0, d4, d5, d6);
        Shape shape = graphics2D.getClip();
        if (bl) {
            graphics2D.clip(rectangle2D.getBounds2D());
        }
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        graphics2D.setClip(shape);
        return true;
    }

    public BufferedImage readImage(PackagePart packagePart) throws IOException {
        return ImageIO.read(packagePart.getInputStream());
    }
}

