/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.sl.draw.DrawPictureShape;
import ai2.org.apache.poi.sl.usermodel.GroupShape;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.usermodel.XSLFAutoShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFConnectorShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFDrawing;
import ai2.org.apache.poi.xslf.usermodel.XSLFFreeformShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFPictureData;
import ai2.org.apache.poi.xslf.usermodel.XSLFPictureShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFRelation;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFShapeContainer;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTable;
import ai2.org.apache.poi.xslf.usermodel.XSLFTableRow;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextBox;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTConnector;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShapeNonVisual;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFGroupShape
extends XSLFShape
implements XSLFShapeContainer,
GroupShape<XSLFShape, XSLFTextParagraph> {
    private static POILogger _logger = POILogFactory.getLogger(XSLFGroupShape.class);
    private final List<XSLFShape> _shapes;
    private final CTGroupShapeProperties _grpSpPr;
    private XSLFDrawing _drawing;

    protected XSLFGroupShape(CTGroupShape cTGroupShape, XSLFSheet xSLFSheet) {
        super((XmlObject)cTGroupShape, xSLFSheet);
        this._shapes = xSLFSheet.buildShapes(cTGroupShape);
        this._grpSpPr = cTGroupShape.getGrpSpPr();
    }

    @Override
    protected CTGroupShapeProperties getGrpSpPr() {
        return this._grpSpPr;
    }

    protected CTGroupTransform2D getSafeXfrm() {
        CTGroupTransform2D cTGroupTransform2D = this.getXfrm();
        return cTGroupTransform2D == null ? this.getGrpSpPr().addNewXfrm() : cTGroupTransform2D;
    }

    protected CTGroupTransform2D getXfrm() {
        return this.getGrpSpPr().getXfrm();
    }

    @Override
    public Rectangle getAnchor() {
        CTGroupTransform2D cTGroupTransform2D = this.getXfrm();
        CTPoint2D cTPoint2D = cTGroupTransform2D.getOff();
        int n = (int)Units.toPoints(cTPoint2D.getX());
        int n2 = (int)Units.toPoints(cTPoint2D.getY());
        CTPositiveSize2D cTPositiveSize2D = cTGroupTransform2D.getExt();
        int n3 = (int)Units.toPoints(cTPositiveSize2D.getCx());
        int n4 = (int)Units.toPoints(cTPositiveSize2D.getCy());
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void setAnchor(Rectangle rectangle) {
        CTGroupTransform2D cTGroupTransform2D = this.getSafeXfrm();
        CTPoint2D cTPoint2D = cTGroupTransform2D.isSetOff() ? cTGroupTransform2D.getOff() : cTGroupTransform2D.addNewOff();
        long l = Units.toEMU(rectangle.getX());
        long l2 = Units.toEMU(rectangle.getY());
        cTPoint2D.setX(l);
        cTPoint2D.setY(l2);
        CTPositiveSize2D cTPositiveSize2D = cTGroupTransform2D.isSetExt() ? cTGroupTransform2D.getExt() : cTGroupTransform2D.addNewExt();
        long l3 = Units.toEMU(rectangle.getWidth());
        long l4 = Units.toEMU(rectangle.getHeight());
        cTPositiveSize2D.setCx(l3);
        cTPositiveSize2D.setCy(l4);
    }

    @Override
    public Rectangle getInteriorAnchor() {
        CTGroupTransform2D cTGroupTransform2D = this.getXfrm();
        CTPoint2D cTPoint2D = cTGroupTransform2D.getChOff();
        int n = (int)Units.toPoints(cTPoint2D.getX());
        int n2 = (int)Units.toPoints(cTPoint2D.getY());
        CTPositiveSize2D cTPositiveSize2D = cTGroupTransform2D.getChExt();
        int n3 = (int)Units.toPoints(cTPositiveSize2D.getCx());
        int n4 = (int)Units.toPoints(cTPositiveSize2D.getCy());
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void setInteriorAnchor(Rectangle rectangle) {
        CTGroupTransform2D cTGroupTransform2D = this.getSafeXfrm();
        CTPoint2D cTPoint2D = cTGroupTransform2D.isSetChOff() ? cTGroupTransform2D.getChOff() : cTGroupTransform2D.addNewChOff();
        long l = Units.toEMU(rectangle.getX());
        long l2 = Units.toEMU(rectangle.getY());
        cTPoint2D.setX(l);
        cTPoint2D.setY(l2);
        CTPositiveSize2D cTPositiveSize2D = cTGroupTransform2D.isSetChExt() ? cTGroupTransform2D.getChExt() : cTGroupTransform2D.addNewChExt();
        long l3 = Units.toEMU(rectangle.getWidth());
        long l4 = Units.toEMU(rectangle.getHeight());
        cTPositiveSize2D.setCx(l3);
        cTPositiveSize2D.setCy(l4);
    }

    @Override
    public List<XSLFShape> getShapes() {
        return this._shapes;
    }

    @Override
    public Iterator<XSLFShape> iterator() {
        return this._shapes.iterator();
    }

    @Override
    public boolean removeShape(XSLFShape xSLFShape) {
        XmlObject xmlObject = xSLFShape.getXmlObject();
        CTGroupShape cTGroupShape = (CTGroupShape)this.getXmlObject();
        if (xmlObject instanceof CTShape) {
            cTGroupShape.getSpList().remove(xmlObject);
        } else if (xmlObject instanceof CTGroupShape) {
            cTGroupShape.getGrpSpList().remove(xmlObject);
        } else if (xmlObject instanceof CTConnector) {
            cTGroupShape.getCxnSpList().remove(xmlObject);
        } else {
            throw new IllegalArgumentException("Unsupported shape: " + xSLFShape);
        }
        return this._shapes.remove(xSLFShape);
    }

    static CTGroupShape prototype(int n) {
        CTGroupShape cTGroupShape = CTGroupShape.Factory.newInstance();
        CTGroupShapeNonVisual cTGroupShapeNonVisual = cTGroupShape.addNewNvGrpSpPr();
        CTNonVisualDrawingProps cTNonVisualDrawingProps = cTGroupShapeNonVisual.addNewCNvPr();
        cTNonVisualDrawingProps.setName("Group " + n);
        cTNonVisualDrawingProps.setId((long)(n + 1));
        cTGroupShapeNonVisual.addNewCNvGrpSpPr();
        cTGroupShapeNonVisual.addNewNvPr();
        cTGroupShape.addNewGrpSpPr();
        return cTGroupShape;
    }

    private XSLFDrawing getDrawing() {
        if (this._drawing == null) {
            this._drawing = new XSLFDrawing(this.getSheet(), (CTGroupShape)this.getXmlObject());
        }
        return this._drawing;
    }

    @Override
    public XSLFAutoShape createAutoShape() {
        XSLFAutoShape xSLFAutoShape = this.getDrawing().createAutoShape();
        this._shapes.add(xSLFAutoShape);
        xSLFAutoShape.setParent(this);
        return xSLFAutoShape;
    }

    @Override
    public XSLFFreeformShape createFreeform() {
        XSLFFreeformShape xSLFFreeformShape = this.getDrawing().createFreeform();
        this._shapes.add(xSLFFreeformShape);
        xSLFFreeformShape.setParent(this);
        return xSLFFreeformShape;
    }

    @Override
    public XSLFTextBox createTextBox() {
        XSLFTextBox xSLFTextBox = this.getDrawing().createTextBox();
        this._shapes.add(xSLFTextBox);
        xSLFTextBox.setParent(this);
        return xSLFTextBox;
    }

    @Override
    public XSLFConnectorShape createConnector() {
        XSLFConnectorShape xSLFConnectorShape = this.getDrawing().createConnector();
        this._shapes.add(xSLFConnectorShape);
        xSLFConnectorShape.setParent(this);
        return xSLFConnectorShape;
    }

    @Override
    public XSLFGroupShape createGroup() {
        XSLFGroupShape xSLFGroupShape = this.getDrawing().createGroup();
        this._shapes.add(xSLFGroupShape);
        xSLFGroupShape.setParent(this);
        return xSLFGroupShape;
    }

    @Override
    public XSLFPictureShape createPicture(PictureData pictureData) {
        if (!(pictureData instanceof XSLFPictureData)) {
            throw new IllegalArgumentException("pictureData needs to be of type XSLFPictureData");
        }
        XSLFPictureData xSLFPictureData = (XSLFPictureData)pictureData;
        PackagePart packagePart = xSLFPictureData.getPackagePart();
        PackageRelationship packageRelationship = this.getSheet().getPackagePart().addRelationship(packagePart.getPartName(), TargetMode.INTERNAL, XSLFRelation.IMAGES.getRelation());
        XSLFPictureShape xSLFPictureShape = this.getDrawing().createPicture(packageRelationship.getId());
        new DrawPictureShape(xSLFPictureShape).resize();
        this._shapes.add(xSLFPictureShape);
        xSLFPictureShape.setParent(this);
        return xSLFPictureShape;
    }

    public XSLFTable createTable() {
        XSLFTable xSLFTable = this.getDrawing().createTable();
        this._shapes.add(xSLFTable);
        xSLFTable.setParent(this);
        return xSLFTable;
    }

    public XSLFTable createTable(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("numRows and numCols must be greater than 0");
        }
        XSLFTable xSLFTable = this.getDrawing().createTable();
        this._shapes.add(xSLFTable);
        xSLFTable.setParent(this);
        for (int i = 0; i < n; ++i) {
            XSLFTableRow xSLFTableRow = xSLFTable.addRow();
            for (int j = 0; j < n2; ++j) {
                xSLFTableRow.addCell();
            }
        }
        return xSLFTable;
    }

    @Override
    public void setFlipHorizontal(boolean bl) {
        this.getSafeXfrm().setFlipH(bl);
    }

    @Override
    public void setFlipVertical(boolean bl) {
        this.getSafeXfrm().setFlipV(bl);
    }

    @Override
    public boolean getFlipHorizontal() {
        CTGroupTransform2D cTGroupTransform2D = this.getXfrm();
        return cTGroupTransform2D == null || !cTGroupTransform2D.isSetFlipH() ? false : cTGroupTransform2D.getFlipH();
    }

    @Override
    public boolean getFlipVertical() {
        CTGroupTransform2D cTGroupTransform2D = this.getXfrm();
        return cTGroupTransform2D == null || !cTGroupTransform2D.isSetFlipV() ? false : cTGroupTransform2D.getFlipV();
    }

    @Override
    public void setRotation(double d) {
        this.getSafeXfrm().setRot((int)(d * 60000.0));
    }

    @Override
    public double getRotation() {
        CTGroupTransform2D cTGroupTransform2D = this.getXfrm();
        return cTGroupTransform2D == null || !cTGroupTransform2D.isSetRot() ? 0.0 : (double)cTGroupTransform2D.getRot() / 60000.0;
    }

    @Override
    void copy(XSLFShape xSLFShape) {
        XSLFGroupShape xSLFGroupShape = (XSLFGroupShape)xSLFShape;
        this.clear();
        for (XSLFShape xSLFShape2 : xSLFGroupShape.getShapes()) {
            XSLFShape xSLFShape3 = null;
            if (xSLFShape2 instanceof XSLFTextBox) {
                xSLFShape3 = this.createTextBox();
            } else if (xSLFShape2 instanceof XSLFAutoShape) {
                xSLFShape3 = this.createAutoShape();
            } else if (xSLFShape2 instanceof XSLFConnectorShape) {
                xSLFShape3 = this.createConnector();
            } else if (xSLFShape2 instanceof XSLFFreeformShape) {
                xSLFShape3 = this.createFreeform();
            } else if (xSLFShape2 instanceof XSLFPictureShape) {
                XSLFPictureShape xSLFPictureShape = (XSLFPictureShape)xSLFShape2;
                XSLFPictureData xSLFPictureData = xSLFPictureShape.getPictureData();
                XSLFPictureData xSLFPictureData2 = this.getSheet().getSlideShow().addPicture(xSLFPictureData.getData(), xSLFPictureData.getType());
                xSLFShape3 = this.createPicture(xSLFPictureData2);
            } else if (xSLFShape2 instanceof XSLFGroupShape) {
                xSLFShape3 = this.createGroup();
            } else if (xSLFShape2 instanceof XSLFTable) {
                xSLFShape3 = this.createTable();
            } else {
                _logger.log(5, new Object[]{"copying of class " + xSLFShape2.getClass() + " not supported."});
                continue;
            }
            ((XSLFShape)xSLFShape3).copy(xSLFShape2);
        }
    }

    @Override
    public void clear() {
        ArrayList<XSLFShape> arrayList = new ArrayList<XSLFShape>(this.getShapes());
        for (XSLFShape xSLFShape : arrayList) {
            this.removeShape(xSLFShape);
        }
    }

    @Override
    public void addShape(XSLFShape xSLFShape) {
        throw new UnsupportedOperationException("Adding a shape from a different container is not supported - create it from scratch with XSLFGroupShape.create* methods");
    }
}

