/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.sl.draw.DrawNotImplemented;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTable;
import java.awt.Rectangle;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;

@DrawNotImplemented
public class XSLFGraphicFrame
extends XSLFShape {
    XSLFGraphicFrame(CTGraphicalObjectFrame cTGraphicalObjectFrame, XSLFSheet xSLFSheet) {
        super((XmlObject)cTGraphicalObjectFrame, xSLFSheet);
    }

    public ShapeType getShapeType() {
        throw new UnsupportedOperationException();
    }

    public Rectangle getAnchor() {
        CTTransform2D cTTransform2D = ((CTGraphicalObjectFrame)this.getXmlObject()).getXfrm();
        CTPoint2D cTPoint2D = cTTransform2D.getOff();
        int n = (int)Units.toPoints(cTPoint2D.getX());
        int n2 = (int)Units.toPoints(cTPoint2D.getY());
        CTPositiveSize2D cTPositiveSize2D = cTTransform2D.getExt();
        int n3 = (int)Units.toPoints(cTPositiveSize2D.getCx());
        int n4 = (int)Units.toPoints(cTPositiveSize2D.getCy());
        return new Rectangle(n, n2, n3, n4);
    }

    public void setAnchor(Rectangle rectangle) {
        CTTransform2D cTTransform2D = ((CTGraphicalObjectFrame)this.getXmlObject()).getXfrm();
        CTPoint2D cTPoint2D = cTTransform2D.isSetOff() ? cTTransform2D.getOff() : cTTransform2D.addNewOff();
        long l = Units.toEMU(rectangle.getX());
        long l2 = Units.toEMU(rectangle.getY());
        cTPoint2D.setX(l);
        cTPoint2D.setY(l2);
        CTPositiveSize2D cTPositiveSize2D = cTTransform2D.isSetExt() ? cTTransform2D.getExt() : cTTransform2D.addNewExt();
        long l3 = Units.toEMU(rectangle.getWidth());
        long l4 = Units.toEMU(rectangle.getHeight());
        cTPositiveSize2D.setCx(l3);
        cTPositiveSize2D.setCy(l4);
    }

    static XSLFGraphicFrame create(CTGraphicalObjectFrame cTGraphicalObjectFrame, XSLFSheet xSLFSheet) {
        String string = cTGraphicalObjectFrame.getGraphic().getGraphicData().getUri();
        if (XSLFTable.TABLE_URI.equals(string)) {
            return new XSLFTable(cTGraphicalObjectFrame, xSLFSheet);
        }
        return new XSLFGraphicFrame(cTGraphicalObjectFrame, xSLFSheet);
    }

    public void setRotation(double d) {
        throw new IllegalArgumentException("Operation not supported");
    }

    public double getRotation() {
        return 0.0;
    }

    public void setFlipHorizontal(boolean bl) {
        throw new IllegalArgumentException("Operation not supported");
    }

    public void setFlipVertical(boolean bl) {
        throw new IllegalArgumentException("Operation not supported");
    }

    public boolean getFlipHorizontal() {
        return false;
    }

    public boolean getFlipVertical() {
        return false;
    }

    void copy(XSLFShape xSLFShape) {
        super.copy(xSLFShape);
        CTGraphicalObjectData cTGraphicalObjectData = ((CTGraphicalObjectFrame)this.getXmlObject()).getGraphic().getGraphicData();
        String string = cTGraphicalObjectData.getUri();
        if (string.equals("http://schemas.openxmlformats.org/drawingml/2006/diagram")) {
            this.copyDiagram(cTGraphicalObjectData, (XSLFGraphicFrame)xSLFShape);
        }
    }

    private void copyDiagram(CTGraphicalObjectData cTGraphicalObjectData, XSLFGraphicFrame xSLFGraphicFrame) {
        String string = "declare namespace dgm='http://schemas.openxmlformats.org/drawingml/2006/diagram' $this//dgm:relIds";
        XmlObject[] xmlObjectArray = cTGraphicalObjectData.selectPath(string);
        if (xmlObjectArray != null && xmlObjectArray.length == 1) {
            XmlCursor xmlCursor = xmlObjectArray[0].newCursor();
            XSLFSheet xSLFSheet = xSLFGraphicFrame.getSheet();
            try {
                String string2 = xmlCursor.getAttributeText(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "dm"));
                PackageRelationship packageRelationship = xSLFSheet.getPackagePart().getRelationship(string2);
                PackagePart packagePart = xSLFSheet.getPackagePart().getRelatedPart(packageRelationship);
                this.getSheet().importPart(packageRelationship, packagePart);
                String string3 = xmlCursor.getAttributeText(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "lo"));
                PackageRelationship packageRelationship2 = xSLFSheet.getPackagePart().getRelationship(string3);
                PackagePart packagePart2 = xSLFSheet.getPackagePart().getRelatedPart(packageRelationship2);
                this.getSheet().importPart(packageRelationship2, packagePart2);
                String string4 = xmlCursor.getAttributeText(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "qs"));
                PackageRelationship packageRelationship3 = xSLFSheet.getPackagePart().getRelationship(string4);
                PackagePart packagePart3 = xSLFSheet.getPackagePart().getRelatedPart(packageRelationship3);
                this.getSheet().importPart(packageRelationship3, packagePart3);
                String string5 = xmlCursor.getAttributeText(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "cs"));
                PackageRelationship packageRelationship4 = xSLFSheet.getPackagePart().getRelationship(string5);
                PackagePart packagePart4 = xSLFSheet.getPackagePart().getRelatedPart(packageRelationship4);
                this.getSheet().importPart(packageRelationship4, packagePart4);
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new POIXMLException(invalidFormatException);
            }
            xmlCursor.dispose();
        }
    }
}

