/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.sl.usermodel.FreeformShape;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.usermodel.XSLFAutoShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.RectangularShape;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTAdjPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTCustomGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomRect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DClose;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DCubicBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DLineTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DMoveTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DQuadBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShapeNonVisual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFFreeformShape
extends XSLFAutoShape
implements FreeformShape<XSLFShape, XSLFTextParagraph> {
    XSLFFreeformShape(CTShape cTShape, XSLFSheet xSLFSheet) {
        super(cTShape, xSLFSheet);
    }

    @Override
    public int setPath(GeneralPath generalPath) {
        CTPath2D cTPath2D = CTPath2D.Factory.newInstance();
        Rectangle rectangle = generalPath.getBounds();
        int n = Units.toEMU(rectangle.getX());
        int n2 = Units.toEMU(rectangle.getY());
        PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
        int n3 = 0;
        cTPath2D.setH((long)Units.toEMU(rectangle.getHeight()));
        cTPath2D.setW((long)Units.toEMU(rectangle.getWidth()));
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n4 = pathIterator.currentSegment(dArray);
            switch (n4) {
                case 0: {
                    CTAdjPoint2D cTAdjPoint2D = cTPath2D.addNewMoveTo().addNewPt();
                    cTAdjPoint2D.setX((Object)(Units.toEMU(dArray[0]) - n));
                    cTAdjPoint2D.setY((Object)(Units.toEMU(dArray[1]) - n2));
                    ++n3;
                    break;
                }
                case 1: {
                    CTAdjPoint2D cTAdjPoint2D = cTPath2D.addNewLnTo().addNewPt();
                    cTAdjPoint2D.setX((Object)(Units.toEMU(dArray[0]) - n));
                    cTAdjPoint2D.setY((Object)(Units.toEMU(dArray[1]) - n2));
                    ++n3;
                    break;
                }
                case 2: {
                    CTPath2DQuadBezierTo cTPath2DQuadBezierTo = cTPath2D.addNewQuadBezTo();
                    CTAdjPoint2D cTAdjPoint2D = cTPath2DQuadBezierTo.addNewPt();
                    cTAdjPoint2D.setX((Object)(Units.toEMU(dArray[0]) - n));
                    cTAdjPoint2D.setY((Object)(Units.toEMU(dArray[1]) - n2));
                    CTAdjPoint2D cTAdjPoint2D2 = cTPath2DQuadBezierTo.addNewPt();
                    cTAdjPoint2D2.setX((Object)(Units.toEMU(dArray[2]) - n));
                    cTAdjPoint2D2.setY((Object)(Units.toEMU(dArray[3]) - n2));
                    n3 += 2;
                    break;
                }
                case 3: {
                    CTPath2DCubicBezierTo cTPath2DCubicBezierTo = cTPath2D.addNewCubicBezTo();
                    CTAdjPoint2D cTAdjPoint2D = cTPath2DCubicBezierTo.addNewPt();
                    cTAdjPoint2D.setX((Object)(Units.toEMU(dArray[0]) - n));
                    cTAdjPoint2D.setY((Object)(Units.toEMU(dArray[1]) - n2));
                    CTAdjPoint2D cTAdjPoint2D3 = cTPath2DCubicBezierTo.addNewPt();
                    cTAdjPoint2D3.setX((Object)(Units.toEMU(dArray[2]) - n));
                    cTAdjPoint2D3.setY((Object)(Units.toEMU(dArray[3]) - n2));
                    CTAdjPoint2D cTAdjPoint2D4 = cTPath2DCubicBezierTo.addNewPt();
                    cTAdjPoint2D4.setX((Object)(Units.toEMU(dArray[4]) - n));
                    cTAdjPoint2D4.setY((Object)(Units.toEMU(dArray[5]) - n2));
                    n3 += 3;
                    break;
                }
                case 4: {
                    ++n3;
                    cTPath2D.addNewClose();
                }
            }
            pathIterator.next();
        }
        this.getSpPr().getCustGeom().getPathLst().setPathArray(new CTPath2D[]{cTPath2D});
        this.setAnchor(rectangle);
        return n3;
    }

    @Override
    public GeneralPath getPath() {
        GeneralPath generalPath = new GeneralPath();
        Rectangle rectangle = this.getAnchor();
        CTCustomGeometry2D cTCustomGeometry2D = this.getSpPr().getCustGeom();
        for (CTPath2D cTPath2D : cTCustomGeometry2D.getPathLst().getPathArray()) {
            double d = ((RectangularShape)rectangle).getWidth() / Units.toPoints(cTPath2D.getW());
            double d2 = ((RectangularShape)rectangle).getHeight() / Units.toPoints(cTPath2D.getH());
            for (XmlObject xmlObject : cTPath2D.selectPath("*")) {
                CTAdjPoint2D cTAdjPoint2D;
                CTAdjPoint2D cTAdjPoint2D2;
                CTAdjPoint2D cTAdjPoint2D3;
                if (xmlObject instanceof CTPath2DMoveTo) {
                    cTAdjPoint2D3 = ((CTPath2DMoveTo)xmlObject).getPt();
                    generalPath.moveTo((float)(Units.toPoints((Long)cTAdjPoint2D3.getX()) * d), (float)(Units.toPoints((Long)cTAdjPoint2D3.getY()) * d2));
                    continue;
                }
                if (xmlObject instanceof CTPath2DLineTo) {
                    cTAdjPoint2D3 = ((CTPath2DLineTo)xmlObject).getPt();
                    generalPath.lineTo((float)Units.toPoints((Long)cTAdjPoint2D3.getX()), (float)Units.toPoints((Long)cTAdjPoint2D3.getY()));
                    continue;
                }
                if (xmlObject instanceof CTPath2DQuadBezierTo) {
                    cTAdjPoint2D3 = (CTPath2DQuadBezierTo)xmlObject;
                    cTAdjPoint2D2 = cTAdjPoint2D3.getPtArray(0);
                    cTAdjPoint2D = cTAdjPoint2D3.getPtArray(1);
                    generalPath.quadTo((float)(Units.toPoints((Long)cTAdjPoint2D2.getX()) * d), (float)(Units.toPoints((Long)cTAdjPoint2D2.getY()) * d2), (float)(Units.toPoints((Long)cTAdjPoint2D.getX()) * d), (float)(Units.toPoints((Long)cTAdjPoint2D.getY()) * d2));
                    continue;
                }
                if (xmlObject instanceof CTPath2DCubicBezierTo) {
                    cTAdjPoint2D3 = (CTPath2DCubicBezierTo)xmlObject;
                    cTAdjPoint2D2 = cTAdjPoint2D3.getPtArray(0);
                    cTAdjPoint2D = cTAdjPoint2D3.getPtArray(1);
                    CTAdjPoint2D cTAdjPoint2D4 = cTAdjPoint2D3.getPtArray(2);
                    generalPath.curveTo((float)(Units.toPoints((Long)cTAdjPoint2D2.getX()) * d), (float)(Units.toPoints((Long)cTAdjPoint2D2.getY()) * d2), (float)(Units.toPoints((Long)cTAdjPoint2D.getX()) * d), (float)(Units.toPoints((Long)cTAdjPoint2D.getY()) * d2), (float)(Units.toPoints((Long)cTAdjPoint2D4.getX()) * d), (float)(Units.toPoints((Long)cTAdjPoint2D4.getY()) * d2));
                    continue;
                }
                if (!(xmlObject instanceof CTPath2DClose)) continue;
                generalPath.closePath();
            }
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(((RectangularShape)rectangle).getX(), ((RectangularShape)rectangle).getY());
        return new GeneralPath(affineTransform.createTransformedShape(generalPath));
    }

    static CTShape prototype(int n) {
        CTShape cTShape = CTShape.Factory.newInstance();
        CTShapeNonVisual cTShapeNonVisual = cTShape.addNewNvSpPr();
        CTNonVisualDrawingProps cTNonVisualDrawingProps = cTShapeNonVisual.addNewCNvPr();
        cTNonVisualDrawingProps.setName("Freeform " + n);
        cTNonVisualDrawingProps.setId((long)(n + 1));
        cTShapeNonVisual.addNewCNvSpPr();
        cTShapeNonVisual.addNewNvPr();
        CTShapeProperties cTShapeProperties = cTShape.addNewSpPr();
        CTCustomGeometry2D cTCustomGeometry2D = cTShapeProperties.addNewCustGeom();
        cTCustomGeometry2D.addNewAvLst();
        cTCustomGeometry2D.addNewGdLst();
        cTCustomGeometry2D.addNewAhLst();
        cTCustomGeometry2D.addNewCxnLst();
        CTGeomRect cTGeomRect = cTCustomGeometry2D.addNewRect();
        cTGeomRect.setR((Object)"r");
        cTGeomRect.setB((Object)"b");
        cTGeomRect.setT((Object)"t");
        cTGeomRect.setL((Object)"l");
        cTCustomGeometry2D.addNewPathLst();
        return cTShape;
    }
}

