/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.xslf.usermodel.DrawingParagraph;
import ai2.org.apache.poi.xslf.usermodel.DrawingTable;
import ai2.org.apache.poi.xslf.usermodel.DrawingTableCell;
import ai2.org.apache.poi.xslf.usermodel.DrawingTableRow;
import ai2.org.apache.poi.xslf.usermodel.DrawingTextBody;
import ai2.org.apache.poi.xslf.usermodel.DrawingTextPlaceholder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTable;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFCommonSlideData {
    private final CTCommonSlideData data;

    public XSLFCommonSlideData(CTCommonSlideData cTCommonSlideData) {
        this.data = cTCommonSlideData;
    }

    public List<DrawingTextBody> getDrawingText() {
        CTGroupShape cTGroupShape = this.data.getSpTree();
        ArrayList<DrawingTextBody> arrayList = new ArrayList<DrawingTextBody>();
        this.processShape(cTGroupShape, arrayList);
        for (CTGroupShape cTGroupShape2 : cTGroupShape.getGrpSpArray()) {
            this.processShape(cTGroupShape2, arrayList);
        }
        for (CTGroupShape cTGroupShape2 : cTGroupShape.getGraphicFrameArray()) {
            CTGraphicalObjectData cTGraphicalObjectData = cTGroupShape2.getGraphic().getGraphicData();
            XmlCursor xmlCursor = cTGraphicalObjectData.newCursor();
            xmlCursor.selectPath("declare namespace pic='" + CTTable.type.getName().getNamespaceURI() + "' .//pic:tbl");
            while (xmlCursor.toNextSelection()) {
                XmlObject xmlObject = xmlCursor.getObject();
                if (xmlObject instanceof XmlAnyTypeImpl) {
                    try {
                        xmlObject = CTTable.Factory.parse((String)xmlObject.toString());
                    }
                    catch (XmlException xmlException) {
                        throw new POIXMLException(xmlException);
                    }
                }
                if (!(xmlObject instanceof CTTable)) continue;
                DrawingTable drawingTable = new DrawingTable((CTTable)xmlObject);
                for (DrawingTableRow drawingTableRow : drawingTable.getRows()) {
                    for (DrawingTableCell drawingTableCell : drawingTableRow.getCells()) {
                        DrawingTextBody drawingTextBody = drawingTableCell.getTextBody();
                        arrayList.add(drawingTextBody);
                    }
                }
            }
            xmlCursor.dispose();
        }
        return arrayList;
    }

    public List<DrawingParagraph> getText() {
        ArrayList<DrawingParagraph> arrayList = new ArrayList<DrawingParagraph>();
        for (DrawingTextBody drawingTextBody : this.getDrawingText()) {
            arrayList.addAll(Arrays.asList(drawingTextBody.getParagraphs()));
        }
        return arrayList;
    }

    private void processShape(CTGroupShape cTGroupShape, List<DrawingTextBody> list) {
        for (CTShape cTShape : cTGroupShape.getSpArray()) {
            CTTextBody cTTextBody = cTShape.getTxBody();
            if (cTTextBody == null) continue;
            CTApplicationNonVisualDrawingProps cTApplicationNonVisualDrawingProps = cTShape.getNvSpPr().getNvPr();
            DrawingTextBody drawingTextBody = cTApplicationNonVisualDrawingProps.isSetPh() ? new DrawingTextPlaceholder(cTTextBody, cTApplicationNonVisualDrawingProps.getPh()) : new DrawingTextBody(cTTextBody);
            list.add(drawingTextBody);
        }
    }
}

