/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import javax.xml.parsers.DocumentBuilderFactory;

public final class XMLHelper {
    private static POILogger logger = POILogFactory.getLogger(XMLHelper.class);

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(false);
        XMLHelper.trySetSAXFeature(documentBuilderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        XMLHelper.trySetSAXFeature(documentBuilderFactory, "http://xml.org/sax/features/external-general-entities", false);
        XMLHelper.trySetSAXFeature(documentBuilderFactory, "http://xml.org/sax/features/external-parameter-entities", false);
        XMLHelper.trySetSAXFeature(documentBuilderFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        XMLHelper.trySetSAXFeature(documentBuilderFactory, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        return documentBuilderFactory;
    }

    private static void trySetSAXFeature(DocumentBuilderFactory documentBuilderFactory, String string, boolean bl) {
        try {
            documentBuilderFactory.setFeature(string, bl);
        }
        catch (Exception exception) {
            logger.log(5, "SAX Feature unsupported", string, exception);
        }
        catch (AbstractMethodError abstractMethodError) {
            logger.log(5, "Cannot set SAX feature because outdated XML parser in classpath", string, abstractMethodError);
        }
    }
}

