/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

public class Units {
    public static final int EMU_PER_PIXEL = 9525;
    public static final int EMU_PER_POINT = 12700;
    public static final int EMU_PER_CENTIMETER = 360000;
    public static final int MASTER_DPI = 576;
    public static final int PIXEL_DPI = 96;
    public static final int POINT_DPI = 72;

    public static int toEMU(double d) {
        return (int)Math.round(12700.0 * d);
    }

    public static double toPoints(long l) {
        return (double)l / 12700.0;
    }

    public static double fixedPointToDouble(int n) {
        int n2 = n >> 16;
        int n3 = n >> 0 & 0xFFFF;
        double d = (double)n2 + (double)n3 / 65536.0;
        return d;
    }

    public static int doubleToFixedPoint(double d) {
        int n = (int)Math.floor(d);
        int n2 = (int)(d % 1.0 * 65536.0);
        int n3 = n << 16 | n2 & 0xFFFF;
        return n3;
    }

    public static double masterToPoints(int n) {
        double d = n;
        d *= 72.0;
        return d /= 576.0;
    }

    public static int pointsToMaster(double d) {
        d *= 576.0;
        return (int)(d /= 72.0);
    }

    public static int pointsToPixel(double d) {
        d *= 96.0;
        return (int)(d /= 72.0);
    }

    public static double pixelToPoints(int n) {
        double d = n;
        d *= 72.0;
        return d /= 96.0;
    }
}

