/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SAXHelper {
    private static POILogger logger = POILogFactory.getLogger(SAXHelper.class);
    static final EntityResolver IGNORING_ENTITY_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    };
    private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();

    private SAXHelper() {
    }

    public static synchronized XMLReader newXMLReader() throws SAXException, ParserConfigurationException {
        XMLReader xMLReader = saxFactory.newSAXParser().getXMLReader();
        xMLReader.setEntityResolver(IGNORING_ENTITY_RESOLVER);
        SAXHelper.trySetSAXFeature(xMLReader, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXHelper.trySetXercesSecurityManager(xMLReader);
        return xMLReader;
    }

    private static void trySetSAXFeature(XMLReader xMLReader, String string, boolean bl) {
        try {
            xMLReader.setFeature(string, bl);
        }
        catch (Exception exception) {
            logger.log(5, "SAX Feature unsupported", string, exception);
        }
        catch (AbstractMethodError abstractMethodError) {
            logger.log(5, "Cannot set SAX feature because outdated XML parser in classpath", string, abstractMethodError);
        }
    }

    private static void trySetXercesSecurityManager(XMLReader xMLReader) {
        for (String string : new String[]{"com.sun.org.apache.xerces.internal.util.SecurityManager", "org.apache.xerces.util.SecurityManager"}) {
            try {
                Object obj = Class.forName(string).newInstance();
                Method method = obj.getClass().getMethod("setEntityExpansionLimit", Integer.TYPE);
                method.invoke(obj, 4096);
                xMLReader.setProperty("http://apache.org/xml/properties/security-manager", obj);
                return;
            }
            catch (Exception exception) {
                logger.log(5, (Object)"SAX Security Manager could not be setup", exception);
            }
        }
    }

    static {
        saxFactory.setValidating(false);
        saxFactory.setNamespaceAware(true);
    }
}

