/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageProperties;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

public final class PackageHelper {
    public static OPCPackage open(InputStream inputStream) throws IOException {
        try {
            return OPCPackage.open(inputStream);
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new POIXMLException(invalidFormatException);
        }
    }

    public static OPCPackage clone(OPCPackage oPCPackage, File file) throws OpenXML4JException, IOException {
        String string = file.getAbsolutePath();
        OPCPackage oPCPackage2 = OPCPackage.create(string);
        PackageRelationshipCollection packageRelationshipCollection = oPCPackage.getRelationships();
        for (PackageRelationship packageRelationship : packageRelationshipCollection) {
            PackagePart packagePart = oPCPackage.getPart(packageRelationship);
            if (packageRelationship.getRelationshipType().equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
                PackageHelper.copyProperties(oPCPackage.getPackageProperties(), oPCPackage2.getPackageProperties());
                continue;
            }
            oPCPackage2.addRelationship(packagePart.getPartName(), packageRelationship.getTargetMode(), packageRelationship.getRelationshipType());
            PackagePart packagePart2 = oPCPackage2.createPart(packagePart.getPartName(), packagePart.getContentType());
            OutputStream outputStream = packagePart2.getOutputStream();
            IOUtils.copy(packagePart.getInputStream(), outputStream);
            outputStream.close();
            if (!packagePart.hasRelationships()) continue;
            PackageHelper.copy(oPCPackage, packagePart, oPCPackage2, packagePart2);
        }
        oPCPackage2.close();
        new File(string).deleteOnExit();
        return OPCPackage.open(string);
    }

    private static void copy(OPCPackage oPCPackage, PackagePart packagePart, OPCPackage oPCPackage2, PackagePart packagePart2) throws OpenXML4JException, IOException {
        PackageRelationshipCollection packageRelationshipCollection = packagePart.getRelationships();
        if (packageRelationshipCollection != null) {
            for (PackageRelationship packageRelationship : packageRelationshipCollection) {
                if (packageRelationship.getTargetMode() == TargetMode.EXTERNAL) {
                    packagePart2.addExternalRelationship(packageRelationship.getTargetURI().toString(), packageRelationship.getRelationshipType(), packageRelationship.getId());
                    continue;
                }
                URI uRI = packageRelationship.getTargetURI();
                if (uRI.getRawFragment() != null) {
                    packagePart2.addRelationship(uRI, packageRelationship.getTargetMode(), packageRelationship.getRelationshipType(), packageRelationship.getId());
                    continue;
                }
                PackagePartName packagePartName = PackagingURIHelper.createPartName(packageRelationship.getTargetURI());
                PackagePart packagePart3 = oPCPackage.getPart(packagePartName);
                packagePart2.addRelationship(packagePart3.getPartName(), packageRelationship.getTargetMode(), packageRelationship.getRelationshipType(), packageRelationship.getId());
                if (oPCPackage2.containPart(packagePart3.getPartName())) continue;
                PackagePart packagePart4 = oPCPackage2.createPart(packagePart3.getPartName(), packagePart3.getContentType());
                OutputStream outputStream = packagePart4.getOutputStream();
                IOUtils.copy(packagePart3.getInputStream(), outputStream);
                outputStream.close();
                PackageHelper.copy(oPCPackage, packagePart3, oPCPackage2, packagePart4);
            }
        }
    }

    private static void copyProperties(PackageProperties packageProperties, PackageProperties packageProperties2) {
        packageProperties2.setCategoryProperty(packageProperties.getCategoryProperty().getValue());
        packageProperties2.setContentStatusProperty(packageProperties.getContentStatusProperty().getValue());
        packageProperties2.setContentTypeProperty(packageProperties.getContentTypeProperty().getValue());
        packageProperties2.setCreatorProperty(packageProperties.getCreatorProperty().getValue());
        packageProperties2.setDescriptionProperty(packageProperties.getDescriptionProperty().getValue());
        packageProperties2.setIdentifierProperty(packageProperties.getIdentifierProperty().getValue());
        packageProperties2.setKeywordsProperty(packageProperties.getKeywordsProperty().getValue());
        packageProperties2.setLanguageProperty(packageProperties.getLanguageProperty().getValue());
        packageProperties2.setRevisionProperty(packageProperties.getRevisionProperty().getValue());
        packageProperties2.setSubjectProperty(packageProperties.getSubjectProperty().getValue());
        packageProperties2.setTitleProperty(packageProperties.getTitleProperty().getValue());
        packageProperties2.setVersionProperty(packageProperties.getVersionProperty().getValue());
    }
}

