/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public abstract class POILogger {
    public static final int DEBUG = 1;
    public static final int INFO = 3;
    public static final int WARN = 5;
    public static final int ERROR = 7;
    public static final int FATAL = 9;
    protected static final String[] LEVEL_STRINGS_SHORT = new String[]{"?", "D", "?", "I", "?", "W", "?", "E", "?", "F", "?"};
    protected static final String[] LEVEL_STRINGS = new String[]{"?0?", "DEBUG", "?2?", "INFO", "?4?", "WARN", "?6?", "ERROR", "?8?", "FATAL", "?10+?"};

    POILogger() {
    }

    public abstract void initialize(String var1);

    protected abstract void log(int var1, Object var2);

    protected abstract void log(int var1, Object var2, Throwable var3);

    public abstract boolean check(int var1);

    public void log(int n, Object ... objectArray) {
        if (!this.check(n)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        Throwable throwable = null;
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == objectArray.length - 1 && objectArray[i] instanceof Throwable) {
                throwable = (Throwable)objectArray[i];
                continue;
            }
            stringBuilder.append(objectArray[i]);
        }
        String string = stringBuilder.toString();
        string = string.replaceAll("[\r\n]+", " ");
        if (throwable == null) {
            this.log(n, (Object)string);
        } else {
            this.log(n, (Object)string, throwable);
        }
    }

    public void logFormatted(int n, String string, Object ... objectArray) {
        if (!this.check(n)) {
            return;
        }
        Object[] objectArray2 = this.flattenArrays(objectArray);
        String string2 = StringUtil.format(string, objectArray2);
        string2 = string2.replaceAll("[\r\n]+", " ");
        if (objectArray2.length > 0 && objectArray2[objectArray2.length - 1] instanceof Throwable) {
            this.log(n, (Object)string2, (Throwable)objectArray2[objectArray2.length - 1]);
        } else {
            this.log(n, (Object)string2);
        }
    }

    private Object[] flattenArrays(Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            this.flattenObject(arrayList, object);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    private void flattenObject(List<Object> list, Object object) {
        if (object instanceof byte[]) {
            for (byte by : (byte[])object) {
                list.add(by);
            }
        } else if (object instanceof char[]) {
            for (char c : (char[])object) {
                list.add(Character.valueOf(c));
            }
        } else if (object instanceof short[]) {
            for (short s : (short[])object) {
                list.add(s);
            }
        } else if (object instanceof int[]) {
            for (int n : (int[])object) {
                list.add(n);
            }
        } else if (object instanceof long[]) {
            for (long l : (long[])object) {
                list.add(l);
            }
        } else if (object instanceof float[]) {
            for (float f : (float[])object) {
                list.add(Float.valueOf(f));
            }
        } else if (object instanceof double[]) {
            for (double d : (double[])object) {
                list.add(d);
            }
        } else if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                list.add(object2);
            }
        } else {
            list.add(object);
        }
    }
}

