/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.NullLogger;
import ai2.org.apache.poi.util.POILogger;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class POILogFactory {
    private static Map<String, POILogger> _loggers = new HashMap<String, POILogger>();
    private static final POILogger _nullLogger = new NullLogger();
    private static String _loggerClassName = null;

    private POILogFactory() {
    }

    public static POILogger getLogger(Class<?> clazz) {
        return POILogFactory.getLogger(clazz.getName());
    }

    public static POILogger getLogger(String string) {
        POILogger pOILogger = null;
        if (_loggerClassName == null) {
            try {
                _loggerClassName = System.getProperty("ai2.org.apache.poi.util.POILogger");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (_loggerClassName == null) {
                _loggerClassName = _nullLogger.getClass().getName();
            }
        }
        if (_loggerClassName.equals(_nullLogger.getClass().getName())) {
            return _nullLogger;
        }
        pOILogger = _loggers.get(string);
        if (pOILogger == null) {
            try {
                Class<?> clazz = Class.forName(_loggerClassName);
                pOILogger = (POILogger)clazz.newInstance();
                pOILogger.initialize(string);
            }
            catch (Exception exception) {
                pOILogger = _nullLogger;
                _loggerClassName = _nullLogger.getClass().getName();
            }
            _loggers.put(string, pOILogger);
        }
        return pOILogger;
    }
}

