/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.SuppressForbidden;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class LocaleUtil {
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final Charset CHARSET_1252 = Charset.forName("CP1252");
    private static final ThreadLocal<TimeZone> userTimeZone = new ThreadLocal<TimeZone>(){

        @Override
        @SuppressForbidden
        protected TimeZone initialValue() {
            return TimeZone.getDefault();
        }
    };
    private static final ThreadLocal<Locale> userLocale = new ThreadLocal<Locale>(){

        @Override
        @SuppressForbidden
        protected Locale initialValue() {
            return Locale.getDefault();
        }
    };

    public static void setUserTimeZone(TimeZone timeZone) {
        userTimeZone.set(timeZone);
    }

    public static TimeZone getUserTimeZone() {
        return userTimeZone.get();
    }

    public static void setUserLocale(Locale locale) {
        userLocale.set(locale);
    }

    public static Locale getUserLocale() {
        return userLocale.get();
    }

    public static Calendar getLocaleCalendar() {
        return LocaleUtil.getLocaleCalendar(LocaleUtil.getUserTimeZone());
    }

    public static Calendar getLocaleCalendar(int n, int n2, int n3) {
        return LocaleUtil.getLocaleCalendar(n, n2, n3, 0, 0, 0);
    }

    public static Calendar getLocaleCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = LocaleUtil.getLocaleCalendar();
        calendar.set(n, n2, n3, n4, n5, n6);
        calendar.clear(14);
        return calendar;
    }

    public static Calendar getLocaleCalendar(TimeZone timeZone) {
        return Calendar.getInstance(timeZone, LocaleUtil.getUserLocale());
    }
}

