/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.LittleEndianOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class LittleEndianOutputStream
extends FilterOutputStream
implements LittleEndianOutput {
    public LittleEndianOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeByte(int n) {
        try {
            this.out.write(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeInt(int n) {
        int n2 = n >>> 24 & 0xFF;
        int n3 = n >>> 16 & 0xFF;
        int n4 = n >>> 8 & 0xFF;
        int n5 = n >>> 0 & 0xFF;
        try {
            this.out.write(n5);
            this.out.write(n4);
            this.out.write(n3);
            this.out.write(n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void writeLong(long l) {
        this.writeInt((int)(l >> 0));
        this.writeInt((int)(l >> 32));
    }

    public void writeShort(int n) {
        int n2 = n >>> 8 & 0xFF;
        int n3 = n >>> 0 & 0xFF;
        try {
            this.out.write(n3);
            this.out.write(n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(byte[] byArray) {
        try {
            super.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            super.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

