/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.EmptyFileException;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.CRC32;

public final class IOUtils {
    private static final POILogger logger = POILogFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static byte[] peekFirst8Bytes(InputStream inputStream) throws IOException, EmptyFileException {
        inputStream.mark(8);
        byte[] byArray = new byte[8];
        int n = IOUtils.readFully(inputStream, byArray);
        if (n < 1) {
            throw new EmptyFileException();
        }
        if (inputStream instanceof PushbackInputStream) {
            PushbackInputStream pushbackInputStream = (PushbackInputStream)inputStream;
            pushbackInputStream.unread(byArray, 0, n);
        } else {
            inputStream.reset();
        }
        return byArray;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = 0;
        while (n != -1) {
            n = inputStream.read(byArray);
            if (n <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
            return byteBuffer.array();
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        return IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = inputStream.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            return n4 == 0 ? -1 : n4;
        } while ((n4 += n3) != n2);
        return n4;
    }

    public static int readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = 0;
        do {
            if ((n = readableByteChannel.read(byteBuffer)) >= 0) continue;
            return n2 == 0 ? -1 : n2;
        } while ((n2 += n) != byteBuffer.capacity() && byteBuffer.position() != byteBuffer.capacity());
        return n2;
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            if (n <= 0) continue;
            outputStream.write(byArray, 0, n);
        }
    }

    public static long calculateChecksum(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        return cRC32.getValue();
    }

    public static long calculateChecksum(InputStream inputStream) throws IOException {
        int n;
        CRC32 cRC32 = new CRC32();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            if (n <= 0) continue;
            cRC32.update(byArray, 0, n);
        }
        return cRC32.getValue();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            logger.log(7, (Object)("Unable to close resource: " + exception), exception);
        }
    }
}

