/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.Internal;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Locale;

@Internal
public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    public static final Charset UTF8 = Charset.forName("UTF-8");

    private HexDump() {
    }

    public static void dump(byte[] byArray, long l, OutputStream outputStream, int n, int n2) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (outputStream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, UTF8);
        outputStreamWriter.write(HexDump.dump(byArray, l, n, n2));
        outputStreamWriter.flush();
    }

    public static synchronized void dump(byte[] byArray, long l, OutputStream outputStream, int n) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        HexDump.dump(byArray, l, outputStream, n, Integer.MAX_VALUE);
    }

    public static String dump(byte[] byArray, long l, int n) {
        return HexDump.dump(byArray, l, n, Integer.MAX_VALUE);
    }

    public static String dump(byte[] byArray, long l, int n, int n2) {
        int n3;
        if (byArray == null || byArray.length == 0) {
            return "No Data" + EOL;
        }
        int n4 = n3 = n2 == Integer.MAX_VALUE || n2 < 0 || n + n2 < 0 ? byArray.length : Math.min(byArray.length, n + n2);
        if (n < 0 || n >= byArray.length) {
            String string = "illegal index: " + n + " into array of length " + byArray.length;
            throw new ArrayIndexOutOfBoundsException(string);
        }
        long l2 = l + (long)n;
        StringBuilder stringBuilder = new StringBuilder(74);
        for (int i = n; i < n3; i += 16) {
            int n5;
            int n6 = n3 - i;
            if (n6 > 16) {
                n6 = 16;
            }
            stringBuilder.append(HexDump.xpad(l2, 8, ""));
            for (n5 = 0; n5 < 16; ++n5) {
                if (n5 < n6) {
                    stringBuilder.append(HexDump.xpad(byArray[n5 + i], 2, " "));
                    continue;
                }
                stringBuilder.append("   ");
            }
            stringBuilder.append(' ');
            for (n5 = 0; n5 < n6; ++n5) {
                stringBuilder.append(HexDump.toAscii(byArray[n5 + i]));
            }
            stringBuilder.append(EOL);
            l2 += (long)n6;
        }
        return stringBuilder.toString();
    }

    public static char toAscii(int n) {
        int n2 = n & 0xFF;
        if (Character.isISOControl((char)n2)) {
            return '.';
        }
        switch (n2) {
            case 221: 
            case 255: {
                n2 = 46;
            }
        }
        return (char)n2;
    }

    public static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (byArray != null && byArray.length > 0) {
            for (int i = 0; i < byArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(HexDump.toHex(byArray[i]));
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String toHex(short[] sArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < sArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(HexDump.toHex(sArray[i]));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String toHex(byte[] byArray, int n) {
        if (byArray.length == 0) {
            return ": 0";
        }
        int n2 = (int)Math.round(Math.log(byArray.length) / Math.log(10.0) + 0.5);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HexDump.xpad(0L, n2, ""));
        stringBuilder.append(": ");
        int n3 = -1;
        for (int i = 0; i < byArray.length; ++i) {
            if (++n3 == n) {
                stringBuilder.append('\n');
                stringBuilder.append(HexDump.xpad(i, n2, ""));
                stringBuilder.append(": ");
                n3 = 0;
            } else if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(HexDump.toHex(byArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String toHex(short s) {
        return HexDump.xpad(s & 0xFFFF, 4, "");
    }

    public static String toHex(byte by) {
        return HexDump.xpad(by & 0xFF, 2, "");
    }

    public static String toHex(int n) {
        return HexDump.xpad(n & 0xFFFFFFFF, 8, "");
    }

    public static String toHex(long l) {
        return HexDump.xpad(l & 0xFFFFFFFFFFFFFFFFL, 16, "");
    }

    public static void dump(InputStream inputStream, PrintStream printStream, int n, int n2) throws IOException {
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n2 == -1) {
            n3 = inputStream.read();
            while (n3 != -1) {
                byteArrayOutputStream.write(n3);
                n3 = inputStream.read();
            }
        } else {
            int n4;
            n3 = n2;
            while (n3-- > 0 && (n4 = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n4);
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        HexDump.dump(byArray, 0L, printStream, n, byArray.length);
    }

    public static String longToHex(long l) {
        return HexDump.xpad(l, 16, "0x");
    }

    public static String intToHex(int n) {
        return HexDump.xpad(n & 0xFFFFFFFF, 8, "0x");
    }

    public static String shortToHex(int n) {
        return HexDump.xpad(n & 0xFFFF, 4, "0x");
    }

    public static String byteToHex(int n) {
        return HexDump.xpad(n & 0xFF, 2, "0x");
    }

    private static String xpad(long l, int n, String string) {
        String string2 = Long.toHexString(l).toUpperCase(Locale.ROOT);
        int n2 = string2.length();
        if ((n == 0 || n2 == n) && "".equals(string)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (n2 < n) {
            stringBuilder.append("0000000000000000", 0, n - n2);
            stringBuilder.append(string2);
        } else if (n2 > n) {
            stringBuilder.append(string2, n2 - n, n2);
        } else {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[(int)file.length()];
        ((InputStream)bufferedInputStream).read(byArray);
        System.out.println(HexDump.dump(byArray, 0L, 0));
        ((InputStream)bufferedInputStream).close();
    }
}

