/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.SAXHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.events.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class DocumentHelper {
    private static POILogger logger = POILogFactory.getLogger(DocumentHelper.class);
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final DocumentBuilder documentBuilderSingleton;

    private DocumentHelper() {
    }

    public static synchronized DocumentBuilder newDocumentBuilder() {
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(SAXHelper.IGNORING_ENTITY_RESOLVER);
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException("cannot create a DocumentBuilder", parserConfigurationException);
        }
    }

    private static void trySetSAXFeature(DocumentBuilderFactory documentBuilderFactory, String string, boolean bl) {
        try {
            documentBuilderFactory.setFeature(string, bl);
        }
        catch (Exception exception) {
            logger.log(5, "SAX Feature unsupported", string, exception);
        }
        catch (AbstractMethodError abstractMethodError) {
            logger.log(5, "Cannot set SAX feature because outdated XML parser in classpath", string, abstractMethodError);
        }
    }

    private static void trySetXercesSecurityManager(DocumentBuilderFactory documentBuilderFactory) {
        for (String string : new String[]{"com.sun.org.apache.xerces.internal.util.SecurityManager", "org.apache.xerces.util.SecurityManager"}) {
            try {
                Object obj = Class.forName(string).newInstance();
                Method method = obj.getClass().getMethod("setEntityExpansionLimit", Integer.TYPE);
                method.invoke(obj, 4096);
                documentBuilderFactory.setAttribute("http://apache.org/xml/properties/security-manager", obj);
                return;
            }
            catch (Throwable throwable) {
                logger.log(5, (Object)"SAX Security Manager could not be setup", throwable);
            }
        }
    }

    public static Document readDocument(InputStream inputStream) throws IOException, SAXException {
        return DocumentHelper.newDocumentBuilder().parse(inputStream);
    }

    public static synchronized Document createDocument() {
        return documentBuilderSingleton.newDocument();
    }

    public static void addNamespaceDeclaration(Element element, String string, String string2) {
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
    }

    public static void addNamespaceDeclaration(Element element, Namespace namespace) {
        DocumentHelper.addNamespaceDeclaration(element, namespace.getPrefix(), namespace.getNamespaceURI());
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        DocumentHelper.trySetSAXFeature(documentBuilderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentHelper.trySetXercesSecurityManager(documentBuilderFactory);
        documentBuilderSingleton = DocumentHelper.newDocumentBuilder();
    }
}

