/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.util;

import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.CellReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Region
implements Comparable<Region> {
    private int _rowFrom;
    private short _colFrom;
    private int _rowTo;
    private short _colTo;

    public Region() {
    }

    public Region(int n, short s, int n2, short s2) {
        this._rowFrom = n;
        this._rowTo = n2;
        this._colFrom = s;
        this._colTo = s2;
    }

    public Region(String string) {
        CellReference cellReference = new CellReference(string.substring(0, string.indexOf(":")));
        CellReference cellReference2 = new CellReference(string.substring(string.indexOf(":") + 1));
        this._rowFrom = cellReference.getRow();
        this._colFrom = cellReference.getCol();
        this._rowTo = cellReference2.getRow();
        this._colTo = cellReference2.getCol();
    }

    public short getColumnFrom() {
        return this._colFrom;
    }

    public int getRowFrom() {
        return this._rowFrom;
    }

    public short getColumnTo() {
        return this._colTo;
    }

    public int getRowTo() {
        return this._rowTo;
    }

    public void setColumnFrom(short s) {
        this._colFrom = s;
    }

    public void setRowFrom(int n) {
        this._rowFrom = n;
    }

    public void setColumnTo(short s) {
        this._colTo = s;
    }

    public void setRowTo(int n) {
        this._rowTo = n;
    }

    public boolean contains(int n, short s) {
        return this._rowFrom <= n && this._rowTo >= n && this._colFrom <= s && this._colTo >= s;
    }

    public boolean equals(Region region) {
        return this.compareTo(region) == 0;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public int compareTo(Region region) {
        if (this.getRowFrom() == region.getRowFrom() && this.getColumnFrom() == region.getColumnFrom() && this.getRowTo() == region.getRowTo() && this.getColumnTo() == region.getColumnTo()) {
            return 0;
        }
        if (this.getRowFrom() < region.getRowFrom() || this.getColumnFrom() < region.getColumnFrom() || this.getRowTo() < region.getRowTo() || this.getColumnTo() < region.getColumnTo()) {
            return 1;
        }
        return -1;
    }

    public int getArea() {
        return (this._rowTo - this._rowFrom + 1) * (this._colTo - this._colFrom + 1);
    }

    public static Region[] convertCellRangesToRegions(CellRangeAddress[] cellRangeAddressArray) {
        int n = cellRangeAddressArray.length;
        if (n < 1) {
            return new Region[0];
        }
        Region[] regionArray = new Region[n];
        for (int i = 0; i != n; ++i) {
            regionArray[i] = Region.convertToRegion(cellRangeAddressArray[i]);
        }
        return regionArray;
    }

    private static Region convertToRegion(CellRangeAddress cellRangeAddress) {
        return new Region(cellRangeAddress.getFirstRow(), (short)cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastRow(), (short)cellRangeAddress.getLastColumn());
    }

    public static CellRangeAddress[] convertRegionsToCellRanges(Region[] regionArray) {
        int n = regionArray.length;
        if (n < 1) {
            return new CellRangeAddress[0];
        }
        CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[n];
        for (int i = 0; i != n; ++i) {
            cellRangeAddressArray[i] = Region.convertToCellRangeAddress(regionArray[i]);
        }
        return cellRangeAddressArray;
    }

    public static CellRangeAddress convertToCellRangeAddress(Region region) {
        return new CellRangeAddress(region.getRowFrom(), region.getRowTo(), region.getColumnFrom(), region.getColumnTo());
    }

    public String getRegionRef() {
        CellReference cellReference = new CellReference(this._rowFrom, this._colFrom);
        CellReference cellReference2 = new CellReference(this._rowTo, this._colTo);
        String string = cellReference.formatAsString() + ":" + cellReference2.formatAsString();
        return string;
    }
}

