/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.util;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai2.org.apache.poi.util.LittleEndianOutput;
import java.util.ArrayList;
import java.util.List;

public class CellRangeAddressList {
    protected final List<CellRangeAddress> _list = new ArrayList<CellRangeAddress>();

    public CellRangeAddressList() {
    }

    public CellRangeAddressList(int n, int n2, int n3, int n4) {
        this();
        this.addCellRangeAddress(n, n3, n2, n4);
    }

    public CellRangeAddressList(RecordInputStream recordInputStream) {
        this();
        int n = recordInputStream.readUShort();
        for (int i = 0; i < n; ++i) {
            this._list.add(new CellRangeAddress(recordInputStream));
        }
    }

    public int countRanges() {
        return this._list.size();
    }

    public void addCellRangeAddress(int n, int n2, int n3, int n4) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(n, n3, n2, n4);
        this.addCellRangeAddress(cellRangeAddress);
    }

    public void addCellRangeAddress(CellRangeAddress cellRangeAddress) {
        this._list.add(cellRangeAddress);
    }

    public CellRangeAddress remove(int n) {
        if (this._list.isEmpty()) {
            throw new RuntimeException("List is empty");
        }
        if (n < 0 || n >= this._list.size()) {
            throw new RuntimeException("Range index (" + n + ") is outside allowable range (0.." + (this._list.size() - 1) + ")");
        }
        return this._list.remove(n);
    }

    public CellRangeAddress getCellRangeAddress(int n) {
        return this._list.get(n);
    }

    public int getSize() {
        return CellRangeAddressList.getEncodedSize(this._list.size());
    }

    public static int getEncodedSize(int n) {
        return 2 + CellRangeAddress.getEncodedSize(n);
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = this.getSize();
        this.serialize(new LittleEndianByteArrayOutputStream(byArray, n, n2));
        return n2;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = this._list.size();
        littleEndianOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            CellRangeAddress cellRangeAddress = this._list.get(i);
            cellRangeAddress.serialize(littleEndianOutput);
        }
    }

    public CellRangeAddressList copy() {
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList();
        int n = this._list.size();
        for (int i = 0; i < n; ++i) {
            CellRangeAddress cellRangeAddress = this._list.get(i);
            cellRangeAddressList.addCellRangeAddress(cellRangeAddress.copy());
        }
        return cellRangeAddressList;
    }

    public CellRangeAddress[] getCellRangeAddresses() {
        CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[this._list.size()];
        this._list.toArray(cellRangeAddressArray);
        return cellRangeAddressArray;
    }
}

