/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.util;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.ss.formula.SheetNameFormatter;
import ai2.org.apache.poi.ss.util.CellRangeAddressBase;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai2.org.apache.poi.util.LittleEndianOutput;

public class CellRangeAddress
extends CellRangeAddressBase {
    public static final int ENCODED_SIZE = 8;

    public CellRangeAddress(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        if (n2 < n || n4 < n3) {
            throw new IllegalArgumentException("lastRow < firstRow || lastCol < firstCol");
        }
    }

    @Deprecated
    public int serialize(int n, byte[] byArray) {
        this.serialize(new LittleEndianByteArrayOutputStream(byArray, n, 8));
        return 8;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getFirstRow());
        littleEndianOutput.writeShort(this.getLastRow());
        littleEndianOutput.writeShort(this.getFirstColumn());
        littleEndianOutput.writeShort(this.getLastColumn());
    }

    public CellRangeAddress(RecordInputStream recordInputStream) {
        super(CellRangeAddress.readUShortAndCheck(recordInputStream), recordInputStream.readUShort(), recordInputStream.readUShort(), recordInputStream.readUShort());
    }

    private static int readUShortAndCheck(RecordInputStream recordInputStream) {
        if (recordInputStream.remaining() < 8) {
            throw new RuntimeException("Ran out of data reading CellRangeAddress");
        }
        return recordInputStream.readUShort();
    }

    public CellRangeAddress copy() {
        return new CellRangeAddress(this.getFirstRow(), this.getLastRow(), this.getFirstColumn(), this.getLastColumn());
    }

    public static int getEncodedSize(int n) {
        return n * 8;
    }

    public String formatAsString() {
        return this.formatAsString(null, false);
    }

    public String formatAsString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(SheetNameFormatter.format(string));
            stringBuffer.append("!");
        }
        CellReference cellReference = new CellReference(this.getFirstRow(), this.getFirstColumn(), bl, bl);
        CellReference cellReference2 = new CellReference(this.getLastRow(), this.getLastColumn(), bl, bl);
        stringBuffer.append(cellReference.formatAsString());
        if (!cellReference.equals(cellReference2) || this.isFullColumnRange() || this.isFullRowRange()) {
            stringBuffer.append(':');
            stringBuffer.append(cellReference2.formatAsString());
        }
        return stringBuffer.toString();
    }

    public static CellRangeAddress valueOf(String string) {
        CellReference cellReference;
        CellReference cellReference2;
        int n = string.indexOf(":");
        if (n == -1) {
            cellReference = cellReference2 = new CellReference(string);
        } else {
            cellReference2 = new CellReference(string.substring(0, n));
            cellReference = new CellReference(string.substring(n + 1));
        }
        return new CellRangeAddress(cellReference2.getRow(), cellReference.getRow(), cellReference2.getCol(), cellReference.getCol());
    }
}

