/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.usermodel;

import ai2.org.apache.poi.ss.format.SimpleFraction;
import ai2.org.apache.poi.ss.formula.eval.NotImplementedException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FractionFormat
extends Format {
    private static final Pattern DENOM_FORMAT_PATTERN = Pattern.compile("(?:(#+)|(\\d+))");
    private static final int MAX_DENOM_POW = 4;
    private final int exactDenom;
    private final int maxDenom;
    private final String wholePartFormatString;

    public FractionFormat(String string, String string2) {
        this.wholePartFormatString = string;
        Matcher matcher = DENOM_FORMAT_PATTERN.matcher(string2);
        int n = -1;
        int n2 = -1;
        if (matcher.find()) {
            if (matcher.group(2) != null) {
                try {
                    n = Integer.parseInt(matcher.group(2));
                    if (n == 0) {
                        n = -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (matcher.group(1) != null) {
                int n3 = matcher.group(1).length();
                n3 = n3 > 4 ? 4 : n3;
                n2 = (int)Math.pow(10.0, n3);
            } else {
                n = 100;
            }
        }
        if (n <= 0 && n2 <= 0) {
            n = 100;
        }
        this.exactDenom = n;
        this.maxDenom = n2;
    }

    public String format(Number number) {
        double d;
        double d2 = number.doubleValue();
        boolean bl = d2 < 0.0;
        double d3 = Math.abs(d2);
        double d4 = Math.floor(d3);
        if (d4 + (d = d3 - d4) == 0.0) {
            return "0";
        }
        if (d3 < (double)(1 / Math.max(this.exactDenom, this.maxDenom))) {
            return "0";
        }
        if (d4 + (double)((int)d) == d4 + d) {
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                stringBuilder.append("-");
            }
            stringBuilder.append(Integer.toString((int)d4));
            return stringBuilder.toString();
        }
        SimpleFraction simpleFraction = null;
        try {
            simpleFraction = this.exactDenom > 0 ? SimpleFraction.buildFractionExactDenominator(d, this.exactDenom) : SimpleFraction.buildFractionMaxDenominator(d, this.maxDenom);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return Double.toString(d2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("-");
        }
        if ("".equals(this.wholePartFormatString)) {
            int n = simpleFraction.getDenominator() * (int)d4 + simpleFraction.getNumerator();
            stringBuilder.append(n).append("/").append(simpleFraction.getDenominator());
            return stringBuilder.toString();
        }
        if (simpleFraction.getNumerator() == 0) {
            stringBuilder.append(Integer.toString((int)d4));
            return stringBuilder.toString();
        }
        if (simpleFraction.getNumerator() == simpleFraction.getDenominator()) {
            stringBuilder.append(Integer.toString((int)d4 + 1));
            return stringBuilder.toString();
        }
        if (d4 > 0.0) {
            stringBuilder.append(Integer.toString((int)d4)).append(" ");
        }
        stringBuilder.append(simpleFraction.getNumerator()).append("/").append(simpleFraction.getDenominator());
        return stringBuilder.toString();
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return stringBuffer.append(this.format((Number)object));
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new NotImplementedException("Reverse parsing not supported");
    }
}

