/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.usermodel;

import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import ai2.org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import ai2.org.apache.poi.ss.usermodel.FormulaError;
import ai2.org.apache.poi.ss.usermodel.FormulaEvaluator;
import ai2.org.apache.poi.ss.usermodel.FractionFormat;
import ai2.org.apache.poi.ss.util.NumberToTextConverter;
import ai2.org.apache.poi.util.LocaleUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataFormatter
implements Observer {
    private static final String defaultFractionWholePartFormat = "#";
    private static final String defaultFractionFractionPartFormat = "#/##";
    private static final Pattern numPattern = Pattern.compile("[0#]+");
    private static final Pattern daysAsText = Pattern.compile("([d]{3,})", 2);
    private static final Pattern amPmPattern = Pattern.compile("((A|P)[M/P]*)", 2);
    private static final Pattern localePatternGroup = Pattern.compile("(\\[\\$[^-\\]]*-[0-9A-Z]+\\])");
    private static final Pattern colorPattern = Pattern.compile("(\\[BLACK\\])|(\\[BLUE\\])|(\\[CYAN\\])|(\\[GREEN\\])|(\\[MAGENTA\\])|(\\[RED\\])|(\\[WHITE\\])|(\\[YELLOW\\])|(\\[COLOR\\s*\\d\\])|(\\[COLOR\\s*[0-5]\\d\\])", 2);
    private static final Pattern fractionPattern = Pattern.compile("(?:([#\\d]+)\\s+)?(#+)\\s*\\/\\s*([#\\d]+)");
    private static final Pattern fractionStripper = Pattern.compile("(\"[^\"]*\")|([^ \\?#\\d\\/]+)");
    private static final String invalidDateTimeString;
    private DecimalFormatSymbols decimalSymbols;
    private DateFormatSymbols dateSymbols;
    private Format generalWholeNumFormat;
    private Format generalDecimalNumFormat;
    private Format defaultNumFormat;
    private final Map<String, Format> formats = new HashMap<String, Format>();
    private boolean emulateCsv = false;
    private Locale locale;
    private boolean localeIsAdapting = true;
    private final LocaleChangeObservable localeChangedObervable = new LocaleChangeObservable();

    public DataFormatter() {
        this(false);
        this.localeIsAdapting = true;
    }

    public DataFormatter(boolean bl) {
        this(LocaleUtil.getUserLocale(), bl);
        this.localeIsAdapting = true;
    }

    public DataFormatter(Locale locale, boolean bl) {
        this(locale);
        this.emulateCsv = bl;
    }

    public DataFormatter(Locale locale) {
        this.localeChangedObervable.addObserver(this);
        this.localeChangedObervable.checkForLocaleChange(locale);
        this.localeIsAdapting = false;
    }

    private Format getFormat(Cell cell) {
        if (cell.getCellStyle() == null) {
            return null;
        }
        short s = cell.getCellStyle().getDataFormat();
        String string = cell.getCellStyle().getDataFormatString();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return this.getFormat(cell.getNumericCellValue(), s, string);
    }

    private Format getFormat(double d, int n, String string) {
        Format format;
        this.localeChangedObervable.checkForLocaleChange();
        String string2 = string;
        int n2 = string2.indexOf(59);
        int n3 = string2.lastIndexOf(59);
        if (n2 != -1 && n2 != n3) {
            int n4 = string2.indexOf(59, n2 + 1);
            string2 = n4 == n3 ? (d == 0.0 ? string2.substring(n3 + 1) : string2.substring(0, n3)) : (d == 0.0 ? string2.substring(n4 + 1, n3) : string2.substring(0, n4));
        }
        if (this.emulateCsv && d == 0.0 && string2.contains(defaultFractionWholePartFormat) && !string2.contains("0")) {
            string2 = string2.replaceAll(defaultFractionWholePartFormat, "");
        }
        if ((format = this.formats.get(string2)) != null) {
            return format;
        }
        if ("General".equalsIgnoreCase(string2) || "@".equals(string2)) {
            if (DataFormatter.isWholeNumber(d)) {
                return this.generalWholeNumFormat;
            }
            return this.generalDecimalNumFormat;
        }
        format = this.createFormat(d, n, string2);
        this.formats.put(string2, format);
        return format;
    }

    public Format createFormat(Cell cell) {
        short s = cell.getCellStyle().getDataFormat();
        String string = cell.getCellStyle().getDataFormatString();
        return this.createFormat(cell.getNumericCellValue(), s, string);
    }

    private Format createFormat(double d, int n, String string) {
        CharSequence charSequence;
        String string2;
        Object object;
        int n2;
        this.localeChangedObervable.checkForLocaleChange();
        String string3 = string;
        Matcher matcher = colorPattern.matcher(string3);
        while (matcher.find() && (n2 = string3.indexOf((String)(object = matcher.group()))) != -1 && !(string2 = string3.substring(0, n2) + string3.substring(n2 + ((String)object).length())).equals(string3)) {
            string3 = string2;
            matcher = colorPattern.matcher(string3);
        }
        object = localePatternGroup.matcher(string3);
        while (((Matcher)object).find()) {
            String string4 = ((Matcher)object).group();
            string2 = string4.substring(string4.indexOf(36) + 1, string4.indexOf(45));
            if (string2.indexOf(36) > -1) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append(string2.substring(0, string2.indexOf(36)));
                ((StringBuffer)charSequence).append('\\');
                ((StringBuffer)charSequence).append(string2.substring(string2.indexOf(36), string2.length()));
                string2 = ((StringBuffer)charSequence).toString();
            }
            string3 = ((Matcher)object).replaceAll(string2);
            object = localePatternGroup.matcher(string3);
        }
        if (string3 == null || string3.trim().length() == 0) {
            return this.getDefaultFormat(d);
        }
        if ("General".equalsIgnoreCase(string3) || "@".equals(string3)) {
            if (DataFormatter.isWholeNumber(d)) {
                return this.generalWholeNumFormat;
            }
            return this.generalDecimalNumFormat;
        }
        if (DateUtil.isADateFormat(n, string3) && DateUtil.isValidExcelDate(d)) {
            return this.createDateFormat(string3, d);
        }
        if (string3.indexOf("#/") >= 0 || string3.indexOf("?/") >= 0) {
            String[] stringArray = string3.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                charSequence = stringArray[i].replaceAll("\\?", defaultFractionWholePartFormat);
                Matcher matcher2 = fractionStripper.matcher(charSequence);
                charSequence = matcher2.replaceAll(" ");
                Matcher matcher3 = fractionPattern.matcher(charSequence = ((String)charSequence).replaceAll(" +", " "));
                if (!matcher3.find()) continue;
                String string5 = matcher3.group(1) == null ? "" : defaultFractionWholePartFormat;
                return new FractionFormat(string5, matcher3.group(3));
            }
            return new FractionFormat(defaultFractionWholePartFormat, defaultFractionFractionPartFormat);
        }
        if (numPattern.matcher(string3).find()) {
            return this.createNumberFormat(string3, d);
        }
        if (this.emulateCsv) {
            return new ConstantStringFormat(this.cleanFormatForNumber(string3));
        }
        return null;
    }

    private Format createDateFormat(String string, double d) {
        CharSequence charSequence;
        String string2 = string;
        string2 = string2.replaceAll("\\\\-", "-");
        string2 = string2.replaceAll("\\\\,", ",");
        string2 = string2.replaceAll("\\\\\\.", ".");
        string2 = string2.replaceAll("\\\\ ", " ");
        string2 = string2.replaceAll("\\\\/", "/");
        string2 = string2.replaceAll(";@", "");
        string2 = string2.replaceAll("\"/\"", "/");
        string2 = string2.replace("\"\"", "'");
        string2 = string2.replaceAll("\\\\T", "'T'");
        boolean bl = false;
        Matcher matcher = amPmPattern.matcher(string2);
        while (matcher.find()) {
            string2 = matcher.replaceAll("@");
            bl = true;
            matcher = amPmPattern.matcher(string2);
        }
        Matcher matcher2 = daysAsText.matcher(string2 = string2.replaceAll("@", "a"));
        if (matcher2.find()) {
            charSequence = matcher2.group(0).toUpperCase(Locale.ROOT).replaceAll("D", "E");
            string2 = matcher2.replaceAll((String)charSequence);
        }
        charSequence = new StringBuffer();
        char[] cArray = string2.toCharArray();
        boolean bl2 = true;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl3 = false;
        block3: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\'') {
                ((StringBuffer)charSequence).append(c);
                ++i;
                while (i < cArray.length) {
                    c = cArray[i];
                    ((StringBuffer)charSequence).append(c);
                    if (c == '\'') continue block3;
                    ++i;
                }
                continue;
            }
            if (c == '[' && !bl3) {
                bl3 = true;
                bl2 = false;
                ((StringBuffer)charSequence).append(c);
                continue;
            }
            if (c == ']' && bl3) {
                bl3 = false;
                ((StringBuffer)charSequence).append(c);
                continue;
            }
            if (bl3) {
                if (c == 'h' || c == 'H') {
                    ((StringBuffer)charSequence).append('H');
                    continue;
                }
                if (c == 'm' || c == 'M') {
                    ((StringBuffer)charSequence).append('m');
                    continue;
                }
                if (c == 's' || c == 'S') {
                    ((StringBuffer)charSequence).append('s');
                    continue;
                }
                ((StringBuffer)charSequence).append(c);
                continue;
            }
            if (c == 'h' || c == 'H') {
                bl2 = false;
                if (bl) {
                    ((StringBuffer)charSequence).append('h');
                    continue;
                }
                ((StringBuffer)charSequence).append('H');
                continue;
            }
            if (c == 'm' || c == 'M') {
                if (bl2) {
                    ((StringBuffer)charSequence).append('M');
                    arrayList.add(((StringBuffer)charSequence).length() - 1);
                    continue;
                }
                ((StringBuffer)charSequence).append('m');
                continue;
            }
            if (c == 's' || c == 'S') {
                ((StringBuffer)charSequence).append('s');
                for (int j = 0; j < arrayList.size(); ++j) {
                    int n = (Integer)arrayList.get(j);
                    if (((StringBuffer)charSequence).charAt(n) != 'M') continue;
                    ((StringBuffer)charSequence).replace(n, n + 1, "m");
                }
                bl2 = true;
                arrayList.clear();
                continue;
            }
            if (Character.isLetter(c)) {
                bl2 = true;
                arrayList.clear();
                if (c == 'y' || c == 'Y') {
                    ((StringBuffer)charSequence).append('y');
                    continue;
                }
                if (c == 'd' || c == 'D') {
                    ((StringBuffer)charSequence).append('d');
                    continue;
                }
                ((StringBuffer)charSequence).append(c);
                continue;
            }
            ((StringBuffer)charSequence).append(c);
        }
        string2 = ((StringBuffer)charSequence).toString();
        try {
            return new ExcelStyleDateFormatter(string2, this.dateSymbols);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.getDefaultFormat(d);
        }
    }

    private String cleanFormatForNumber(String string) {
        char c;
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.emulateCsv) {
            for (n = 0; n < stringBuffer.length(); ++n) {
                c = stringBuffer.charAt(n);
                if (c != '_' && c != '*' && c != '?' || n > 0 && stringBuffer.charAt(n - 1) == '\\') continue;
                if (c == '?') {
                    stringBuffer.setCharAt(n, ' ');
                    continue;
                }
                if (n >= stringBuffer.length() - 1) continue;
                if (c == '_') {
                    stringBuffer.setCharAt(n + 1, ' ');
                } else {
                    stringBuffer.deleteCharAt(n + 1);
                }
                stringBuffer.deleteCharAt(n);
                --n;
            }
        } else {
            for (n = 0; n < stringBuffer.length(); ++n) {
                c = stringBuffer.charAt(n);
                if (c != '_' && c != '*' || n > 0 && stringBuffer.charAt(n - 1) == '\\') continue;
                if (n < stringBuffer.length() - 1) {
                    stringBuffer.deleteCharAt(n + 1);
                }
                stringBuffer.deleteCharAt(n);
                --n;
            }
        }
        for (n = 0; n < stringBuffer.length(); ++n) {
            c = stringBuffer.charAt(n);
            if (c == '\\' || c == '\"') {
                stringBuffer.deleteCharAt(n);
                --n;
                continue;
            }
            if (c != '+' || n <= 0 || stringBuffer.charAt(n - 1) != 'E') continue;
            stringBuffer.deleteCharAt(n);
            --n;
        }
        return stringBuffer.toString();
    }

    private Format createNumberFormat(String string, double d) {
        String string2 = this.cleanFormatForNumber(string);
        try {
            DecimalFormat decimalFormat = new DecimalFormat(string2, this.decimalSymbols);
            DataFormatter.setExcelStyleRoundingMode(decimalFormat);
            return decimalFormat;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.getDefaultFormat(d);
        }
    }

    private static boolean isWholeNumber(double d) {
        return d == Math.floor(d);
    }

    public Format getDefaultFormat(Cell cell) {
        return this.getDefaultFormat(cell.getNumericCellValue());
    }

    private Format getDefaultFormat(double d) {
        this.localeChangedObervable.checkForLocaleChange();
        if (this.defaultNumFormat != null) {
            return this.defaultNumFormat;
        }
        if (DataFormatter.isWholeNumber(d)) {
            return this.generalWholeNumFormat;
        }
        return this.generalDecimalNumFormat;
    }

    private String performDateFormatting(Date date, Format format) {
        if (format != null) {
            return format.format(date);
        }
        return date.toString();
    }

    private String getFormattedDateString(Cell cell) {
        Format format = this.getFormat(cell);
        if (format instanceof ExcelStyleDateFormatter) {
            ((ExcelStyleDateFormatter)format).setDateToBeFormatted(cell.getNumericCellValue());
        }
        Date date = cell.getDateCellValue();
        return this.performDateFormatting(date, format);
    }

    private String getFormattedNumberString(Cell cell) {
        Format format = this.getFormat(cell);
        double d = cell.getNumericCellValue();
        if (format == null) {
            return String.valueOf(d);
        }
        return format.format(new Double(d));
    }

    public String formatRawCellContents(double d, int n, String string) {
        return this.formatRawCellContents(d, n, string, false);
    }

    public String formatRawCellContents(double d, int n, String string, boolean bl) {
        Format format;
        this.localeChangedObervable.checkForLocaleChange();
        if (DateUtil.isADateFormat(n, string)) {
            if (DateUtil.isValidExcelDate(d)) {
                Format format2 = this.getFormat(d, n, string);
                if (format2 instanceof ExcelStyleDateFormatter) {
                    ((ExcelStyleDateFormatter)format2).setDateToBeFormatted(d);
                }
                Date date = DateUtil.getJavaDate(d, bl);
                return this.performDateFormatting(date, format2);
            }
            if (this.emulateCsv) {
                return invalidDateTimeString;
            }
        }
        if ((format = this.getFormat(d, n, string)) == null) {
            return String.valueOf(d);
        }
        String string2 = NumberToTextConverter.toText(d);
        String string3 = string2.indexOf(69) > -1 ? format.format(new Double(d)) : format.format(new BigDecimal(string2));
        if (string3.indexOf(69) > -1 && !string3.contains("E-")) {
            string3 = string3.replaceFirst("E", "E+");
        }
        return string3;
    }

    public String formatCellValue(Cell cell) {
        return this.formatCellValue(cell, null);
    }

    public String formatCellValue(Cell cell, FormulaEvaluator formulaEvaluator) {
        this.localeChangedObervable.checkForLocaleChange();
        if (cell == null) {
            return "";
        }
        int n = cell.getCellType();
        if (n == 2) {
            if (formulaEvaluator == null) {
                return cell.getCellFormula();
            }
            n = formulaEvaluator.evaluateFormulaCell(cell);
        }
        switch (n) {
            case 0: {
                if (DateUtil.isCellDateFormatted(cell)) {
                    return this.getFormattedDateString(cell);
                }
                return this.getFormattedNumberString(cell);
            }
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 3: {
                return "";
            }
            case 5: {
                return FormulaError.forInt(cell.getErrorCellValue()).getString();
            }
        }
        throw new RuntimeException("Unexpected celltype (" + n + ")");
    }

    public void setDefaultNumberFormat(Format format) {
        for (Map.Entry<String, Format> entry : this.formats.entrySet()) {
            if (entry.getValue() != this.generalDecimalNumFormat && entry.getValue() != this.generalWholeNumFormat) continue;
            entry.setValue(format);
        }
        this.defaultNumFormat = format;
    }

    public void addFormat(String string, Format format) {
        this.formats.put(string, format);
    }

    private static DecimalFormat createIntegerOnlyFormat(String string) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        DecimalFormat decimalFormat = new DecimalFormat(string, decimalFormatSymbols);
        decimalFormat.setParseIntegerOnly(true);
        return decimalFormat;
    }

    public static void setExcelStyleRoundingMode(DecimalFormat decimalFormat) {
        DataFormatter.setExcelStyleRoundingMode(decimalFormat, RoundingMode.HALF_UP);
    }

    public static void setExcelStyleRoundingMode(DecimalFormat decimalFormat, RoundingMode roundingMode) {
        decimalFormat.setRoundingMode(roundingMode);
    }

    public Observable getLocaleChangedObservable() {
        return this.localeChangedObervable;
    }

    public void update(Observable observable, Object object) {
        if (!(object instanceof Locale)) {
            return;
        }
        Locale locale = (Locale)object;
        if (!this.localeIsAdapting || locale.equals(this.locale)) {
            return;
        }
        this.locale = locale;
        this.dateSymbols = DateFormatSymbols.getInstance(this.locale);
        this.decimalSymbols = DecimalFormatSymbols.getInstance(this.locale);
        this.generalWholeNumFormat = new DecimalFormat(defaultFractionWholePartFormat, this.decimalSymbols);
        this.generalDecimalNumFormat = new DecimalFormat("#.##########", this.decimalSymbols);
        this.formats.clear();
        Format format = ZipPlusFourFormat.instance;
        this.addFormat("00000\\-0000", format);
        this.addFormat("00000-0000", format);
        Format format2 = PhoneFormat.instance;
        this.addFormat("[<=9999999]###\\-####;\\(###\\)\\ ###\\-####", format2);
        this.addFormat("[<=9999999]###-####;(###) ###-####", format2);
        this.addFormat("###\\-####;\\(###\\)\\ ###\\-####", format2);
        this.addFormat("###-####;(###) ###-####", format2);
        Format format3 = SSNFormat.instance;
        this.addFormat("000\\-00\\-0000", format3);
        this.addFormat("000-00-0000", format3);
    }

    static /* synthetic */ DecimalFormat access$300(String string) {
        return DataFormatter.createIntegerOnlyFormat(string);
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 255; ++i) {
            stringBuilder.append('#');
        }
        invalidDateTimeString = stringBuilder.toString();
    }

    private static final class ConstantStringFormat
    extends Format {
        private static final DecimalFormat df = DataFormatter.access$300("##########");
        private final String str;

        public ConstantStringFormat(String string) {
            this.str = string;
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(this.str);
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            return df.parseObject(string, parsePosition);
        }
    }

    private static final class PhoneFormat
    extends Format {
        public static final Format instance = new PhoneFormat();
        private static final DecimalFormat df = DataFormatter.access$300("##########");

        private PhoneFormat() {
        }

        public static String format(Number number) {
            String string = df.format(number);
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            if (n <= 4) {
                return string;
            }
            String string2 = string.substring(n - 4, n);
            String string3 = string.substring(Math.max(0, n - 7), n - 4);
            String string4 = string.substring(Math.max(0, n - 10), Math.max(0, n - 7));
            if (string4 != null && string4.trim().length() > 0) {
                stringBuffer.append('(').append(string4).append(") ");
            }
            if (string3 != null && string3.trim().length() > 0) {
                stringBuffer.append(string3).append('-');
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(PhoneFormat.format((Number)object));
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            return df.parseObject(string, parsePosition);
        }
    }

    private static final class ZipPlusFourFormat
    extends Format {
        public static final Format instance = new ZipPlusFourFormat();
        private static final DecimalFormat df = DataFormatter.access$300("000000000");

        private ZipPlusFourFormat() {
        }

        public static String format(Number number) {
            String string = df.format(number);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, 5)).append('-');
            stringBuffer.append(string.substring(5, 9));
            return stringBuffer.toString();
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(ZipPlusFourFormat.format((Number)object));
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            return df.parseObject(string, parsePosition);
        }
    }

    private static final class SSNFormat
    extends Format {
        public static final Format instance = new SSNFormat();
        private static final DecimalFormat df = DataFormatter.access$300("000000000");

        private SSNFormat() {
        }

        public static String format(Number number) {
            String string = df.format(number);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, 3)).append('-');
            stringBuffer.append(string.substring(3, 5)).append('-');
            stringBuffer.append(string.substring(5, 9));
            return stringBuffer.toString();
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(SSNFormat.format((Number)object));
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            return df.parseObject(string, parsePosition);
        }
    }

    private class LocaleChangeObservable
    extends Observable {
        private LocaleChangeObservable() {
        }

        void checkForLocaleChange() {
            this.checkForLocaleChange(LocaleUtil.getUserLocale());
        }

        void checkForLocaleChange(Locale locale) {
            if (!DataFormatter.this.localeIsAdapting) {
                return;
            }
            if (locale.equals(DataFormatter.this.locale)) {
                return;
            }
            super.setChanged();
            this.notifyObservers(locale);
        }
    }
}

