/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.usermodel;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuiltinFormats {
    public static final int FIRST_USER_DEFINED_FORMAT_INDEX = 164;
    private static final String[] _formats;

    private static void putFormat(List<String> list, int n, String string) {
        if (list.size() != n) {
            throw new IllegalStateException("index " + n + " is wrong");
        }
        list.add(string);
    }

    public static Map<Integer, String> getBuiltinFormats() {
        LinkedHashMap<Integer, String> linkedHashMap = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < _formats.length; ++i) {
            linkedHashMap.put(i, _formats[i]);
        }
        return linkedHashMap;
    }

    public static String[] getAll() {
        return (String[])_formats.clone();
    }

    public static String getBuiltinFormat(int n) {
        if (n < 0 || n >= _formats.length) {
            return null;
        }
        return _formats[n];
    }

    public static int getBuiltinFormat(String string) {
        String string2 = string.equalsIgnoreCase("TEXT") ? "@" : string;
        for (int i = 0; i < _formats.length; ++i) {
            if (!string2.equals(_formats[i])) continue;
            return i;
        }
        return -1;
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        BuiltinFormats.putFormat(arrayList, 0, "General");
        BuiltinFormats.putFormat(arrayList, 1, "0");
        BuiltinFormats.putFormat(arrayList, 2, "0.00");
        BuiltinFormats.putFormat(arrayList, 3, "#,##0");
        BuiltinFormats.putFormat(arrayList, 4, "#,##0.00");
        BuiltinFormats.putFormat(arrayList, 5, "\"$\"#,##0_);(\"$\"#,##0)");
        BuiltinFormats.putFormat(arrayList, 6, "\"$\"#,##0_);[Red](\"$\"#,##0)");
        BuiltinFormats.putFormat(arrayList, 7, "\"$\"#,##0.00_);(\"$\"#,##0.00)");
        BuiltinFormats.putFormat(arrayList, 8, "\"$\"#,##0.00_);[Red](\"$\"#,##0.00)");
        BuiltinFormats.putFormat(arrayList, 9, "0%");
        BuiltinFormats.putFormat(arrayList, 10, "0.00%");
        BuiltinFormats.putFormat(arrayList, 11, "0.00E+00");
        BuiltinFormats.putFormat(arrayList, 12, "# ?/?");
        BuiltinFormats.putFormat(arrayList, 13, "# ??/??");
        BuiltinFormats.putFormat(arrayList, 14, "m/d/yy");
        BuiltinFormats.putFormat(arrayList, 15, "d-mmm-yy");
        BuiltinFormats.putFormat(arrayList, 16, "d-mmm");
        BuiltinFormats.putFormat(arrayList, 17, "mmm-yy");
        BuiltinFormats.putFormat(arrayList, 18, "h:mm AM/PM");
        BuiltinFormats.putFormat(arrayList, 19, "h:mm:ss AM/PM");
        BuiltinFormats.putFormat(arrayList, 20, "h:mm");
        BuiltinFormats.putFormat(arrayList, 21, "h:mm:ss");
        BuiltinFormats.putFormat(arrayList, 22, "m/d/yy h:mm");
        for (int i = 23; i <= 36; ++i) {
            BuiltinFormats.putFormat(arrayList, i, "reserved-0x" + Integer.toHexString(i));
        }
        BuiltinFormats.putFormat(arrayList, 37, "#,##0_);(#,##0)");
        BuiltinFormats.putFormat(arrayList, 38, "#,##0_);[Red](#,##0)");
        BuiltinFormats.putFormat(arrayList, 39, "#,##0.00_);(#,##0.00)");
        BuiltinFormats.putFormat(arrayList, 40, "#,##0.00_);[Red](#,##0.00)");
        BuiltinFormats.putFormat(arrayList, 41, "_(\"$\"* #,##0_);_(\"$\"* (#,##0);_(\"$\"* \"-\"_);_(@_)");
        BuiltinFormats.putFormat(arrayList, 42, "_(* #,##0_);_(* (#,##0);_(* \"-\"_);_(@_)");
        BuiltinFormats.putFormat(arrayList, 43, "_(* #,##0.00_);_(* (#,##0.00);_(* \"-\"??_);_(@_)");
        BuiltinFormats.putFormat(arrayList, 44, "_(\"$\"* #,##0.00_);_(\"$\"* (#,##0.00);_(\"$\"* \"-\"??_);_(@_)");
        BuiltinFormats.putFormat(arrayList, 45, "mm:ss");
        BuiltinFormats.putFormat(arrayList, 46, "[h]:mm:ss");
        BuiltinFormats.putFormat(arrayList, 47, "mm:ss.0");
        BuiltinFormats.putFormat(arrayList, 48, "##0.0E+0");
        BuiltinFormats.putFormat(arrayList, 49, "@");
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        _formats = stringArray;
    }
}

