/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.udf;

import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai2.org.apache.poi.ss.formula.udf.UDFFinder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class DefaultUDFFinder
implements UDFFinder {
    private final Map<String, FreeRefFunction> _functionsByName;

    public DefaultUDFFinder(String[] stringArray, FreeRefFunction[] freeRefFunctionArray) {
        int n = stringArray.length;
        if (freeRefFunctionArray.length != n) {
            throw new IllegalArgumentException("Mismatch in number of function names and implementations");
        }
        HashMap<String, FreeRefFunction> hashMap = new HashMap<String, FreeRefFunction>(n * 3 / 2);
        for (int i = 0; i < freeRefFunctionArray.length; ++i) {
            hashMap.put(stringArray[i].toUpperCase(Locale.ROOT), freeRefFunctionArray[i]);
        }
        this._functionsByName = hashMap;
    }

    public FreeRefFunction findFunction(String string) {
        return this._functionsByName.get(string.toUpperCase(Locale.ROOT));
    }
}

