/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.formula.SheetNameFormatter;
import ai2.org.apache.poi.ss.formula.ptg.OperandPtg;
import ai2.org.apache.poi.ss.formula.ptg.Pxg;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class NameXPxg
extends OperandPtg
implements Pxg {
    private int externalWorkbookNumber = -1;
    private String sheetName;
    private String nameName;

    public NameXPxg(int n, String string, String string2) {
        this.externalWorkbookNumber = n;
        this.sheetName = string;
        this.nameName = string2;
    }

    public NameXPxg(String string, String string2) {
        this(-1, string, string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        if (this.externalWorkbookNumber >= 0) {
            stringBuffer.append(" [");
            stringBuffer.append("workbook=").append(this.getExternalWorkbookNumber());
            stringBuffer.append("] ");
        }
        stringBuffer.append("sheet=").append(this.getSheetName());
        stringBuffer.append(" ! ");
        stringBuffer.append("name=");
        stringBuffer.append(this.nameName);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int getExternalWorkbookNumber() {
        return this.externalWorkbookNumber;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getNameName() {
        return this.nameName;
    }

    public void setSheetName(String string) {
        this.sheetName = string;
    }

    public String toFormulaString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.externalWorkbookNumber >= 0) {
            stringBuffer.append('[');
            stringBuffer.append(this.externalWorkbookNumber);
            stringBuffer.append(']');
            bl = true;
        }
        if (this.sheetName != null) {
            SheetNameFormatter.appendFormat(stringBuffer, this.sheetName);
            bl = true;
        }
        if (bl) {
            stringBuffer.append('!');
        }
        stringBuffer.append(this.nameName);
        return stringBuffer.toString();
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public int getSize() {
        return 1;
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        throw new IllegalStateException("XSSF-only Ptg, should not be serialised");
    }
}

