/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.formula.constant.ConstantValueParser;
import ai2.org.apache.poi.ss.formula.constant.ErrorConstant;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.util.NumberToTextConverter;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class ArrayPtg
extends Ptg {
    public static final byte sid = 32;
    private static final int RESERVED_FIELD_LEN = 7;
    public static final int PLAIN_TOKEN_SIZE = 8;
    private final int _reserved0Int;
    private final int _reserved1Short;
    private final int _reserved2Byte;
    private final int _nColumns;
    private final int _nRows;
    private final Object[] _arrayValues;

    ArrayPtg(int n, int n2, int n3, int n4, int n5, Object[] objectArray) {
        this._reserved0Int = n;
        this._reserved1Short = n2;
        this._reserved2Byte = n3;
        this._nColumns = n4;
        this._nRows = n5;
        this._arrayValues = objectArray;
    }

    public ArrayPtg(Object[][] objectArray) {
        int n = objectArray[0].length;
        int n2 = objectArray.length;
        this._nColumns = (short)n;
        this._nRows = (short)n2;
        Object[] objectArray2 = new Object[this._nColumns * this._nRows];
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray3 = objectArray[i];
            for (int j = 0; j < n; ++j) {
                objectArray2[this.getValueIndex((int)j, (int)i)] = objectArray3[j];
            }
        }
        this._arrayValues = objectArray2;
        this._reserved0Int = 0;
        this._reserved1Short = 0;
        this._reserved2Byte = 0;
    }

    public Object[][] getTokenArrayValues() {
        if (this._arrayValues == null) {
            throw new IllegalStateException("array values not read yet");
        }
        Object[][] objectArray = new Object[this._nRows][this._nColumns];
        for (int i = 0; i < this._nRows; ++i) {
            Object[] objectArray2 = objectArray[i];
            for (int j = 0; j < this._nColumns; ++j) {
                objectArray2[j] = this._arrayValues[this.getValueIndex(j, i)];
            }
        }
        return objectArray;
    }

    public boolean isBaseToken() {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ArrayPtg]\n");
        stringBuffer.append("nRows = ").append(this.getRowCount()).append("\n");
        stringBuffer.append("nCols = ").append(this.getColumnCount()).append("\n");
        if (this._arrayValues == null) {
            stringBuffer.append("  #values#uninitialised#\n");
        } else {
            stringBuffer.append("  ").append(this.toFormulaString());
        }
        return stringBuffer.toString();
    }

    int getValueIndex(int n, int n2) {
        if (n < 0 || n >= this._nColumns) {
            throw new IllegalArgumentException("Specified colIx (" + n + ") is outside the allowed range (0.." + (this._nColumns - 1) + ")");
        }
        if (n2 < 0 || n2 >= this._nRows) {
            throw new IllegalArgumentException("Specified rowIx (" + n2 + ") is outside the allowed range (0.." + (this._nRows - 1) + ")");
        }
        return n2 * this._nColumns + n;
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(32 + this.getPtgClass());
        littleEndianOutput.writeInt(this._reserved0Int);
        littleEndianOutput.writeShort(this._reserved1Short);
        littleEndianOutput.writeByte(this._reserved2Byte);
    }

    public int writeTokenValueBytes(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this._nColumns - 1);
        littleEndianOutput.writeShort(this._nRows - 1);
        ConstantValueParser.encode(littleEndianOutput, this._arrayValues);
        return 3 + ConstantValueParser.getEncodedSize(this._arrayValues);
    }

    public int getRowCount() {
        return this._nRows;
    }

    public int getColumnCount() {
        return this._nColumns;
    }

    public int getSize() {
        return 11 + ConstantValueParser.getEncodedSize(this._arrayValues);
    }

    public String toFormulaString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (i > 0) {
                stringBuffer.append(";");
            }
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (j > 0) {
                    stringBuffer.append(",");
                }
                Object object = this._arrayValues[this.getValueIndex(j, i)];
                stringBuffer.append(ArrayPtg.getConstantText(object));
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getConstantText(Object object) {
        if (object == null) {
            throw new RuntimeException("Array item cannot be null");
        }
        if (object instanceof String) {
            return "\"" + (String)object + "\"";
        }
        if (object instanceof Double) {
            return NumberToTextConverter.toText((Double)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "TRUE" : "FALSE";
        }
        if (object instanceof ErrorConstant) {
            return ((ErrorConstant)object).getText();
        }
        throw new IllegalArgumentException("Unexpected constant class (" + object.getClass().getName() + ")");
    }

    public byte getDefaultOperandClass() {
        return 64;
    }

    static final class Initial
    extends Ptg {
        private final int _reserved0;
        private final int _reserved1;
        private final int _reserved2;

        public Initial(LittleEndianInput littleEndianInput) {
            this._reserved0 = littleEndianInput.readInt();
            this._reserved1 = littleEndianInput.readUShort();
            this._reserved2 = littleEndianInput.readUByte();
        }

        private static RuntimeException invalid() {
            throw new IllegalStateException("This object is a partially initialised tArray, and cannot be used as a Ptg");
        }

        public byte getDefaultOperandClass() {
            throw Initial.invalid();
        }

        public int getSize() {
            return 8;
        }

        public boolean isBaseToken() {
            return false;
        }

        public String toFormulaString() {
            throw Initial.invalid();
        }

        public void write(LittleEndianOutput littleEndianOutput) {
            throw Initial.invalid();
        }

        public ArrayPtg finishReading(LittleEndianInput littleEndianInput) {
            int n = littleEndianInput.readUByte();
            short s = littleEndianInput.readShort();
            s = (short)(s + 1);
            int n2 = s * ++n;
            Object[] objectArray = ConstantValueParser.parse(littleEndianInput, n2);
            ArrayPtg arrayPtg = new ArrayPtg(this._reserved0, this._reserved1, this._reserved2, n, s, objectArray);
            arrayPtg.setClass(this.getPtgClass());
            return arrayPtg;
        }
    }
}

