/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.formula.SheetIdentifier;
import ai2.org.apache.poi.ss.formula.SheetNameFormatter;
import ai2.org.apache.poi.ss.formula.SheetRangeIdentifier;
import ai2.org.apache.poi.ss.formula.ptg.AreaPtgBase;
import ai2.org.apache.poi.ss.formula.ptg.Pxg3D;
import ai2.org.apache.poi.ss.util.AreaReference;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class Area3DPxg
extends AreaPtgBase
implements Pxg3D {
    private int externalWorkbookNumber = -1;
    private String firstSheetName;
    private String lastSheetName;

    public Area3DPxg(int n, SheetIdentifier sheetIdentifier, String string) {
        this(n, sheetIdentifier, new AreaReference(string));
    }

    public Area3DPxg(int n, SheetIdentifier sheetIdentifier, AreaReference areaReference) {
        super(areaReference);
        this.externalWorkbookNumber = n;
        this.firstSheetName = sheetIdentifier.getSheetIdentifier().getName();
        this.lastSheetName = sheetIdentifier instanceof SheetRangeIdentifier ? ((SheetRangeIdentifier)sheetIdentifier).getLastSheetIdentifier().getName() : null;
    }

    public Area3DPxg(SheetIdentifier sheetIdentifier, String string) {
        this(sheetIdentifier, new AreaReference(string));
    }

    public Area3DPxg(SheetIdentifier sheetIdentifier, AreaReference areaReference) {
        this(-1, sheetIdentifier, areaReference);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        if (this.externalWorkbookNumber >= 0) {
            stringBuffer.append(" [");
            stringBuffer.append("workbook=").append(this.getExternalWorkbookNumber());
            stringBuffer.append("] ");
        }
        stringBuffer.append("sheet=").append(this.getSheetName());
        if (this.lastSheetName != null) {
            stringBuffer.append(" : ");
            stringBuffer.append("sheet=").append(this.lastSheetName);
        }
        stringBuffer.append(" ! ");
        stringBuffer.append(this.formatReferenceAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int getExternalWorkbookNumber() {
        return this.externalWorkbookNumber;
    }

    public String getSheetName() {
        return this.firstSheetName;
    }

    public String getLastSheetName() {
        return this.lastSheetName;
    }

    public void setSheetName(String string) {
        this.firstSheetName = string;
    }

    public void setLastSheetName(String string) {
        this.lastSheetName = string;
    }

    public String format2DRefAsString() {
        return this.formatReferenceAsString();
    }

    public String toFormulaString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.externalWorkbookNumber >= 0) {
            stringBuffer.append('[');
            stringBuffer.append(this.externalWorkbookNumber);
            stringBuffer.append(']');
        }
        SheetNameFormatter.appendFormat(stringBuffer, this.firstSheetName);
        if (this.lastSheetName != null) {
            stringBuffer.append(':');
            SheetNameFormatter.appendFormat(stringBuffer, this.lastSheetName);
        }
        stringBuffer.append('!');
        stringBuffer.append(this.formatReferenceAsString());
        return stringBuffer.toString();
    }

    public int getSize() {
        return 1;
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        throw new IllegalStateException("XSSF-only Ptg, should not be serialised");
    }
}

