/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.MissingArgEval;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Function;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import java.util.Calendar;

public final class WeekdayFunc
implements Function {
    public static final Function instance = new WeekdayFunc();

    private WeekdayFunc() {
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        try {
            double d;
            if (valueEvalArray.length < 1 || valueEvalArray.length > 2) {
                return ErrorEval.VALUE_INVALID;
            }
            ValueEval valueEval = OperandResolver.getSingleValue(valueEvalArray[0], n, n2);
            double d2 = OperandResolver.coerceValueToDouble(valueEval);
            if (!DateUtil.isValidExcelDate(d2)) {
                return ErrorEval.NUM_ERROR;
            }
            Calendar calendar = DateUtil.getJavaCalendar(d2, false);
            int n3 = calendar.get(7);
            int n4 = 1;
            if (valueEvalArray.length == 2) {
                ValueEval valueEval2 = OperandResolver.getSingleValue(valueEvalArray[1], n, n2);
                if (valueEval2 == MissingArgEval.instance || valueEval2 == BlankEval.instance) {
                    return ErrorEval.NUM_ERROR;
                }
                n4 = OperandResolver.coerceValueToInt(valueEval2);
                if (n4 == 2) {
                    n4 = 11;
                }
            }
            if (n4 == 1) {
                d = n3;
            } else if (n4 == 3) {
                d = (n3 + 6 - 1) % 7;
            } else if (n4 >= 11 && n4 <= 17) {
                d = (n3 + 6 - (n4 - 10)) % 7 + 1;
            } else {
                return ErrorEval.NUM_ERROR;
            }
            return new NumberEval(d);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }
}

