/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;

public class Roman
extends Fixed2ArgFunction {
    public static final int[] VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    public static final String[] ROMAN = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        Object object;
        int n3 = 0;
        try {
            ValueEval valueEval3 = OperandResolver.getSingleValue(valueEval, n, n2);
            n3 = OperandResolver.coerceValueToInt(valueEval3);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
        if (n3 < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        if (n3 > 3999) {
            return ErrorEval.VALUE_INVALID;
        }
        if (n3 == 0) {
            return new StringEval("");
        }
        int n4 = 0;
        try {
            object = OperandResolver.getSingleValue(valueEval2, n, n2);
            n4 = OperandResolver.coerceValueToInt((ValueEval)object);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.NUM_ERROR;
        }
        if (n4 > 4 || n4 < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        object = this.integerToRoman(n3);
        if (n4 == 0) {
            return new StringEval((String)object);
        }
        return new StringEval(this.makeConcise((String)object, n4));
    }

    private String integerToRoman(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 13; ++i) {
            while (n >= VALUES[i]) {
                n -= VALUES[i];
                stringBuilder.append(ROMAN[i]);
            }
        }
        return stringBuilder.toString();
    }

    public String makeConcise(String string, int n) {
        if (n > 0) {
            string = string.replaceAll("XLV", "VL");
            string = string.replaceAll("XCV", "VC");
            string = string.replaceAll("CDL", "LD");
            string = string.replaceAll("CML", "LM");
            string = string.replaceAll("CMVC", "LMVL");
        }
        if (n == 1) {
            string = string.replaceAll("CDXC", "LDXL");
            string = string.replaceAll("CDVC", "LDVL");
            string = string.replaceAll("CMXC", "LMXL");
            string = string.replaceAll("XCIX", "VCIV");
            string = string.replaceAll("XLIX", "VLIV");
        }
        if (n > 1) {
            string = string.replaceAll("XLIX", "IL");
            string = string.replaceAll("XCIX", "IC");
            string = string.replaceAll("CDXC", "XD");
            string = string.replaceAll("CDVC", "XDV");
            string = string.replaceAll("CDIC", "XDIX");
            string = string.replaceAll("LMVL", "XMV");
            string = string.replaceAll("CMIC", "XMIX");
            string = string.replaceAll("CMXC", "XM");
        }
        if (n > 2) {
            string = string.replaceAll("XDV", "VD");
            string = string.replaceAll("XDIX", "VDIV");
            string = string.replaceAll("XMV", "VM");
            string = string.replaceAll("XMIX", "VMIV");
        }
        if (n == 4) {
            string = string.replaceAll("VDIV", "ID");
            string = string.replaceAll("VMIV", "IM");
        }
        return string;
    }
}

