/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.AreaEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Var2or3ArgFunction;

public class Rank
extends Var2or3ArgFunction {
    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        AreaEval areaEval;
        double d;
        try {
            ValueEval valueEval3 = OperandResolver.getSingleValue(valueEval, n, n2);
            d = OperandResolver.coerceValueToDouble(valueEval3);
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            areaEval = Rank.convertRangeArg(valueEval2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return Rank.eval(n, n2, d, areaEval, true);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        AreaEval areaEval;
        double d;
        boolean bl;
        block5: {
            bl = false;
            try {
                ValueEval valueEval4 = OperandResolver.getSingleValue(valueEval, n, n2);
                d = OperandResolver.coerceValueToDouble(valueEval4);
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    throw new EvaluationException(ErrorEval.NUM_ERROR);
                }
                areaEval = Rank.convertRangeArg(valueEval2);
                valueEval4 = OperandResolver.getSingleValue(valueEval3, n, n2);
                int n3 = OperandResolver.coerceValueToInt(valueEval4);
                if (n3 == 0) {
                    bl = true;
                    break block5;
                }
                if (n3 == 1) {
                    bl = false;
                    break block5;
                }
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
        }
        return Rank.eval(n, n2, d, areaEval, bl);
    }

    private static ValueEval eval(int n, int n2, double d, AreaEval areaEval, boolean bl) {
        int n3 = 1;
        int n4 = areaEval.getHeight();
        int n5 = areaEval.getWidth();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                Double d2 = Rank.getValue(areaEval, i, j);
                if (d2 == null || !(bl && d2 > d) && (bl || !(d2 < d))) continue;
                ++n3;
            }
        }
        return new NumberEval(n3);
    }

    private static Double getValue(AreaEval areaEval, int n, int n2) {
        ValueEval valueEval = areaEval.getRelativeValue(n, n2);
        if (valueEval instanceof NumberEval) {
            return ((NumberEval)valueEval).getNumberValue();
        }
        return null;
    }

    private static AreaEval convertRangeArg(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof AreaEval) {
            return (AreaEval)valueEval;
        }
        if (valueEval instanceof RefEval) {
            return ((RefEval)valueEval).offset(0, 0, 0, 0);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }
}

