/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.TwoDEval;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mode
implements Function {
    public static double evaluate(double[] dArray) throws EvaluationException {
        int n;
        int n2;
        if (dArray.length < 2) {
            throw new EvaluationException(ErrorEval.NA);
        }
        int[] nArray = new int[dArray.length];
        Arrays.fill(nArray, 1);
        int n3 = dArray.length;
        for (int i = 0; i < n3; ++i) {
            n2 = dArray.length;
            for (n = i + 1; n < n2; ++n) {
                if (dArray[i] != dArray[n]) continue;
                int n4 = i;
                nArray[n4] = nArray[n4] + 1;
            }
        }
        double d = 0.0;
        n = 0;
        int n5 = nArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            if (nArray[n2] <= n) continue;
            d = dArray[n2];
            n = nArray[n2];
        }
        if (n > 1) {
            return d;
        }
        throw new EvaluationException(ErrorEval.NA);
    }

    @Override
    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        double d;
        try {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i = 0; i < valueEvalArray.length; ++i) {
                Mode.collectValues(valueEvalArray[i], arrayList);
            }
            double[] dArray = new double[arrayList.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (Double)arrayList.get(i);
            }
            d = Mode.evaluate(dArray);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    private static void collectValues(ValueEval valueEval, List<Double> list) throws EvaluationException {
        if (valueEval instanceof TwoDEval) {
            TwoDEval twoDEval = (TwoDEval)valueEval;
            int n = twoDEval.getWidth();
            int n2 = twoDEval.getHeight();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    ValueEval valueEval2 = twoDEval.getValue(i, j);
                    Mode.collectValue(valueEval2, list, false);
                }
            }
            return;
        }
        if (valueEval instanceof RefEval) {
            RefEval refEval = (RefEval)valueEval;
            for (int i = refEval.getFirstSheetIndex(); i <= refEval.getLastSheetIndex(); ++i) {
                Mode.collectValue(refEval.getInnerValueEval(i), list, true);
            }
            return;
        }
        Mode.collectValue(valueEval, list, true);
    }

    private static void collectValue(ValueEval valueEval, List<Double> list, boolean bl) throws EvaluationException {
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        if (valueEval == BlankEval.instance || valueEval instanceof BoolEval || valueEval instanceof StringEval) {
            if (bl) {
                throw EvaluationException.invalidValue();
            }
            return;
        }
        if (valueEval instanceof NumberEval) {
            list.add(new Double(((NumberEval)valueEval).getNumberValue()));
            return;
        }
        throw new RuntimeException("Unexpected value type (" + valueEval.getClass().getName() + ")");
    }
}

