/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.TwoDEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.NumericValueEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.LookupUtils;
import ai2.org.apache.poi.ss.formula.functions.Var2or3ArgFunction;

public final class Match
extends Var2or3ArgFunction {
    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        return Match.eval(n, n2, valueEval, valueEval2, 1.0);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        double d;
        try {
            d = Match.evaluateMatchTypeArg(valueEval3, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.REF_INVALID;
        }
        return Match.eval(n, n2, valueEval, valueEval2, d);
    }

    private static ValueEval eval(int n, int n2, ValueEval valueEval, ValueEval valueEval2, double d) {
        boolean bl = d == 0.0;
        boolean bl2 = d > 0.0;
        try {
            ValueEval valueEval3 = OperandResolver.getSingleValue(valueEval, n, n2);
            LookupUtils.ValueVector valueVector = Match.evaluateLookupRange(valueEval2);
            int n3 = Match.findIndexOfValue(valueEval3, valueVector, bl, bl2);
            return new NumberEval(n3 + 1);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private static LookupUtils.ValueVector evaluateLookupRange(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof RefEval) {
            RefEval refEval = (RefEval)valueEval;
            if (refEval.getNumberOfSheets() == 1) {
                return new SingleValueVector(refEval.getInnerValueEval(refEval.getFirstSheetIndex()));
            }
            return LookupUtils.createVector(refEval);
        }
        if (valueEval instanceof TwoDEval) {
            LookupUtils.ValueVector valueVector = LookupUtils.createVector((TwoDEval)valueEval);
            if (valueVector == null) {
                throw new EvaluationException(ErrorEval.NA);
            }
            return valueVector;
        }
        if (valueEval instanceof NumericValueEval) {
            throw new EvaluationException(ErrorEval.NA);
        }
        if (valueEval instanceof StringEval) {
            StringEval stringEval = (StringEval)valueEval;
            Double d = OperandResolver.parseDouble(stringEval.getStringValue());
            if (d == null) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            throw new EvaluationException(ErrorEval.NA);
        }
        throw new RuntimeException("Unexpected eval type (" + valueEval.getClass().getName() + ")");
    }

    private static double evaluateMatchTypeArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        if (valueEval2 instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval2);
        }
        if (valueEval2 instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)valueEval2;
            return numericValueEval.getNumberValue();
        }
        if (valueEval2 instanceof StringEval) {
            StringEval stringEval = (StringEval)valueEval2;
            Double d = OperandResolver.parseDouble(stringEval.getStringValue());
            if (d == null) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return d;
        }
        throw new RuntimeException("Unexpected match_type type (" + valueEval2.getClass().getName() + ")");
    }

    private static int findIndexOfValue(ValueEval valueEval, LookupUtils.ValueVector valueVector, boolean bl, boolean bl2) throws EvaluationException {
        LookupUtils.LookupValueComparer lookupValueComparer = Match.createLookupComparer(valueEval, bl);
        int n = valueVector.getSize();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                if (!lookupValueComparer.compareTo(valueVector.getItem(i)).isEqual()) continue;
                return i;
            }
            throw new EvaluationException(ErrorEval.NA);
        }
        if (bl2) {
            for (int i = n - 1; i >= 0; --i) {
                LookupUtils.CompareResult compareResult = lookupValueComparer.compareTo(valueVector.getItem(i));
                if (compareResult.isTypeMismatch() || compareResult.isLessThan()) continue;
                return i;
            }
            throw new EvaluationException(ErrorEval.NA);
        }
        for (int i = 0; i < n; ++i) {
            LookupUtils.CompareResult compareResult = lookupValueComparer.compareTo(valueVector.getItem(i));
            if (compareResult.isEqual()) {
                return i;
            }
            if (!compareResult.isGreaterThan()) continue;
            if (i < 1) {
                throw new EvaluationException(ErrorEval.NA);
            }
            return i - 1;
        }
        return n - 1;
    }

    private static LookupUtils.LookupValueComparer createLookupComparer(ValueEval valueEval, boolean bl) {
        return LookupUtils.createLookupComparer(valueEval, bl, true);
    }

    private static final class SingleValueVector
    implements LookupUtils.ValueVector {
        private final ValueEval _value;

        public SingleValueVector(ValueEval valueEval) {
            this._value = valueEval;
        }

        public ValueEval getItem(int n) {
            if (n != 0) {
                throw new RuntimeException("Invalid index (" + n + ") only zero is allowed");
            }
            return this._value;
        }

        public int getSize() {
            return 1;
        }
    }
}

