/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.AreaEval;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Function;

public abstract class LogicalFunction
extends Fixed1ArgFunction {
    public static final Function ISLOGICAL = new LogicalFunction(){

        protected boolean evaluate(ValueEval valueEval) {
            return valueEval instanceof BoolEval;
        }
    };
    public static final Function ISNONTEXT = new LogicalFunction(){

        protected boolean evaluate(ValueEval valueEval) {
            return !(valueEval instanceof StringEval);
        }
    };
    public static final Function ISNUMBER = new LogicalFunction(){

        protected boolean evaluate(ValueEval valueEval) {
            return valueEval instanceof NumberEval;
        }
    };
    public static final Function ISTEXT = new LogicalFunction(){

        protected boolean evaluate(ValueEval valueEval) {
            return valueEval instanceof StringEval;
        }
    };
    public static final Function ISBLANK = new LogicalFunction(){

        protected boolean evaluate(ValueEval valueEval) {
            return valueEval instanceof BlankEval;
        }
    };
    public static final Function ISERROR = new LogicalFunction(){

        protected boolean evaluate(ValueEval valueEval) {
            return valueEval instanceof ErrorEval;
        }
    };
    public static final Function ISERR = new LogicalFunction(){

        protected boolean evaluate(ValueEval valueEval) {
            if (valueEval instanceof ErrorEval) {
                return valueEval != ErrorEval.NA;
            }
            return false;
        }
    };
    public static final Function ISNA = new LogicalFunction(){

        protected boolean evaluate(ValueEval valueEval) {
            return valueEval == ErrorEval.NA;
        }
    };
    public static final Function ISREF = new Fixed1ArgFunction(){

        public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
            if (valueEval instanceof RefEval || valueEval instanceof AreaEval) {
                return BoolEval.TRUE;
            }
            return BoolEval.FALSE;
        }
    };

    public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
        ValueEval valueEval2;
        try {
            valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        }
        catch (EvaluationException evaluationException) {
            valueEval2 = evaluationException.getErrorEval();
        }
        return BoolEval.valueOf(this.evaluate(valueEval2));
    }

    protected abstract boolean evaluate(ValueEval var1);
}

