/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import ai2.org.apache.poi.util.LocaleUtil;
import java.util.Calendar;
import java.util.Date;

public class EDate
implements FreeRefFunction {
    public static final FreeRefFunction instance = new EDate();

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double d = this.getValue(valueEvalArray[0]);
            int n = (int)this.getValue(valueEvalArray[1]);
            Date date = DateUtil.getJavaDate(d);
            Calendar calendar = LocaleUtil.getLocaleCalendar();
            calendar.setTime(date);
            calendar.add(2, n);
            return new NumberEval(DateUtil.getExcelDate(calendar.getTime()));
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private double getValue(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof NumberEval) {
            return ((NumberEval)valueEval).getNumberValue();
        }
        if (valueEval instanceof BlankEval) {
            return 0.0;
        }
        if (valueEval instanceof RefEval) {
            RefEval refEval = (RefEval)valueEval;
            if (refEval.getNumberOfSheets() > 1) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            ValueEval valueEval2 = refEval.getInnerValueEval(refEval.getFirstSheetIndex());
            if (valueEval2 instanceof NumberEval) {
                return ((NumberEval)valueEval2).getNumberValue();
            }
            if (valueEval2 instanceof BlankEval) {
                return 0.0;
            }
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }
}

