/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.TwoDEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.MissingArgEval;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.CountUtils;
import ai2.org.apache.poi.ss.formula.functions.Function;

public final class Count
implements Function {
    private final CountUtils.I_MatchPredicate _predicate;
    private static final CountUtils.I_MatchPredicate defaultPredicate = new CountUtils.I_MatchPredicate(){

        public boolean matches(ValueEval valueEval) {
            if (valueEval instanceof NumberEval) {
                return true;
            }
            return valueEval == MissingArgEval.instance;
        }
    };
    private static final CountUtils.I_MatchPredicate subtotalPredicate = new CountUtils.I_MatchAreaPredicate(){

        public boolean matches(ValueEval valueEval) {
            return defaultPredicate.matches(valueEval);
        }

        public boolean matches(TwoDEval twoDEval, int n, int n2) {
            return !twoDEval.isSubTotal(n, n2);
        }
    };

    public Count() {
        this._predicate = defaultPredicate;
    }

    private Count(CountUtils.I_MatchPredicate i_MatchPredicate) {
        this._predicate = i_MatchPredicate;
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        int n3 = valueEvalArray.length;
        if (n3 < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        if (n3 > 30) {
            return ErrorEval.VALUE_INVALID;
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 += CountUtils.countArg(valueEvalArray[i], this._predicate);
        }
        return new NumberEval(n4);
    }

    public static Count subtotalInstance() {
        return new Count(subtotalPredicate);
    }
}

