/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Function;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import java.util.Calendar;

public final class CalendarFieldFunction
extends Fixed1ArgFunction {
    public static final Function YEAR = new CalendarFieldFunction(1);
    public static final Function MONTH = new CalendarFieldFunction(2);
    public static final Function DAY = new CalendarFieldFunction(5);
    public static final Function HOUR = new CalendarFieldFunction(11);
    public static final Function MINUTE = new CalendarFieldFunction(12);
    public static final Function SECOND = new CalendarFieldFunction(13);
    private final int _dateFieldId;

    private CalendarFieldFunction(int n) {
        this._dateFieldId = n;
    }

    public final ValueEval evaluate(int n, int n2, ValueEval valueEval) {
        double d;
        try {
            ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
            d = OperandResolver.coerceValueToDouble(valueEval2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        if (d < 0.0) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(this.getCalField(d));
    }

    private int getCalField(double d) {
        if ((int)d == 0) {
            switch (this._dateFieldId) {
                case 1: {
                    return 1900;
                }
                case 2: {
                    return 1;
                }
                case 5: {
                    return 0;
                }
            }
        }
        Calendar calendar = DateUtil.getJavaCalendarUTC(d + 5.78125E-6, false);
        int n = calendar.get(this._dateFieldId);
        if (this._dateFieldId == 2) {
            ++n;
        }
        return n;
    }
}

