/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.function;

import ai2.org.apache.poi.ss.formula.function.FunctionMetadata;
import ai2.org.apache.poi.ss.formula.function.FunctionMetadataReader;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionMetadataRegistry {
    public static final String FUNCTION_NAME_IF = "IF";
    public static final int FUNCTION_INDEX_IF = 1;
    public static final short FUNCTION_INDEX_SUM = 4;
    public static final int FUNCTION_INDEX_CHOOSE = 100;
    public static final short FUNCTION_INDEX_INDIRECT = 148;
    public static final short FUNCTION_INDEX_EXTERNAL = 255;
    private static FunctionMetadataRegistry _instance;
    private final FunctionMetadata[] _functionDataByIndex;
    private final Map<String, FunctionMetadata> _functionDataByName;

    private static FunctionMetadataRegistry getInstance() {
        if (_instance == null) {
            _instance = FunctionMetadataReader.createRegistry();
        }
        return _instance;
    }

    FunctionMetadataRegistry(FunctionMetadata[] functionMetadataArray, Map<String, FunctionMetadata> map) {
        this._functionDataByIndex = functionMetadataArray;
        this._functionDataByName = map;
    }

    Set<String> getAllFunctionNames() {
        return this._functionDataByName.keySet();
    }

    public static FunctionMetadata getFunctionByIndex(int n) {
        return FunctionMetadataRegistry.getInstance().getFunctionByIndexInternal(n);
    }

    private FunctionMetadata getFunctionByIndexInternal(int n) {
        return this._functionDataByIndex[n];
    }

    public static short lookupIndexByName(String string) {
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getInstance().getFunctionByNameInternal(string);
        if (functionMetadata == null) {
            return -1;
        }
        return (short)functionMetadata.getIndex();
    }

    private FunctionMetadata getFunctionByNameInternal(String string) {
        return this._functionDataByName.get(string);
    }

    public static FunctionMetadata getFunctionByName(String string) {
        return FunctionMetadataRegistry.getInstance().getFunctionByNameInternal(string);
    }
}

